<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfSearchEntityView Array
 * @subpackage Arrays
 */
class ArrayOfSearchEntityView extends AbstractStructArrayBase
{
    /**
     * The SearchEntityView
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\SearchEntityView[]
     */
    public $SearchEntityView;
    /**
     * Constructor method for ArrayOfSearchEntityView
     * @uses ArrayOfSearchEntityView::setSearchEntityView()
     * @param \SGCIS\Struct\SearchEntityView[] $searchEntityView
     */
    public function __construct(array $searchEntityView = array())
    {
        $this
            ->setSearchEntityView($searchEntityView);
    }
    /**
     * Get SearchEntityView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\SearchEntityView[]|null
     */
    public function getSearchEntityView()
    {
        return isset($this->SearchEntityView) ? $this->SearchEntityView : null;
    }
    /**
     * Set SearchEntityView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SearchEntityView[] $searchEntityView
     * @return \SGCIS\Array\ArrayOfSearchEntityView
     */
    public function setSearchEntityView(array $searchEntityView = array())
    {
        foreach ($searchEntityView as $arrayOfSearchEntityViewSearchEntityViewItem) {
            // validation for constraint: itemType
            if (!$arrayOfSearchEntityViewSearchEntityViewItem instanceof \SGCIS\Struct\SearchEntityView) {
                throw new \InvalidArgumentException(sprintf('The SearchEntityView property can only contain items of \SGCIS\Struct\SearchEntityView, "%s" given', is_object($arrayOfSearchEntityViewSearchEntityViewItem) ? get_class($arrayOfSearchEntityViewSearchEntityViewItem) : gettype($arrayOfSearchEntityViewSearchEntityViewItem)), __LINE__);
            }
        }
        if (is_null($searchEntityView) || (is_array($searchEntityView) && empty($searchEntityView))) {
            unset($this->SearchEntityView);
        } else {
            $this->SearchEntityView = $searchEntityView;
        }
        return $this;
    }
    /**
     * Add item to SearchEntityView value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\SearchEntityView $item
     * @return \SGCIS\Array\ArrayOfSearchEntityView
     */
    public function addToSearchEntityView(\SGCIS\Struct\SearchEntityView $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\SearchEntityView) {
            throw new \InvalidArgumentException(sprintf('The SearchEntityView property can only contain items of \SGCIS\Struct\SearchEntityView, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SearchEntityView[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\SearchEntityView|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\SearchEntityView|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\SearchEntityView|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\SearchEntityView|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\SearchEntityView|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SearchEntityView
     */
    public function getAttributeName()
    {
        return 'SearchEntityView';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfSearchEntityView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
