<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRateCharacteristic Array
 * @subpackage Arrays
 */
class ArrayOfRateCharacteristic extends AbstractStructArrayBase
{
    /**
     * The RateCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\RateCharacteristic[]
     */
    public $RateCharacteristic;
    /**
     * Constructor method for ArrayOfRateCharacteristic
     * @uses ArrayOfRateCharacteristic::setRateCharacteristic()
     * @param \SGCIS\Struct\RateCharacteristic[] $rateCharacteristic
     */
    public function __construct(array $rateCharacteristic = array())
    {
        $this
            ->setRateCharacteristic($rateCharacteristic);
    }
    /**
     * Get RateCharacteristic value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\RateCharacteristic[]|null
     */
    public function getRateCharacteristic()
    {
        return isset($this->RateCharacteristic) ? $this->RateCharacteristic : null;
    }
    /**
     * Set RateCharacteristic value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\RateCharacteristic[] $rateCharacteristic
     * @return \SGCIS\Array\ArrayOfRateCharacteristic
     */
    public function setRateCharacteristic(array $rateCharacteristic = array())
    {
        foreach ($rateCharacteristic as $arrayOfRateCharacteristicRateCharacteristicItem) {
            // validation for constraint: itemType
            if (!$arrayOfRateCharacteristicRateCharacteristicItem instanceof \SGCIS\Struct\RateCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The RateCharacteristic property can only contain items of \SGCIS\Struct\RateCharacteristic, "%s" given', is_object($arrayOfRateCharacteristicRateCharacteristicItem) ? get_class($arrayOfRateCharacteristicRateCharacteristicItem) : gettype($arrayOfRateCharacteristicRateCharacteristicItem)), __LINE__);
            }
        }
        if (is_null($rateCharacteristic) || (is_array($rateCharacteristic) && empty($rateCharacteristic))) {
            unset($this->RateCharacteristic);
        } else {
            $this->RateCharacteristic = $rateCharacteristic;
        }
        return $this;
    }
    /**
     * Add item to RateCharacteristic value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\RateCharacteristic $item
     * @return \SGCIS\Array\ArrayOfRateCharacteristic
     */
    public function addToRateCharacteristic(\SGCIS\Struct\RateCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\RateCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The RateCharacteristic property can only contain items of \SGCIS\Struct\RateCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RateCharacteristic[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\RateCharacteristic|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\RateCharacteristic|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\RateCharacteristic|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\RateCharacteristic|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\RateCharacteristic|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RateCharacteristic
     */
    public function getAttributeName()
    {
        return 'RateCharacteristic';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfRateCharacteristic
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
