<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductDisplayTDSP Array
 * @subpackage Arrays
 */
class ArrayOfProductDisplayTDSP extends AbstractStructArrayBase
{
    /**
     * The ProductDisplayTDSP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ProductDisplayTDSP[]
     */
    public $ProductDisplayTDSP;
    /**
     * Constructor method for ArrayOfProductDisplayTDSP
     * @uses ArrayOfProductDisplayTDSP::setProductDisplayTDSP()
     * @param \SGCIS\Struct\ProductDisplayTDSP[] $productDisplayTDSP
     */
    public function __construct(array $productDisplayTDSP = array())
    {
        $this
            ->setProductDisplayTDSP($productDisplayTDSP);
    }
    /**
     * Get ProductDisplayTDSP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ProductDisplayTDSP[]|null
     */
    public function getProductDisplayTDSP()
    {
        return isset($this->ProductDisplayTDSP) ? $this->ProductDisplayTDSP : null;
    }
    /**
     * Set ProductDisplayTDSP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductDisplayTDSP[] $productDisplayTDSP
     * @return \SGCIS\Array\ArrayOfProductDisplayTDSP
     */
    public function setProductDisplayTDSP(array $productDisplayTDSP = array())
    {
        foreach ($productDisplayTDSP as $arrayOfProductDisplayTDSPProductDisplayTDSPItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductDisplayTDSPProductDisplayTDSPItem instanceof \SGCIS\Struct\ProductDisplayTDSP) {
                throw new \InvalidArgumentException(sprintf('The ProductDisplayTDSP property can only contain items of \SGCIS\Struct\ProductDisplayTDSP, "%s" given', is_object($arrayOfProductDisplayTDSPProductDisplayTDSPItem) ? get_class($arrayOfProductDisplayTDSPProductDisplayTDSPItem) : gettype($arrayOfProductDisplayTDSPProductDisplayTDSPItem)), __LINE__);
            }
        }
        if (is_null($productDisplayTDSP) || (is_array($productDisplayTDSP) && empty($productDisplayTDSP))) {
            unset($this->ProductDisplayTDSP);
        } else {
            $this->ProductDisplayTDSP = $productDisplayTDSP;
        }
        return $this;
    }
    /**
     * Add item to ProductDisplayTDSP value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductDisplayTDSP $item
     * @return \SGCIS\Array\ArrayOfProductDisplayTDSP
     */
    public function addToProductDisplayTDSP(\SGCIS\Struct\ProductDisplayTDSP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ProductDisplayTDSP) {
            throw new \InvalidArgumentException(sprintf('The ProductDisplayTDSP property can only contain items of \SGCIS\Struct\ProductDisplayTDSP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductDisplayTDSP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ProductDisplayTDSP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ProductDisplayTDSP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ProductDisplayTDSP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ProductDisplayTDSP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ProductDisplayTDSP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductDisplayTDSP
     */
    public function getAttributeName()
    {
        return 'ProductDisplayTDSP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProductDisplayTDSP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
