<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductAudit Array
 * @subpackage Arrays
 */
class ArrayOfProductAudit extends AbstractStructArrayBase
{
    /**
     * The ProductAudit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ProductAudit[]
     */
    public $ProductAudit;
    /**
     * Constructor method for ArrayOfProductAudit
     * @uses ArrayOfProductAudit::setProductAudit()
     * @param \SGCIS\Struct\ProductAudit[] $productAudit
     */
    public function __construct(array $productAudit = array())
    {
        $this
            ->setProductAudit($productAudit);
    }
    /**
     * Get ProductAudit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ProductAudit[]|null
     */
    public function getProductAudit()
    {
        return isset($this->ProductAudit) ? $this->ProductAudit : null;
    }
    /**
     * Set ProductAudit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductAudit[] $productAudit
     * @return \SGCIS\Array\ArrayOfProductAudit
     */
    public function setProductAudit(array $productAudit = array())
    {
        foreach ($productAudit as $arrayOfProductAuditProductAuditItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductAuditProductAuditItem instanceof \SGCIS\Struct\ProductAudit) {
                throw new \InvalidArgumentException(sprintf('The ProductAudit property can only contain items of \SGCIS\Struct\ProductAudit, "%s" given', is_object($arrayOfProductAuditProductAuditItem) ? get_class($arrayOfProductAuditProductAuditItem) : gettype($arrayOfProductAuditProductAuditItem)), __LINE__);
            }
        }
        if (is_null($productAudit) || (is_array($productAudit) && empty($productAudit))) {
            unset($this->ProductAudit);
        } else {
            $this->ProductAudit = $productAudit;
        }
        return $this;
    }
    /**
     * Add item to ProductAudit value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductAudit $item
     * @return \SGCIS\Array\ArrayOfProductAudit
     */
    public function addToProductAudit(\SGCIS\Struct\ProductAudit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ProductAudit) {
            throw new \InvalidArgumentException(sprintf('The ProductAudit property can only contain items of \SGCIS\Struct\ProductAudit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductAudit[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ProductAudit|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ProductAudit|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ProductAudit|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ProductAudit|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ProductAudit|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductAudit
     */
    public function getAttributeName()
    {
        return 'ProductAudit';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProductAudit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
