<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfProductAccountType Array
 * @subpackage Arrays
 */
class ArrayOfProductAccountType extends AbstractStructArrayBase
{
    /**
     * The ProductAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ProductAccountType[]
     */
    public $ProductAccountType;
    /**
     * Constructor method for ArrayOfProductAccountType
     * @uses ArrayOfProductAccountType::setProductAccountType()
     * @param \SGCIS\Struct\ProductAccountType[] $productAccountType
     */
    public function __construct(array $productAccountType = array())
    {
        $this
            ->setProductAccountType($productAccountType);
    }
    /**
     * Get ProductAccountType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ProductAccountType[]|null
     */
    public function getProductAccountType()
    {
        return isset($this->ProductAccountType) ? $this->ProductAccountType : null;
    }
    /**
     * Set ProductAccountType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductAccountType[] $productAccountType
     * @return \SGCIS\Array\ArrayOfProductAccountType
     */
    public function setProductAccountType(array $productAccountType = array())
    {
        foreach ($productAccountType as $arrayOfProductAccountTypeProductAccountTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfProductAccountTypeProductAccountTypeItem instanceof \SGCIS\Struct\ProductAccountType) {
                throw new \InvalidArgumentException(sprintf('The ProductAccountType property can only contain items of \SGCIS\Struct\ProductAccountType, "%s" given', is_object($arrayOfProductAccountTypeProductAccountTypeItem) ? get_class($arrayOfProductAccountTypeProductAccountTypeItem) : gettype($arrayOfProductAccountTypeProductAccountTypeItem)), __LINE__);
            }
        }
        if (is_null($productAccountType) || (is_array($productAccountType) && empty($productAccountType))) {
            unset($this->ProductAccountType);
        } else {
            $this->ProductAccountType = $productAccountType;
        }
        return $this;
    }
    /**
     * Add item to ProductAccountType value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ProductAccountType $item
     * @return \SGCIS\Array\ArrayOfProductAccountType
     */
    public function addToProductAccountType(\SGCIS\Struct\ProductAccountType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ProductAccountType) {
            throw new \InvalidArgumentException(sprintf('The ProductAccountType property can only contain items of \SGCIS\Struct\ProductAccountType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ProductAccountType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ProductAccountType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ProductAccountType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ProductAccountType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ProductAccountType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ProductAccountType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ProductAccountType
     */
    public function getAttributeName()
    {
        return 'ProductAccountType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfProductAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
