<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentLocation Array
 * @subpackage Arrays
 */
class ArrayOfPaymentLocation extends AbstractStructArrayBase
{
    /**
     * The PaymentLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PaymentLocation[]
     */
    public $PaymentLocation;
    /**
     * Constructor method for ArrayOfPaymentLocation
     * @uses ArrayOfPaymentLocation::setPaymentLocation()
     * @param \SGCIS\Struct\PaymentLocation[] $paymentLocation
     */
    public function __construct(array $paymentLocation = array())
    {
        $this
            ->setPaymentLocation($paymentLocation);
    }
    /**
     * Get PaymentLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PaymentLocation[]|null
     */
    public function getPaymentLocation()
    {
        return isset($this->PaymentLocation) ? $this->PaymentLocation : null;
    }
    /**
     * Set PaymentLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentLocation[] $paymentLocation
     * @return \SGCIS\Array\ArrayOfPaymentLocation
     */
    public function setPaymentLocation(array $paymentLocation = array())
    {
        foreach ($paymentLocation as $arrayOfPaymentLocationPaymentLocationItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentLocationPaymentLocationItem instanceof \SGCIS\Struct\PaymentLocation) {
                throw new \InvalidArgumentException(sprintf('The PaymentLocation property can only contain items of \SGCIS\Struct\PaymentLocation, "%s" given', is_object($arrayOfPaymentLocationPaymentLocationItem) ? get_class($arrayOfPaymentLocationPaymentLocationItem) : gettype($arrayOfPaymentLocationPaymentLocationItem)), __LINE__);
            }
        }
        if (is_null($paymentLocation) || (is_array($paymentLocation) && empty($paymentLocation))) {
            unset($this->PaymentLocation);
        } else {
            $this->PaymentLocation = $paymentLocation;
        }
        return $this;
    }
    /**
     * Add item to PaymentLocation value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentLocation $item
     * @return \SGCIS\Array\ArrayOfPaymentLocation
     */
    public function addToPaymentLocation(\SGCIS\Struct\PaymentLocation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PaymentLocation) {
            throw new \InvalidArgumentException(sprintf('The PaymentLocation property can only contain items of \SGCIS\Struct\PaymentLocation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentLocation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PaymentLocation|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PaymentLocation|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PaymentLocation|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PaymentLocation|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PaymentLocation|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentLocation
     */
    public function getAttributeName()
    {
        return 'PaymentLocation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPaymentLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
