<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaymentArrangement Array
 * @subpackage Arrays
 */
class ArrayOfPaymentArrangement extends AbstractStructArrayBase
{
    /**
     * The PaymentArrangement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\PaymentArrangement[]
     */
    public $PaymentArrangement;
    /**
     * Constructor method for ArrayOfPaymentArrangement
     * @uses ArrayOfPaymentArrangement::setPaymentArrangement()
     * @param \SGCIS\Struct\PaymentArrangement[] $paymentArrangement
     */
    public function __construct(array $paymentArrangement = array())
    {
        $this
            ->setPaymentArrangement($paymentArrangement);
    }
    /**
     * Get PaymentArrangement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\PaymentArrangement[]|null
     */
    public function getPaymentArrangement()
    {
        return isset($this->PaymentArrangement) ? $this->PaymentArrangement : null;
    }
    /**
     * Set PaymentArrangement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentArrangement[] $paymentArrangement
     * @return \SGCIS\Array\ArrayOfPaymentArrangement
     */
    public function setPaymentArrangement(array $paymentArrangement = array())
    {
        foreach ($paymentArrangement as $arrayOfPaymentArrangementPaymentArrangementItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaymentArrangementPaymentArrangementItem instanceof \SGCIS\Struct\PaymentArrangement) {
                throw new \InvalidArgumentException(sprintf('The PaymentArrangement property can only contain items of \SGCIS\Struct\PaymentArrangement, "%s" given', is_object($arrayOfPaymentArrangementPaymentArrangementItem) ? get_class($arrayOfPaymentArrangementPaymentArrangementItem) : gettype($arrayOfPaymentArrangementPaymentArrangementItem)), __LINE__);
            }
        }
        if (is_null($paymentArrangement) || (is_array($paymentArrangement) && empty($paymentArrangement))) {
            unset($this->PaymentArrangement);
        } else {
            $this->PaymentArrangement = $paymentArrangement;
        }
        return $this;
    }
    /**
     * Add item to PaymentArrangement value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\PaymentArrangement $item
     * @return \SGCIS\Array\ArrayOfPaymentArrangement
     */
    public function addToPaymentArrangement(\SGCIS\Struct\PaymentArrangement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\PaymentArrangement) {
            throw new \InvalidArgumentException(sprintf('The PaymentArrangement property can only contain items of \SGCIS\Struct\PaymentArrangement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaymentArrangement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\PaymentArrangement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\PaymentArrangement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\PaymentArrangement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\PaymentArrangement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\PaymentArrangement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaymentArrangement
     */
    public function getAttributeName()
    {
        return 'PaymentArrangement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfPaymentArrangement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
