<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMeterRead Array
 * @subpackage Arrays
 */
class ArrayOfMeterRead extends AbstractStructArrayBase
{
    /**
     * The MeterRead
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\MeterRead[]
     */
    public $MeterRead;
    /**
     * Constructor method for ArrayOfMeterRead
     * @uses ArrayOfMeterRead::setMeterRead()
     * @param \SGCIS\Struct\MeterRead[] $meterRead
     */
    public function __construct(array $meterRead = array())
    {
        $this
            ->setMeterRead($meterRead);
    }
    /**
     * Get MeterRead value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\MeterRead[]|null
     */
    public function getMeterRead()
    {
        return isset($this->MeterRead) ? $this->MeterRead : null;
    }
    /**
     * Set MeterRead value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterRead[] $meterRead
     * @return \SGCIS\Array\ArrayOfMeterRead
     */
    public function setMeterRead(array $meterRead = array())
    {
        foreach ($meterRead as $arrayOfMeterReadMeterReadItem) {
            // validation for constraint: itemType
            if (!$arrayOfMeterReadMeterReadItem instanceof \SGCIS\Struct\MeterRead) {
                throw new \InvalidArgumentException(sprintf('The MeterRead property can only contain items of \SGCIS\Struct\MeterRead, "%s" given', is_object($arrayOfMeterReadMeterReadItem) ? get_class($arrayOfMeterReadMeterReadItem) : gettype($arrayOfMeterReadMeterReadItem)), __LINE__);
            }
        }
        if (is_null($meterRead) || (is_array($meterRead) && empty($meterRead))) {
            unset($this->MeterRead);
        } else {
            $this->MeterRead = $meterRead;
        }
        return $this;
    }
    /**
     * Add item to MeterRead value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterRead $item
     * @return \SGCIS\Array\ArrayOfMeterRead
     */
    public function addToMeterRead(\SGCIS\Struct\MeterRead $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\MeterRead) {
            throw new \InvalidArgumentException(sprintf('The MeterRead property can only contain items of \SGCIS\Struct\MeterRead, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MeterRead[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\MeterRead|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\MeterRead|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\MeterRead|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\MeterRead|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\MeterRead|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MeterRead
     */
    public function getAttributeName()
    {
        return 'MeterRead';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfMeterRead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
