<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMeterCopy Array
 * @subpackage Arrays
 */
class ArrayOfMeterCopy extends AbstractStructArrayBase
{
    /**
     * The MeterCopy
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\MeterCopy[]
     */
    public $MeterCopy;
    /**
     * Constructor method for ArrayOfMeterCopy
     * @uses ArrayOfMeterCopy::setMeterCopy()
     * @param \SGCIS\Struct\MeterCopy[] $meterCopy
     */
    public function __construct(array $meterCopy = array())
    {
        $this
            ->setMeterCopy($meterCopy);
    }
    /**
     * Get MeterCopy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\MeterCopy[]|null
     */
    public function getMeterCopy()
    {
        return isset($this->MeterCopy) ? $this->MeterCopy : null;
    }
    /**
     * Set MeterCopy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterCopy[] $meterCopy
     * @return \SGCIS\Array\ArrayOfMeterCopy
     */
    public function setMeterCopy(array $meterCopy = array())
    {
        foreach ($meterCopy as $arrayOfMeterCopyMeterCopyItem) {
            // validation for constraint: itemType
            if (!$arrayOfMeterCopyMeterCopyItem instanceof \SGCIS\Struct\MeterCopy) {
                throw new \InvalidArgumentException(sprintf('The MeterCopy property can only contain items of \SGCIS\Struct\MeterCopy, "%s" given', is_object($arrayOfMeterCopyMeterCopyItem) ? get_class($arrayOfMeterCopyMeterCopyItem) : gettype($arrayOfMeterCopyMeterCopyItem)), __LINE__);
            }
        }
        if (is_null($meterCopy) || (is_array($meterCopy) && empty($meterCopy))) {
            unset($this->MeterCopy);
        } else {
            $this->MeterCopy = $meterCopy;
        }
        return $this;
    }
    /**
     * Add item to MeterCopy value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\MeterCopy $item
     * @return \SGCIS\Array\ArrayOfMeterCopy
     */
    public function addToMeterCopy(\SGCIS\Struct\MeterCopy $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\MeterCopy) {
            throw new \InvalidArgumentException(sprintf('The MeterCopy property can only contain items of \SGCIS\Struct\MeterCopy, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MeterCopy[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\MeterCopy|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\MeterCopy|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\MeterCopy|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\MeterCopy|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\MeterCopy|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MeterCopy
     */
    public function getAttributeName()
    {
        return 'MeterCopy';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfMeterCopy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
