<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCompany Array
 * @subpackage Arrays
 */
class ArrayOfCompany extends AbstractStructArrayBase
{
    /**
     * The Company
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\Company[]
     */
    public $Company;
    /**
     * Constructor method for ArrayOfCompany
     * @uses ArrayOfCompany::setCompany()
     * @param \SGCIS\Struct\Company[] $company
     */
    public function __construct(array $company = array())
    {
        $this
            ->setCompany($company);
    }
    /**
     * Get Company value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\Company[]|null
     */
    public function getCompany()
    {
        return isset($this->Company) ? $this->Company : null;
    }
    /**
     * Set Company value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Company[] $company
     * @return \SGCIS\Array\ArrayOfCompany
     */
    public function setCompany(array $company = array())
    {
        foreach ($company as $arrayOfCompanyCompanyItem) {
            // validation for constraint: itemType
            if (!$arrayOfCompanyCompanyItem instanceof \SGCIS\Struct\Company) {
                throw new \InvalidArgumentException(sprintf('The Company property can only contain items of \SGCIS\Struct\Company, "%s" given', is_object($arrayOfCompanyCompanyItem) ? get_class($arrayOfCompanyCompanyItem) : gettype($arrayOfCompanyCompanyItem)), __LINE__);
            }
        }
        if (is_null($company) || (is_array($company) && empty($company))) {
            unset($this->Company);
        } else {
            $this->Company = $company;
        }
        return $this;
    }
    /**
     * Add item to Company value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\Company $item
     * @return \SGCIS\Array\ArrayOfCompany
     */
    public function addToCompany(\SGCIS\Struct\Company $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\Company) {
            throw new \InvalidArgumentException(sprintf('The Company property can only contain items of \SGCIS\Struct\Company, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Company[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\Company|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\Company|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\Company|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\Company|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\Company|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Company
     */
    public function getAttributeName()
    {
        return 'Company';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfCompany
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
