<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfChargeDistributionServiceProvider Array
 * @subpackage Arrays
 */
class ArrayOfChargeDistributionServiceProvider extends AbstractStructArrayBase
{
    /**
     * The ChargeDistributionServiceProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\ChargeDistributionServiceProvider[]
     */
    public $ChargeDistributionServiceProvider;
    /**
     * Constructor method for ArrayOfChargeDistributionServiceProvider
     * @uses ArrayOfChargeDistributionServiceProvider::setChargeDistributionServiceProvider()
     * @param \SGCIS\Struct\ChargeDistributionServiceProvider[] $chargeDistributionServiceProvider
     */
    public function __construct(array $chargeDistributionServiceProvider = array())
    {
        $this
            ->setChargeDistributionServiceProvider($chargeDistributionServiceProvider);
    }
    /**
     * Get ChargeDistributionServiceProvider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider[]|null
     */
    public function getChargeDistributionServiceProvider()
    {
        return isset($this->ChargeDistributionServiceProvider) ? $this->ChargeDistributionServiceProvider : null;
    }
    /**
     * Set ChargeDistributionServiceProvider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeDistributionServiceProvider[] $chargeDistributionServiceProvider
     * @return \SGCIS\Array\ArrayOfChargeDistributionServiceProvider
     */
    public function setChargeDistributionServiceProvider(array $chargeDistributionServiceProvider = array())
    {
        foreach ($chargeDistributionServiceProvider as $arrayOfChargeDistributionServiceProviderChargeDistributionServiceProviderItem) {
            // validation for constraint: itemType
            if (!$arrayOfChargeDistributionServiceProviderChargeDistributionServiceProviderItem instanceof \SGCIS\Struct\ChargeDistributionServiceProvider) {
                throw new \InvalidArgumentException(sprintf('The ChargeDistributionServiceProvider property can only contain items of \SGCIS\Struct\ChargeDistributionServiceProvider, "%s" given', is_object($arrayOfChargeDistributionServiceProviderChargeDistributionServiceProviderItem) ? get_class($arrayOfChargeDistributionServiceProviderChargeDistributionServiceProviderItem) : gettype($arrayOfChargeDistributionServiceProviderChargeDistributionServiceProviderItem)), __LINE__);
            }
        }
        if (is_null($chargeDistributionServiceProvider) || (is_array($chargeDistributionServiceProvider) && empty($chargeDistributionServiceProvider))) {
            unset($this->ChargeDistributionServiceProvider);
        } else {
            $this->ChargeDistributionServiceProvider = $chargeDistributionServiceProvider;
        }
        return $this;
    }
    /**
     * Add item to ChargeDistributionServiceProvider value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\ChargeDistributionServiceProvider $item
     * @return \SGCIS\Array\ArrayOfChargeDistributionServiceProvider
     */
    public function addToChargeDistributionServiceProvider(\SGCIS\Struct\ChargeDistributionServiceProvider $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\ChargeDistributionServiceProvider) {
            throw new \InvalidArgumentException(sprintf('The ChargeDistributionServiceProvider property can only contain items of \SGCIS\Struct\ChargeDistributionServiceProvider, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ChargeDistributionServiceProvider[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\ChargeDistributionServiceProvider|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ChargeDistributionServiceProvider
     */
    public function getAttributeName()
    {
        return 'ChargeDistributionServiceProvider';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfChargeDistributionServiceProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
