<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillStatusHistory Array
 * @subpackage Arrays
 */
class ArrayOfBillStatusHistory extends AbstractStructArrayBase
{
    /**
     * The BillStatusHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillStatusHistory[]
     */
    public $BillStatusHistory;
    /**
     * Constructor method for ArrayOfBillStatusHistory
     * @uses ArrayOfBillStatusHistory::setBillStatusHistory()
     * @param \SGCIS\Struct\BillStatusHistory[] $billStatusHistory
     */
    public function __construct(array $billStatusHistory = array())
    {
        $this
            ->setBillStatusHistory($billStatusHistory);
    }
    /**
     * Get BillStatusHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillStatusHistory[]|null
     */
    public function getBillStatusHistory()
    {
        return isset($this->BillStatusHistory) ? $this->BillStatusHistory : null;
    }
    /**
     * Set BillStatusHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillStatusHistory[] $billStatusHistory
     * @return \SGCIS\Array\ArrayOfBillStatusHistory
     */
    public function setBillStatusHistory(array $billStatusHistory = array())
    {
        foreach ($billStatusHistory as $arrayOfBillStatusHistoryBillStatusHistoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillStatusHistoryBillStatusHistoryItem instanceof \SGCIS\Struct\BillStatusHistory) {
                throw new \InvalidArgumentException(sprintf('The BillStatusHistory property can only contain items of \SGCIS\Struct\BillStatusHistory, "%s" given', is_object($arrayOfBillStatusHistoryBillStatusHistoryItem) ? get_class($arrayOfBillStatusHistoryBillStatusHistoryItem) : gettype($arrayOfBillStatusHistoryBillStatusHistoryItem)), __LINE__);
            }
        }
        if (is_null($billStatusHistory) || (is_array($billStatusHistory) && empty($billStatusHistory))) {
            unset($this->BillStatusHistory);
        } else {
            $this->BillStatusHistory = $billStatusHistory;
        }
        return $this;
    }
    /**
     * Add item to BillStatusHistory value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillStatusHistory $item
     * @return \SGCIS\Array\ArrayOfBillStatusHistory
     */
    public function addToBillStatusHistory(\SGCIS\Struct\BillStatusHistory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillStatusHistory) {
            throw new \InvalidArgumentException(sprintf('The BillStatusHistory property can only contain items of \SGCIS\Struct\BillStatusHistory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillStatusHistory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillStatusHistory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillStatusHistory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillStatusHistory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillStatusHistory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillStatusHistory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillStatusHistory
     */
    public function getAttributeName()
    {
        return 'BillStatusHistory';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillStatusHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
