<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillServicePointContractDetail Array
 * @subpackage Arrays
 */
class ArrayOfBillServicePointContractDetail extends AbstractStructArrayBase
{
    /**
     * The BillServicePointContractDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillServicePointContractDetail[]
     */
    public $BillServicePointContractDetail;
    /**
     * Constructor method for ArrayOfBillServicePointContractDetail
     * @uses ArrayOfBillServicePointContractDetail::setBillServicePointContractDetail()
     * @param \SGCIS\Struct\BillServicePointContractDetail[] $billServicePointContractDetail
     */
    public function __construct(array $billServicePointContractDetail = array())
    {
        $this
            ->setBillServicePointContractDetail($billServicePointContractDetail);
    }
    /**
     * Get BillServicePointContractDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillServicePointContractDetail[]|null
     */
    public function getBillServicePointContractDetail()
    {
        return isset($this->BillServicePointContractDetail) ? $this->BillServicePointContractDetail : null;
    }
    /**
     * Set BillServicePointContractDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointContractDetail[] $billServicePointContractDetail
     * @return \SGCIS\Array\ArrayOfBillServicePointContractDetail
     */
    public function setBillServicePointContractDetail(array $billServicePointContractDetail = array())
    {
        foreach ($billServicePointContractDetail as $arrayOfBillServicePointContractDetailBillServicePointContractDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillServicePointContractDetailBillServicePointContractDetailItem instanceof \SGCIS\Struct\BillServicePointContractDetail) {
                throw new \InvalidArgumentException(sprintf('The BillServicePointContractDetail property can only contain items of \SGCIS\Struct\BillServicePointContractDetail, "%s" given', is_object($arrayOfBillServicePointContractDetailBillServicePointContractDetailItem) ? get_class($arrayOfBillServicePointContractDetailBillServicePointContractDetailItem) : gettype($arrayOfBillServicePointContractDetailBillServicePointContractDetailItem)), __LINE__);
            }
        }
        if (is_null($billServicePointContractDetail) || (is_array($billServicePointContractDetail) && empty($billServicePointContractDetail))) {
            unset($this->BillServicePointContractDetail);
        } else {
            $this->BillServicePointContractDetail = $billServicePointContractDetail;
        }
        return $this;
    }
    /**
     * Add item to BillServicePointContractDetail value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointContractDetail $item
     * @return \SGCIS\Array\ArrayOfBillServicePointContractDetail
     */
    public function addToBillServicePointContractDetail(\SGCIS\Struct\BillServicePointContractDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillServicePointContractDetail) {
            throw new \InvalidArgumentException(sprintf('The BillServicePointContractDetail property can only contain items of \SGCIS\Struct\BillServicePointContractDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillServicePointContractDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillServicePointContractDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillServicePointContractDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillServicePointContractDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillServicePointContractDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillServicePointContractDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillServicePointContractDetail
     */
    public function getAttributeName()
    {
        return 'BillServicePointContractDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillServicePointContractDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
