<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillServicePointChargeDetail Array
 * @subpackage Arrays
 */
class ArrayOfBillServicePointChargeDetail extends AbstractStructArrayBase
{
    /**
     * The BillServicePointChargeDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillServicePointChargeDetail[]
     */
    public $BillServicePointChargeDetail;
    /**
     * Constructor method for ArrayOfBillServicePointChargeDetail
     * @uses ArrayOfBillServicePointChargeDetail::setBillServicePointChargeDetail()
     * @param \SGCIS\Struct\BillServicePointChargeDetail[] $billServicePointChargeDetail
     */
    public function __construct(array $billServicePointChargeDetail = array())
    {
        $this
            ->setBillServicePointChargeDetail($billServicePointChargeDetail);
    }
    /**
     * Get BillServicePointChargeDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillServicePointChargeDetail[]|null
     */
    public function getBillServicePointChargeDetail()
    {
        return isset($this->BillServicePointChargeDetail) ? $this->BillServicePointChargeDetail : null;
    }
    /**
     * Set BillServicePointChargeDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointChargeDetail[] $billServicePointChargeDetail
     * @return \SGCIS\Array\ArrayOfBillServicePointChargeDetail
     */
    public function setBillServicePointChargeDetail(array $billServicePointChargeDetail = array())
    {
        foreach ($billServicePointChargeDetail as $arrayOfBillServicePointChargeDetailBillServicePointChargeDetailItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillServicePointChargeDetailBillServicePointChargeDetailItem instanceof \SGCIS\Struct\BillServicePointChargeDetail) {
                throw new \InvalidArgumentException(sprintf('The BillServicePointChargeDetail property can only contain items of \SGCIS\Struct\BillServicePointChargeDetail, "%s" given', is_object($arrayOfBillServicePointChargeDetailBillServicePointChargeDetailItem) ? get_class($arrayOfBillServicePointChargeDetailBillServicePointChargeDetailItem) : gettype($arrayOfBillServicePointChargeDetailBillServicePointChargeDetailItem)), __LINE__);
            }
        }
        if (is_null($billServicePointChargeDetail) || (is_array($billServicePointChargeDetail) && empty($billServicePointChargeDetail))) {
            unset($this->BillServicePointChargeDetail);
        } else {
            $this->BillServicePointChargeDetail = $billServicePointChargeDetail;
        }
        return $this;
    }
    /**
     * Add item to BillServicePointChargeDetail value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePointChargeDetail $item
     * @return \SGCIS\Array\ArrayOfBillServicePointChargeDetail
     */
    public function addToBillServicePointChargeDetail(\SGCIS\Struct\BillServicePointChargeDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillServicePointChargeDetail) {
            throw new \InvalidArgumentException(sprintf('The BillServicePointChargeDetail property can only contain items of \SGCIS\Struct\BillServicePointChargeDetail, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillServicePointChargeDetail[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillServicePointChargeDetail|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillServicePointChargeDetail|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillServicePointChargeDetail|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillServicePointChargeDetail|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillServicePointChargeDetail|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillServicePointChargeDetail
     */
    public function getAttributeName()
    {
        return 'BillServicePointChargeDetail';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillServicePointChargeDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
