<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillServicePoint Array
 * @subpackage Arrays
 */
class ArrayOfBillServicePoint extends AbstractStructArrayBase
{
    /**
     * The BillServicePoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillServicePoint[]
     */
    public $BillServicePoint;
    /**
     * Constructor method for ArrayOfBillServicePoint
     * @uses ArrayOfBillServicePoint::setBillServicePoint()
     * @param \SGCIS\Struct\BillServicePoint[] $billServicePoint
     */
    public function __construct(array $billServicePoint = array())
    {
        $this
            ->setBillServicePoint($billServicePoint);
    }
    /**
     * Get BillServicePoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillServicePoint[]|null
     */
    public function getBillServicePoint()
    {
        return isset($this->BillServicePoint) ? $this->BillServicePoint : null;
    }
    /**
     * Set BillServicePoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePoint[] $billServicePoint
     * @return \SGCIS\Array\ArrayOfBillServicePoint
     */
    public function setBillServicePoint(array $billServicePoint = array())
    {
        foreach ($billServicePoint as $arrayOfBillServicePointBillServicePointItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillServicePointBillServicePointItem instanceof \SGCIS\Struct\BillServicePoint) {
                throw new \InvalidArgumentException(sprintf('The BillServicePoint property can only contain items of \SGCIS\Struct\BillServicePoint, "%s" given', is_object($arrayOfBillServicePointBillServicePointItem) ? get_class($arrayOfBillServicePointBillServicePointItem) : gettype($arrayOfBillServicePointBillServicePointItem)), __LINE__);
            }
        }
        if (is_null($billServicePoint) || (is_array($billServicePoint) && empty($billServicePoint))) {
            unset($this->BillServicePoint);
        } else {
            $this->BillServicePoint = $billServicePoint;
        }
        return $this;
    }
    /**
     * Add item to BillServicePoint value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillServicePoint $item
     * @return \SGCIS\Array\ArrayOfBillServicePoint
     */
    public function addToBillServicePoint(\SGCIS\Struct\BillServicePoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillServicePoint) {
            throw new \InvalidArgumentException(sprintf('The BillServicePoint property can only contain items of \SGCIS\Struct\BillServicePoint, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillServicePoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillServicePoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillServicePoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillServicePoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillServicePoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillServicePoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillServicePoint
     */
    public function getAttributeName()
    {
        return 'BillServicePoint';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillServicePoint
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
