<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillPaymentAdjustment Array
 * @subpackage Arrays
 */
class ArrayOfBillPaymentAdjustment extends AbstractStructArrayBase
{
    /**
     * The BillPaymentAdjustment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillPaymentAdjustment[]
     */
    public $BillPaymentAdjustment;
    /**
     * Constructor method for ArrayOfBillPaymentAdjustment
     * @uses ArrayOfBillPaymentAdjustment::setBillPaymentAdjustment()
     * @param \SGCIS\Struct\BillPaymentAdjustment[] $billPaymentAdjustment
     */
    public function __construct(array $billPaymentAdjustment = array())
    {
        $this
            ->setBillPaymentAdjustment($billPaymentAdjustment);
    }
    /**
     * Get BillPaymentAdjustment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillPaymentAdjustment[]|null
     */
    public function getBillPaymentAdjustment()
    {
        return isset($this->BillPaymentAdjustment) ? $this->BillPaymentAdjustment : null;
    }
    /**
     * Set BillPaymentAdjustment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillPaymentAdjustment[] $billPaymentAdjustment
     * @return \SGCIS\Array\ArrayOfBillPaymentAdjustment
     */
    public function setBillPaymentAdjustment(array $billPaymentAdjustment = array())
    {
        foreach ($billPaymentAdjustment as $arrayOfBillPaymentAdjustmentBillPaymentAdjustmentItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillPaymentAdjustmentBillPaymentAdjustmentItem instanceof \SGCIS\Struct\BillPaymentAdjustment) {
                throw new \InvalidArgumentException(sprintf('The BillPaymentAdjustment property can only contain items of \SGCIS\Struct\BillPaymentAdjustment, "%s" given', is_object($arrayOfBillPaymentAdjustmentBillPaymentAdjustmentItem) ? get_class($arrayOfBillPaymentAdjustmentBillPaymentAdjustmentItem) : gettype($arrayOfBillPaymentAdjustmentBillPaymentAdjustmentItem)), __LINE__);
            }
        }
        if (is_null($billPaymentAdjustment) || (is_array($billPaymentAdjustment) && empty($billPaymentAdjustment))) {
            unset($this->BillPaymentAdjustment);
        } else {
            $this->BillPaymentAdjustment = $billPaymentAdjustment;
        }
        return $this;
    }
    /**
     * Add item to BillPaymentAdjustment value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillPaymentAdjustment $item
     * @return \SGCIS\Array\ArrayOfBillPaymentAdjustment
     */
    public function addToBillPaymentAdjustment(\SGCIS\Struct\BillPaymentAdjustment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillPaymentAdjustment) {
            throw new \InvalidArgumentException(sprintf('The BillPaymentAdjustment property can only contain items of \SGCIS\Struct\BillPaymentAdjustment, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillPaymentAdjustment[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillPaymentAdjustment|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillPaymentAdjustment|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillPaymentAdjustment|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillPaymentAdjustment|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillPaymentAdjustment|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillPaymentAdjustment
     */
    public function getAttributeName()
    {
        return 'BillPaymentAdjustment';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillPaymentAdjustment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
