<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillHeader Array
 * @subpackage Arrays
 */
class ArrayOfBillHeader extends AbstractStructArrayBase
{
    /**
     * The BillHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillHeader[]
     */
    public $BillHeader;
    /**
     * Constructor method for ArrayOfBillHeader
     * @uses ArrayOfBillHeader::setBillHeader()
     * @param \SGCIS\Struct\BillHeader[] $billHeader
     */
    public function __construct(array $billHeader = array())
    {
        $this
            ->setBillHeader($billHeader);
    }
    /**
     * Get BillHeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillHeader[]|null
     */
    public function getBillHeader()
    {
        return isset($this->BillHeader) ? $this->BillHeader : null;
    }
    /**
     * Set BillHeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillHeader[] $billHeader
     * @return \SGCIS\Array\ArrayOfBillHeader
     */
    public function setBillHeader(array $billHeader = array())
    {
        foreach ($billHeader as $arrayOfBillHeaderBillHeaderItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillHeaderBillHeaderItem instanceof \SGCIS\Struct\BillHeader) {
                throw new \InvalidArgumentException(sprintf('The BillHeader property can only contain items of \SGCIS\Struct\BillHeader, "%s" given', is_object($arrayOfBillHeaderBillHeaderItem) ? get_class($arrayOfBillHeaderBillHeaderItem) : gettype($arrayOfBillHeaderBillHeaderItem)), __LINE__);
            }
        }
        if (is_null($billHeader) || (is_array($billHeader) && empty($billHeader))) {
            unset($this->BillHeader);
        } else {
            $this->BillHeader = $billHeader;
        }
        return $this;
    }
    /**
     * Add item to BillHeader value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillHeader $item
     * @return \SGCIS\Array\ArrayOfBillHeader
     */
    public function addToBillHeader(\SGCIS\Struct\BillHeader $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillHeader) {
            throw new \InvalidArgumentException(sprintf('The BillHeader property can only contain items of \SGCIS\Struct\BillHeader, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillHeader[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillHeader|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillHeader
     */
    public function getAttributeName()
    {
        return 'BillHeader';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
