<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBillChargeDisplayItem Array
 * @subpackage Arrays
 */
class ArrayOfBillChargeDisplayItem extends AbstractStructArrayBase
{
    /**
     * The BillChargeDisplayItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\BillChargeDisplayItem[]
     */
    public $BillChargeDisplayItem;
    /**
     * Constructor method for ArrayOfBillChargeDisplayItem
     * @uses ArrayOfBillChargeDisplayItem::setBillChargeDisplayItem()
     * @param \SGCIS\Struct\BillChargeDisplayItem[] $billChargeDisplayItem
     */
    public function __construct(array $billChargeDisplayItem = array())
    {
        $this
            ->setBillChargeDisplayItem($billChargeDisplayItem);
    }
    /**
     * Get BillChargeDisplayItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\BillChargeDisplayItem[]|null
     */
    public function getBillChargeDisplayItem()
    {
        return isset($this->BillChargeDisplayItem) ? $this->BillChargeDisplayItem : null;
    }
    /**
     * Set BillChargeDisplayItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillChargeDisplayItem[] $billChargeDisplayItem
     * @return \SGCIS\Array\ArrayOfBillChargeDisplayItem
     */
    public function setBillChargeDisplayItem(array $billChargeDisplayItem = array())
    {
        foreach ($billChargeDisplayItem as $arrayOfBillChargeDisplayItemBillChargeDisplayItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfBillChargeDisplayItemBillChargeDisplayItemItem instanceof \SGCIS\Struct\BillChargeDisplayItem) {
                throw new \InvalidArgumentException(sprintf('The BillChargeDisplayItem property can only contain items of \SGCIS\Struct\BillChargeDisplayItem, "%s" given', is_object($arrayOfBillChargeDisplayItemBillChargeDisplayItemItem) ? get_class($arrayOfBillChargeDisplayItemBillChargeDisplayItemItem) : gettype($arrayOfBillChargeDisplayItemBillChargeDisplayItemItem)), __LINE__);
            }
        }
        if (is_null($billChargeDisplayItem) || (is_array($billChargeDisplayItem) && empty($billChargeDisplayItem))) {
            unset($this->BillChargeDisplayItem);
        } else {
            $this->BillChargeDisplayItem = $billChargeDisplayItem;
        }
        return $this;
    }
    /**
     * Add item to BillChargeDisplayItem value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\BillChargeDisplayItem $item
     * @return \SGCIS\Array\ArrayOfBillChargeDisplayItem
     */
    public function addToBillChargeDisplayItem(\SGCIS\Struct\BillChargeDisplayItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\BillChargeDisplayItem) {
            throw new \InvalidArgumentException(sprintf('The BillChargeDisplayItem property can only contain items of \SGCIS\Struct\BillChargeDisplayItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BillChargeDisplayItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\BillChargeDisplayItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\BillChargeDisplayItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\BillChargeDisplayItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\BillChargeDisplayItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\BillChargeDisplayItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BillChargeDisplayItem
     */
    public function getAttributeName()
    {
        return 'BillChargeDisplayItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfBillChargeDisplayItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
