<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAttachedFile Array
 * @subpackage Arrays
 */
class ArrayOfAttachedFile extends AbstractStructArrayBase
{
    /**
     * The AttachedFile
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AttachedFile[]
     */
    public $AttachedFile;
    /**
     * Constructor method for ArrayOfAttachedFile
     * @uses ArrayOfAttachedFile::setAttachedFile()
     * @param \SGCIS\Struct\AttachedFile[] $attachedFile
     */
    public function __construct(array $attachedFile = array())
    {
        $this
            ->setAttachedFile($attachedFile);
    }
    /**
     * Get AttachedFile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AttachedFile[]|null
     */
    public function getAttachedFile()
    {
        return isset($this->AttachedFile) ? $this->AttachedFile : null;
    }
    /**
     * Set AttachedFile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AttachedFile[] $attachedFile
     * @return \SGCIS\Array\ArrayOfAttachedFile
     */
    public function setAttachedFile(array $attachedFile = array())
    {
        foreach ($attachedFile as $arrayOfAttachedFileAttachedFileItem) {
            // validation for constraint: itemType
            if (!$arrayOfAttachedFileAttachedFileItem instanceof \SGCIS\Struct\AttachedFile) {
                throw new \InvalidArgumentException(sprintf('The AttachedFile property can only contain items of \SGCIS\Struct\AttachedFile, "%s" given', is_object($arrayOfAttachedFileAttachedFileItem) ? get_class($arrayOfAttachedFileAttachedFileItem) : gettype($arrayOfAttachedFileAttachedFileItem)), __LINE__);
            }
        }
        if (is_null($attachedFile) || (is_array($attachedFile) && empty($attachedFile))) {
            unset($this->AttachedFile);
        } else {
            $this->AttachedFile = $attachedFile;
        }
        return $this;
    }
    /**
     * Add item to AttachedFile value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AttachedFile $item
     * @return \SGCIS\Array\ArrayOfAttachedFile
     */
    public function addToAttachedFile(\SGCIS\Struct\AttachedFile $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AttachedFile) {
            throw new \InvalidArgumentException(sprintf('The AttachedFile property can only contain items of \SGCIS\Struct\AttachedFile, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AttachedFile[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AttachedFile|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AttachedFile|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AttachedFile|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AttachedFile|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AttachedFile|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AttachedFile
     */
    public function getAttributeName()
    {
        return 'AttachedFile';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAttachedFile
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
