<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountSummary Array
 * @subpackage Arrays
 */
class ArrayOfAccountSummary extends AbstractStructArrayBase
{
    /**
     * The AccountSummary
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountSummary[]
     */
    public $AccountSummary;
    /**
     * Constructor method for ArrayOfAccountSummary
     * @uses ArrayOfAccountSummary::setAccountSummary()
     * @param \SGCIS\Struct\AccountSummary[] $accountSummary
     */
    public function __construct(array $accountSummary = array())
    {
        $this
            ->setAccountSummary($accountSummary);
    }
    /**
     * Get AccountSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountSummary[]|null
     */
    public function getAccountSummary()
    {
        return isset($this->AccountSummary) ? $this->AccountSummary : null;
    }
    /**
     * Set AccountSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountSummary[] $accountSummary
     * @return \SGCIS\Array\ArrayOfAccountSummary
     */
    public function setAccountSummary(array $accountSummary = array())
    {
        foreach ($accountSummary as $arrayOfAccountSummaryAccountSummaryItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountSummaryAccountSummaryItem instanceof \SGCIS\Struct\AccountSummary) {
                throw new \InvalidArgumentException(sprintf('The AccountSummary property can only contain items of \SGCIS\Struct\AccountSummary, "%s" given', is_object($arrayOfAccountSummaryAccountSummaryItem) ? get_class($arrayOfAccountSummaryAccountSummaryItem) : gettype($arrayOfAccountSummaryAccountSummaryItem)), __LINE__);
            }
        }
        if (is_null($accountSummary) || (is_array($accountSummary) && empty($accountSummary))) {
            unset($this->AccountSummary);
        } else {
            $this->AccountSummary = $accountSummary;
        }
        return $this;
    }
    /**
     * Add item to AccountSummary value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountSummary $item
     * @return \SGCIS\Array\ArrayOfAccountSummary
     */
    public function addToAccountSummary(\SGCIS\Struct\AccountSummary $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountSummary) {
            throw new \InvalidArgumentException(sprintf('The AccountSummary property can only contain items of \SGCIS\Struct\AccountSummary, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountSummary[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountSummary|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountSummary|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountSummary|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountSummary|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountSummary|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountSummary
     */
    public function getAttributeName()
    {
        return 'AccountSummary';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountSummary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
