<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountStatusHistory Array
 * @subpackage Arrays
 */
class ArrayOfAccountStatusHistory extends AbstractStructArrayBase
{
    /**
     * The AccountStatusHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountStatusHistory[]
     */
    public $AccountStatusHistory;
    /**
     * Constructor method for ArrayOfAccountStatusHistory
     * @uses ArrayOfAccountStatusHistory::setAccountStatusHistory()
     * @param \SGCIS\Struct\AccountStatusHistory[] $accountStatusHistory
     */
    public function __construct(array $accountStatusHistory = array())
    {
        $this
            ->setAccountStatusHistory($accountStatusHistory);
    }
    /**
     * Get AccountStatusHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountStatusHistory[]|null
     */
    public function getAccountStatusHistory()
    {
        return isset($this->AccountStatusHistory) ? $this->AccountStatusHistory : null;
    }
    /**
     * Set AccountStatusHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountStatusHistory[] $accountStatusHistory
     * @return \SGCIS\Array\ArrayOfAccountStatusHistory
     */
    public function setAccountStatusHistory(array $accountStatusHistory = array())
    {
        foreach ($accountStatusHistory as $arrayOfAccountStatusHistoryAccountStatusHistoryItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountStatusHistoryAccountStatusHistoryItem instanceof \SGCIS\Struct\AccountStatusHistory) {
                throw new \InvalidArgumentException(sprintf('The AccountStatusHistory property can only contain items of \SGCIS\Struct\AccountStatusHistory, "%s" given', is_object($arrayOfAccountStatusHistoryAccountStatusHistoryItem) ? get_class($arrayOfAccountStatusHistoryAccountStatusHistoryItem) : gettype($arrayOfAccountStatusHistoryAccountStatusHistoryItem)), __LINE__);
            }
        }
        if (is_null($accountStatusHistory) || (is_array($accountStatusHistory) && empty($accountStatusHistory))) {
            unset($this->AccountStatusHistory);
        } else {
            $this->AccountStatusHistory = $accountStatusHistory;
        }
        return $this;
    }
    /**
     * Add item to AccountStatusHistory value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountStatusHistory $item
     * @return \SGCIS\Array\ArrayOfAccountStatusHistory
     */
    public function addToAccountStatusHistory(\SGCIS\Struct\AccountStatusHistory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountStatusHistory) {
            throw new \InvalidArgumentException(sprintf('The AccountStatusHistory property can only contain items of \SGCIS\Struct\AccountStatusHistory, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountStatusHistory[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountStatusHistory|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountStatusHistory|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountStatusHistory|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountStatusHistory|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountStatusHistory|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountStatusHistory
     */
    public function getAttributeName()
    {
        return 'AccountStatusHistory';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountStatusHistory
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
