<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountPrevious Array
 * @subpackage Arrays
 */
class ArrayOfAccountPrevious extends AbstractStructArrayBase
{
    /**
     * The AccountPrevious
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountPrevious[]
     */
    public $AccountPrevious;
    /**
     * Constructor method for ArrayOfAccountPrevious
     * @uses ArrayOfAccountPrevious::setAccountPrevious()
     * @param \SGCIS\Struct\AccountPrevious[] $accountPrevious
     */
    public function __construct(array $accountPrevious = array())
    {
        $this
            ->setAccountPrevious($accountPrevious);
    }
    /**
     * Get AccountPrevious value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountPrevious[]|null
     */
    public function getAccountPrevious()
    {
        return isset($this->AccountPrevious) ? $this->AccountPrevious : null;
    }
    /**
     * Set AccountPrevious value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountPrevious[] $accountPrevious
     * @return \SGCIS\Array\ArrayOfAccountPrevious
     */
    public function setAccountPrevious(array $accountPrevious = array())
    {
        foreach ($accountPrevious as $arrayOfAccountPreviousAccountPreviousItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountPreviousAccountPreviousItem instanceof \SGCIS\Struct\AccountPrevious) {
                throw new \InvalidArgumentException(sprintf('The AccountPrevious property can only contain items of \SGCIS\Struct\AccountPrevious, "%s" given', is_object($arrayOfAccountPreviousAccountPreviousItem) ? get_class($arrayOfAccountPreviousAccountPreviousItem) : gettype($arrayOfAccountPreviousAccountPreviousItem)), __LINE__);
            }
        }
        if (is_null($accountPrevious) || (is_array($accountPrevious) && empty($accountPrevious))) {
            unset($this->AccountPrevious);
        } else {
            $this->AccountPrevious = $accountPrevious;
        }
        return $this;
    }
    /**
     * Add item to AccountPrevious value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountPrevious $item
     * @return \SGCIS\Array\ArrayOfAccountPrevious
     */
    public function addToAccountPrevious(\SGCIS\Struct\AccountPrevious $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountPrevious) {
            throw new \InvalidArgumentException(sprintf('The AccountPrevious property can only contain items of \SGCIS\Struct\AccountPrevious, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountPrevious[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountPrevious|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountPrevious|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountPrevious|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountPrevious|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountPrevious|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountPrevious
     */
    public function getAttributeName()
    {
        return 'AccountPrevious';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountPrevious
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
