<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountNote Array
 * @subpackage Arrays
 */
class ArrayOfAccountNote extends AbstractStructArrayBase
{
    /**
     * The AccountNote
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountNote[]
     */
    public $AccountNote;
    /**
     * Constructor method for ArrayOfAccountNote
     * @uses ArrayOfAccountNote::setAccountNote()
     * @param \SGCIS\Struct\AccountNote[] $accountNote
     */
    public function __construct(array $accountNote = array())
    {
        $this
            ->setAccountNote($accountNote);
    }
    /**
     * Get AccountNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountNote[]|null
     */
    public function getAccountNote()
    {
        return isset($this->AccountNote) ? $this->AccountNote : null;
    }
    /**
     * Set AccountNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountNote[] $accountNote
     * @return \SGCIS\Array\ArrayOfAccountNote
     */
    public function setAccountNote(array $accountNote = array())
    {
        foreach ($accountNote as $arrayOfAccountNoteAccountNoteItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountNoteAccountNoteItem instanceof \SGCIS\Struct\AccountNote) {
                throw new \InvalidArgumentException(sprintf('The AccountNote property can only contain items of \SGCIS\Struct\AccountNote, "%s" given', is_object($arrayOfAccountNoteAccountNoteItem) ? get_class($arrayOfAccountNoteAccountNoteItem) : gettype($arrayOfAccountNoteAccountNoteItem)), __LINE__);
            }
        }
        if (is_null($accountNote) || (is_array($accountNote) && empty($accountNote))) {
            unset($this->AccountNote);
        } else {
            $this->AccountNote = $accountNote;
        }
        return $this;
    }
    /**
     * Add item to AccountNote value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountNote $item
     * @return \SGCIS\Array\ArrayOfAccountNote
     */
    public function addToAccountNote(\SGCIS\Struct\AccountNote $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountNote) {
            throw new \InvalidArgumentException(sprintf('The AccountNote property can only contain items of \SGCIS\Struct\AccountNote, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountNote[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountNote|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountNote|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountNote|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountNote|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountNote|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountNote
     */
    public function getAttributeName()
    {
        return 'AccountNote';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
