<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountDocument Array
 * @subpackage Arrays
 */
class ArrayOfAccountDocument extends AbstractStructArrayBase
{
    /**
     * The AccountDocument
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountDocument[]
     */
    public $AccountDocument;
    /**
     * Constructor method for ArrayOfAccountDocument
     * @uses ArrayOfAccountDocument::setAccountDocument()
     * @param \SGCIS\Struct\AccountDocument[] $accountDocument
     */
    public function __construct(array $accountDocument = array())
    {
        $this
            ->setAccountDocument($accountDocument);
    }
    /**
     * Get AccountDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountDocument[]|null
     */
    public function getAccountDocument()
    {
        return isset($this->AccountDocument) ? $this->AccountDocument : null;
    }
    /**
     * Set AccountDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDocument[] $accountDocument
     * @return \SGCIS\Array\ArrayOfAccountDocument
     */
    public function setAccountDocument(array $accountDocument = array())
    {
        foreach ($accountDocument as $arrayOfAccountDocumentAccountDocumentItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountDocumentAccountDocumentItem instanceof \SGCIS\Struct\AccountDocument) {
                throw new \InvalidArgumentException(sprintf('The AccountDocument property can only contain items of \SGCIS\Struct\AccountDocument, "%s" given', is_object($arrayOfAccountDocumentAccountDocumentItem) ? get_class($arrayOfAccountDocumentAccountDocumentItem) : gettype($arrayOfAccountDocumentAccountDocumentItem)), __LINE__);
            }
        }
        if (is_null($accountDocument) || (is_array($accountDocument) && empty($accountDocument))) {
            unset($this->AccountDocument);
        } else {
            $this->AccountDocument = $accountDocument;
        }
        return $this;
    }
    /**
     * Add item to AccountDocument value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDocument $item
     * @return \SGCIS\Array\ArrayOfAccountDocument
     */
    public function addToAccountDocument(\SGCIS\Struct\AccountDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountDocument) {
            throw new \InvalidArgumentException(sprintf('The AccountDocument property can only contain items of \SGCIS\Struct\AccountDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountDocument[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountDocument|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountDocument
     */
    public function getAttributeName()
    {
        return 'AccountDocument';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
