<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountDepositTransaction Array
 * @subpackage Arrays
 */
class ArrayOfAccountDepositTransaction extends AbstractStructArrayBase
{
    /**
     * The AccountDepositTransaction
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountDepositTransaction[]
     */
    public $AccountDepositTransaction;
    /**
     * Constructor method for ArrayOfAccountDepositTransaction
     * @uses ArrayOfAccountDepositTransaction::setAccountDepositTransaction()
     * @param \SGCIS\Struct\AccountDepositTransaction[] $accountDepositTransaction
     */
    public function __construct(array $accountDepositTransaction = array())
    {
        $this
            ->setAccountDepositTransaction($accountDepositTransaction);
    }
    /**
     * Get AccountDepositTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountDepositTransaction[]|null
     */
    public function getAccountDepositTransaction()
    {
        return isset($this->AccountDepositTransaction) ? $this->AccountDepositTransaction : null;
    }
    /**
     * Set AccountDepositTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDepositTransaction[] $accountDepositTransaction
     * @return \SGCIS\Array\ArrayOfAccountDepositTransaction
     */
    public function setAccountDepositTransaction(array $accountDepositTransaction = array())
    {
        foreach ($accountDepositTransaction as $arrayOfAccountDepositTransactionAccountDepositTransactionItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountDepositTransactionAccountDepositTransactionItem instanceof \SGCIS\Struct\AccountDepositTransaction) {
                throw new \InvalidArgumentException(sprintf('The AccountDepositTransaction property can only contain items of \SGCIS\Struct\AccountDepositTransaction, "%s" given', is_object($arrayOfAccountDepositTransactionAccountDepositTransactionItem) ? get_class($arrayOfAccountDepositTransactionAccountDepositTransactionItem) : gettype($arrayOfAccountDepositTransactionAccountDepositTransactionItem)), __LINE__);
            }
        }
        if (is_null($accountDepositTransaction) || (is_array($accountDepositTransaction) && empty($accountDepositTransaction))) {
            unset($this->AccountDepositTransaction);
        } else {
            $this->AccountDepositTransaction = $accountDepositTransaction;
        }
        return $this;
    }
    /**
     * Add item to AccountDepositTransaction value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDepositTransaction $item
     * @return \SGCIS\Array\ArrayOfAccountDepositTransaction
     */
    public function addToAccountDepositTransaction(\SGCIS\Struct\AccountDepositTransaction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountDepositTransaction) {
            throw new \InvalidArgumentException(sprintf('The AccountDepositTransaction property can only contain items of \SGCIS\Struct\AccountDepositTransaction, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountDepositTransaction[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountDepositTransaction|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountDepositTransaction|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountDepositTransaction|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountDepositTransaction|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountDepositTransaction|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountDepositTransaction
     */
    public function getAttributeName()
    {
        return 'AccountDepositTransaction';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountDepositTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
