<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountDeposit Array
 * @subpackage Arrays
 */
class ArrayOfAccountDeposit extends AbstractStructArrayBase
{
    /**
     * The AccountDeposit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountDeposit[]
     */
    public $AccountDeposit;
    /**
     * Constructor method for ArrayOfAccountDeposit
     * @uses ArrayOfAccountDeposit::setAccountDeposit()
     * @param \SGCIS\Struct\AccountDeposit[] $accountDeposit
     */
    public function __construct(array $accountDeposit = array())
    {
        $this
            ->setAccountDeposit($accountDeposit);
    }
    /**
     * Get AccountDeposit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountDeposit[]|null
     */
    public function getAccountDeposit()
    {
        return isset($this->AccountDeposit) ? $this->AccountDeposit : null;
    }
    /**
     * Set AccountDeposit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDeposit[] $accountDeposit
     * @return \SGCIS\Array\ArrayOfAccountDeposit
     */
    public function setAccountDeposit(array $accountDeposit = array())
    {
        foreach ($accountDeposit as $arrayOfAccountDepositAccountDepositItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountDepositAccountDepositItem instanceof \SGCIS\Struct\AccountDeposit) {
                throw new \InvalidArgumentException(sprintf('The AccountDeposit property can only contain items of \SGCIS\Struct\AccountDeposit, "%s" given', is_object($arrayOfAccountDepositAccountDepositItem) ? get_class($arrayOfAccountDepositAccountDepositItem) : gettype($arrayOfAccountDepositAccountDepositItem)), __LINE__);
            }
        }
        if (is_null($accountDeposit) || (is_array($accountDeposit) && empty($accountDeposit))) {
            unset($this->AccountDeposit);
        } else {
            $this->AccountDeposit = $accountDeposit;
        }
        return $this;
    }
    /**
     * Add item to AccountDeposit value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountDeposit $item
     * @return \SGCIS\Array\ArrayOfAccountDeposit
     */
    public function addToAccountDeposit(\SGCIS\Struct\AccountDeposit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountDeposit) {
            throw new \InvalidArgumentException(sprintf('The AccountDeposit property can only contain items of \SGCIS\Struct\AccountDeposit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountDeposit[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountDeposit|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountDeposit|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountDeposit|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountDeposit|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountDeposit|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountDeposit
     */
    public function getAttributeName()
    {
        return 'AccountDeposit';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountDeposit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
