<?php

namespace SGCIS\Array;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountAccountFlag Array
 * @subpackage Arrays
 */
class ArrayOfAccountAccountFlag extends AbstractStructArrayBase
{
    /**
     * The AccountAccountFlag
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \SGCIS\Struct\AccountAccountFlag[]
     */
    public $AccountAccountFlag;
    /**
     * Constructor method for ArrayOfAccountAccountFlag
     * @uses ArrayOfAccountAccountFlag::setAccountAccountFlag()
     * @param \SGCIS\Struct\AccountAccountFlag[] $accountAccountFlag
     */
    public function __construct(array $accountAccountFlag = array())
    {
        $this
            ->setAccountAccountFlag($accountAccountFlag);
    }
    /**
     * Get AccountAccountFlag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \SGCIS\Struct\AccountAccountFlag[]|null
     */
    public function getAccountAccountFlag()
    {
        return isset($this->AccountAccountFlag) ? $this->AccountAccountFlag : null;
    }
    /**
     * Set AccountAccountFlag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountAccountFlag[] $accountAccountFlag
     * @return \SGCIS\Array\ArrayOfAccountAccountFlag
     */
    public function setAccountAccountFlag(array $accountAccountFlag = array())
    {
        foreach ($accountAccountFlag as $arrayOfAccountAccountFlagAccountAccountFlagItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountAccountFlagAccountAccountFlagItem instanceof \SGCIS\Struct\AccountAccountFlag) {
                throw new \InvalidArgumentException(sprintf('The AccountAccountFlag property can only contain items of \SGCIS\Struct\AccountAccountFlag, "%s" given', is_object($arrayOfAccountAccountFlagAccountAccountFlagItem) ? get_class($arrayOfAccountAccountFlagAccountAccountFlagItem) : gettype($arrayOfAccountAccountFlagAccountAccountFlagItem)), __LINE__);
            }
        }
        if (is_null($accountAccountFlag) || (is_array($accountAccountFlag) && empty($accountAccountFlag))) {
            unset($this->AccountAccountFlag);
        } else {
            $this->AccountAccountFlag = $accountAccountFlag;
        }
        return $this;
    }
    /**
     * Add item to AccountAccountFlag value
     * @throws \InvalidArgumentException
     * @param \SGCIS\Struct\AccountAccountFlag $item
     * @return \SGCIS\Array\ArrayOfAccountAccountFlag
     */
    public function addToAccountAccountFlag(\SGCIS\Struct\AccountAccountFlag $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \SGCIS\Struct\AccountAccountFlag) {
            throw new \InvalidArgumentException(sprintf('The AccountAccountFlag property can only contain items of \SGCIS\Struct\AccountAccountFlag, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountAccountFlag[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \SGCIS\Struct\AccountAccountFlag|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \SGCIS\Struct\AccountAccountFlag|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \SGCIS\Struct\AccountAccountFlag|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \SGCIS\Struct\AccountAccountFlag|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \SGCIS\Struct\AccountAccountFlag|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountAccountFlag
     */
    public function getAttributeName()
    {
        return 'AccountAccountFlag';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Array\ArrayOfAccountAccountFlag
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
