<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserSystemRole Struct
 * @subpackage Structs
 */
class UserSystemRole extends BaseDTO
{
    /**
     * The UserSystemRoleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserSystemRoleID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The SystemRoleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemRoleID;
    /**
     * The MaxCreditAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxCreditAmount;
    /**
     * The MaxChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MaxChargeAmount;
    /**
     * The MaxAccountProtectionDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxAccountProtectionDays;
    /**
     * The RoleName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * The SystemRoleApplications
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemRoleApplication
     */
    public $SystemRoleApplications;
    /**
     * Constructor method for UserSystemRole
     * @uses UserSystemRole::setUserSystemRoleID()
     * @uses UserSystemRole::setUserID()
     * @uses UserSystemRole::setSystemRoleID()
     * @uses UserSystemRole::setMaxCreditAmount()
     * @uses UserSystemRole::setMaxChargeAmount()
     * @uses UserSystemRole::setMaxAccountProtectionDays()
     * @uses UserSystemRole::setRoleName()
     * @uses UserSystemRole::setSystemRoleApplications()
     * @param int $userSystemRoleID
     * @param int $userID
     * @param int $systemRoleID
     * @param float $maxCreditAmount
     * @param float $maxChargeAmount
     * @param int $maxAccountProtectionDays
     * @param string $roleName
     * @param \SGCIS\Array\ArrayOfSystemRoleApplication $systemRoleApplications
     */
    public function __construct($userSystemRoleID = null, $userID = null, $systemRoleID = null, $maxCreditAmount = null, $maxChargeAmount = null, $maxAccountProtectionDays = null, $roleName = null, \SGCIS\Array\ArrayOfSystemRoleApplication $systemRoleApplications = null)
    {
        $this
            ->setUserSystemRoleID($userSystemRoleID)
            ->setUserID($userID)
            ->setSystemRoleID($systemRoleID)
            ->setMaxCreditAmount($maxCreditAmount)
            ->setMaxChargeAmount($maxChargeAmount)
            ->setMaxAccountProtectionDays($maxAccountProtectionDays)
            ->setRoleName($roleName)
            ->setSystemRoleApplications($systemRoleApplications);
    }
    /**
     * Get UserSystemRoleID value
     * @return int
     */
    public function getUserSystemRoleID()
    {
        return $this->UserSystemRoleID;
    }
    /**
     * Set UserSystemRoleID value
     * @param int $userSystemRoleID
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setUserSystemRoleID($userSystemRoleID = null)
    {
        // validation for constraint: int
        if (!is_null($userSystemRoleID) && !is_numeric($userSystemRoleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userSystemRoleID)), __LINE__);
        }
        $this->UserSystemRoleID = $userSystemRoleID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get SystemRoleID value
     * @return int
     */
    public function getSystemRoleID()
    {
        return $this->SystemRoleID;
    }
    /**
     * Set SystemRoleID value
     * @param int $systemRoleID
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setSystemRoleID($systemRoleID = null)
    {
        // validation for constraint: int
        if (!is_null($systemRoleID) && !is_numeric($systemRoleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemRoleID)), __LINE__);
        }
        $this->SystemRoleID = $systemRoleID;
        return $this;
    }
    /**
     * Get MaxCreditAmount value
     * @return float
     */
    public function getMaxCreditAmount()
    {
        return $this->MaxCreditAmount;
    }
    /**
     * Set MaxCreditAmount value
     * @param float $maxCreditAmount
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setMaxCreditAmount($maxCreditAmount = null)
    {
        $this->MaxCreditAmount = $maxCreditAmount;
        return $this;
    }
    /**
     * Get MaxChargeAmount value
     * @return float
     */
    public function getMaxChargeAmount()
    {
        return $this->MaxChargeAmount;
    }
    /**
     * Set MaxChargeAmount value
     * @param float $maxChargeAmount
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setMaxChargeAmount($maxChargeAmount = null)
    {
        $this->MaxChargeAmount = $maxChargeAmount;
        return $this;
    }
    /**
     * Get MaxAccountProtectionDays value
     * @return int
     */
    public function getMaxAccountProtectionDays()
    {
        return $this->MaxAccountProtectionDays;
    }
    /**
     * Set MaxAccountProtectionDays value
     * @param int $maxAccountProtectionDays
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setMaxAccountProtectionDays($maxAccountProtectionDays = null)
    {
        // validation for constraint: int
        if (!is_null($maxAccountProtectionDays) && !is_numeric($maxAccountProtectionDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxAccountProtectionDays)), __LINE__);
        }
        $this->MaxAccountProtectionDays = $maxAccountProtectionDays;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
    /**
     * Get SystemRoleApplications value
     * @return \SGCIS\Array\ArrayOfSystemRoleApplication|null
     */
    public function getSystemRoleApplications()
    {
        return $this->SystemRoleApplications;
    }
    /**
     * Set SystemRoleApplications value
     * @param \SGCIS\Array\ArrayOfSystemRoleApplication $systemRoleApplications
     * @return \SGCIS\Struct\UserSystemRole
     */
    public function setSystemRoleApplications(\SGCIS\Array\ArrayOfSystemRoleApplication $systemRoleApplications = null)
    {
        $this->SystemRoleApplications = $systemRoleApplications;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UserSystemRole
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
