<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserAgentCode Struct
 * @subpackage Structs
 */
class UserAgentCode extends AbstractStructBase
{
    /**
     * The UserAgentCodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserAgentCodeID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The SalesChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SalesChannelID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The IsPrimary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPrimary;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The SalesChannelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesChannelName;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * The ExternalContactNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalContactNumber;
    /**
     * The ExternalAgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalAgentID;
    /**
     * The SalesAgentCompany
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SalesAgentCompany;
    /**
     * Constructor method for UserAgentCode
     * @uses UserAgentCode::setUserAgentCodeID()
     * @uses UserAgentCode::setUserID()
     * @uses UserAgentCode::setSalesChannelID()
     * @uses UserAgentCode::setCreateDate()
     * @uses UserAgentCode::setLastUpdateDate()
     * @uses UserAgentCode::setIsPrimary()
     * @uses UserAgentCode::setAgentID()
     * @uses UserAgentCode::setName()
     * @uses UserAgentCode::setDescription()
     * @uses UserAgentCode::setSalesChannelName()
     * @uses UserAgentCode::setCreatedByUserName()
     * @uses UserAgentCode::setLastUpdateUserName()
     * @uses UserAgentCode::setExternalContactNumber()
     * @uses UserAgentCode::setExternalAgentID()
     * @uses UserAgentCode::setSalesAgentCompany()
     * @param int $userAgentCodeID
     * @param int $userID
     * @param int $salesChannelID
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param bool $isPrimary
     * @param string $agentID
     * @param string $name
     * @param string $description
     * @param string $salesChannelName
     * @param string $createdByUserName
     * @param string $lastUpdateUserName
     * @param string $externalContactNumber
     * @param string $externalAgentID
     * @param string $salesAgentCompany
     */
    public function __construct($userAgentCodeID = null, $userID = null, $salesChannelID = null, $createDate = null, $lastUpdateDate = null, $isPrimary = null, $agentID = null, $name = null, $description = null, $salesChannelName = null, $createdByUserName = null, $lastUpdateUserName = null, $externalContactNumber = null, $externalAgentID = null, $salesAgentCompany = null)
    {
        $this
            ->setUserAgentCodeID($userAgentCodeID)
            ->setUserID($userID)
            ->setSalesChannelID($salesChannelID)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setIsPrimary($isPrimary)
            ->setAgentID($agentID)
            ->setName($name)
            ->setDescription($description)
            ->setSalesChannelName($salesChannelName)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdateUserName($lastUpdateUserName)
            ->setExternalContactNumber($externalContactNumber)
            ->setExternalAgentID($externalAgentID)
            ->setSalesAgentCompany($salesAgentCompany);
    }
    /**
     * Get UserAgentCodeID value
     * @return int
     */
    public function getUserAgentCodeID()
    {
        return $this->UserAgentCodeID;
    }
    /**
     * Set UserAgentCodeID value
     * @param int $userAgentCodeID
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setUserAgentCodeID($userAgentCodeID = null)
    {
        // validation for constraint: int
        if (!is_null($userAgentCodeID) && !is_numeric($userAgentCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userAgentCodeID)), __LINE__);
        }
        $this->UserAgentCodeID = $userAgentCodeID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get SalesChannelID value
     * @return int
     */
    public function getSalesChannelID()
    {
        return $this->SalesChannelID;
    }
    /**
     * Set SalesChannelID value
     * @param int $salesChannelID
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setSalesChannelID($salesChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($salesChannelID) && !is_numeric($salesChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($salesChannelID)), __LINE__);
        }
        $this->SalesChannelID = $salesChannelID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get IsPrimary value
     * @return bool
     */
    public function getIsPrimary()
    {
        return $this->IsPrimary;
    }
    /**
     * Set IsPrimary value
     * @param bool $isPrimary
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPrimary)), __LINE__);
        }
        $this->IsPrimary = $isPrimary;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get SalesChannelName value
     * @return string|null
     */
    public function getSalesChannelName()
    {
        return $this->SalesChannelName;
    }
    /**
     * Set SalesChannelName value
     * @param string $salesChannelName
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setSalesChannelName($salesChannelName = null)
    {
        // validation for constraint: string
        if (!is_null($salesChannelName) && !is_string($salesChannelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesChannelName)), __LINE__);
        }
        $this->SalesChannelName = $salesChannelName;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Get ExternalContactNumber value
     * @return string|null
     */
    public function getExternalContactNumber()
    {
        return $this->ExternalContactNumber;
    }
    /**
     * Set ExternalContactNumber value
     * @param string $externalContactNumber
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setExternalContactNumber($externalContactNumber = null)
    {
        // validation for constraint: string
        if (!is_null($externalContactNumber) && !is_string($externalContactNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalContactNumber)), __LINE__);
        }
        $this->ExternalContactNumber = $externalContactNumber;
        return $this;
    }
    /**
     * Get ExternalAgentID value
     * @return string|null
     */
    public function getExternalAgentID()
    {
        return $this->ExternalAgentID;
    }
    /**
     * Set ExternalAgentID value
     * @param string $externalAgentID
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setExternalAgentID($externalAgentID = null)
    {
        // validation for constraint: string
        if (!is_null($externalAgentID) && !is_string($externalAgentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($externalAgentID)), __LINE__);
        }
        $this->ExternalAgentID = $externalAgentID;
        return $this;
    }
    /**
     * Get SalesAgentCompany value
     * @return string|null
     */
    public function getSalesAgentCompany()
    {
        return $this->SalesAgentCompany;
    }
    /**
     * Set SalesAgentCompany value
     * @param string $salesAgentCompany
     * @return \SGCIS\Struct\UserAgentCode
     */
    public function setSalesAgentCompany($salesAgentCompany = null)
    {
        // validation for constraint: string
        if (!is_null($salesAgentCompany) && !is_string($salesAgentCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($salesAgentCompany)), __LINE__);
        }
        $this->SalesAgentCompany = $salesAgentCompany;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\UserAgentCode
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
