<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketQueueType Struct
 * @subpackage Structs
 */
class TicketQueueType extends AbstractStructBase
{
    /**
     * The TicketQueueTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketQueueTypeID;
    /**
     * The QueueLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QueueLevel;
    /**
     * The MaxQueueEscalationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MaxQueueEscalationLevel;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The DBRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DBRecord;
    /**
     * The OrderChanged
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OrderChanged;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The AssignedRoles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfSystemRoleTicketQueueType
     */
    public $AssignedRoles;
    /**
     * Constructor method for TicketQueueType
     * @uses TicketQueueType::setTicketQueueTypeID()
     * @uses TicketQueueType::setQueueLevel()
     * @uses TicketQueueType::setMaxQueueEscalationLevel()
     * @uses TicketQueueType::setActive()
     * @uses TicketQueueType::setDBRecord()
     * @uses TicketQueueType::setOrderChanged()
     * @uses TicketQueueType::setName()
     * @uses TicketQueueType::setDescription()
     * @uses TicketQueueType::setAssignedRoles()
     * @param int $ticketQueueTypeID
     * @param int $queueLevel
     * @param int $maxQueueEscalationLevel
     * @param bool $active
     * @param bool $dBRecord
     * @param bool $orderChanged
     * @param string $name
     * @param string $description
     * @param \SGCIS\Array\ArrayOfSystemRoleTicketQueueType $assignedRoles
     */
    public function __construct($ticketQueueTypeID = null, $queueLevel = null, $maxQueueEscalationLevel = null, $active = null, $dBRecord = null, $orderChanged = null, $name = null, $description = null, \SGCIS\Array\ArrayOfSystemRoleTicketQueueType $assignedRoles = null)
    {
        $this
            ->setTicketQueueTypeID($ticketQueueTypeID)
            ->setQueueLevel($queueLevel)
            ->setMaxQueueEscalationLevel($maxQueueEscalationLevel)
            ->setActive($active)
            ->setDBRecord($dBRecord)
            ->setOrderChanged($orderChanged)
            ->setName($name)
            ->setDescription($description)
            ->setAssignedRoles($assignedRoles);
    }
    /**
     * Get TicketQueueTypeID value
     * @return int
     */
    public function getTicketQueueTypeID()
    {
        return $this->TicketQueueTypeID;
    }
    /**
     * Set TicketQueueTypeID value
     * @param int $ticketQueueTypeID
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setTicketQueueTypeID($ticketQueueTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketQueueTypeID) && !is_numeric($ticketQueueTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketQueueTypeID)), __LINE__);
        }
        $this->TicketQueueTypeID = $ticketQueueTypeID;
        return $this;
    }
    /**
     * Get QueueLevel value
     * @return int
     */
    public function getQueueLevel()
    {
        return $this->QueueLevel;
    }
    /**
     * Set QueueLevel value
     * @param int $queueLevel
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setQueueLevel($queueLevel = null)
    {
        // validation for constraint: int
        if (!is_null($queueLevel) && !is_numeric($queueLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($queueLevel)), __LINE__);
        }
        $this->QueueLevel = $queueLevel;
        return $this;
    }
    /**
     * Get MaxQueueEscalationLevel value
     * @return int
     */
    public function getMaxQueueEscalationLevel()
    {
        return $this->MaxQueueEscalationLevel;
    }
    /**
     * Set MaxQueueEscalationLevel value
     * @param int $maxQueueEscalationLevel
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setMaxQueueEscalationLevel($maxQueueEscalationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxQueueEscalationLevel) && !is_numeric($maxQueueEscalationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxQueueEscalationLevel)), __LINE__);
        }
        $this->MaxQueueEscalationLevel = $maxQueueEscalationLevel;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get DBRecord value
     * @return bool
     */
    public function getDBRecord()
    {
        return $this->DBRecord;
    }
    /**
     * Set DBRecord value
     * @param bool $dBRecord
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setDBRecord($dBRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($dBRecord) && !is_bool($dBRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dBRecord)), __LINE__);
        }
        $this->DBRecord = $dBRecord;
        return $this;
    }
    /**
     * Get OrderChanged value
     * @return bool
     */
    public function getOrderChanged()
    {
        return $this->OrderChanged;
    }
    /**
     * Set OrderChanged value
     * @param bool $orderChanged
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setOrderChanged($orderChanged = null)
    {
        // validation for constraint: boolean
        if (!is_null($orderChanged) && !is_bool($orderChanged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($orderChanged)), __LINE__);
        }
        $this->OrderChanged = $orderChanged;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AssignedRoles value
     * @return \SGCIS\Array\ArrayOfSystemRoleTicketQueueType|null
     */
    public function getAssignedRoles()
    {
        return $this->AssignedRoles;
    }
    /**
     * Set AssignedRoles value
     * @param \SGCIS\Array\ArrayOfSystemRoleTicketQueueType $assignedRoles
     * @return \SGCIS\Struct\TicketQueueType
     */
    public function setAssignedRoles(\SGCIS\Array\ArrayOfSystemRoleTicketQueueType $assignedRoles = null)
    {
        $this->AssignedRoles = $assignedRoles;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketQueueType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
