<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketNote Struct
 * @subpackage Structs
 */
class TicketNote extends AbstractStructBase
{
    /**
     * The TicketNoteID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketNoteID;
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The NoteDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NoteDate;
    /**
     * The IsDBRecord
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsDBRecord;
    /**
     * The NoteText
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteText;
    /**
     * The NoteUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NoteUserName;
    /**
     * Constructor method for TicketNote
     * @uses TicketNote::setTicketNoteID()
     * @uses TicketNote::setTicketID()
     * @uses TicketNote::setNoteDate()
     * @uses TicketNote::setIsDBRecord()
     * @uses TicketNote::setNoteText()
     * @uses TicketNote::setNoteUserName()
     * @param int $ticketNoteID
     * @param int $ticketID
     * @param string $noteDate
     * @param bool $isDBRecord
     * @param string $noteText
     * @param string $noteUserName
     */
    public function __construct($ticketNoteID = null, $ticketID = null, $noteDate = null, $isDBRecord = null, $noteText = null, $noteUserName = null)
    {
        $this
            ->setTicketNoteID($ticketNoteID)
            ->setTicketID($ticketID)
            ->setNoteDate($noteDate)
            ->setIsDBRecord($isDBRecord)
            ->setNoteText($noteText)
            ->setNoteUserName($noteUserName);
    }
    /**
     * Get TicketNoteID value
     * @return int
     */
    public function getTicketNoteID()
    {
        return $this->TicketNoteID;
    }
    /**
     * Set TicketNoteID value
     * @param int $ticketNoteID
     * @return \SGCIS\Struct\TicketNote
     */
    public function setTicketNoteID($ticketNoteID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNoteID) && !is_numeric($ticketNoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketNoteID)), __LINE__);
        }
        $this->TicketNoteID = $ticketNoteID;
        return $this;
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \SGCIS\Struct\TicketNote
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get NoteDate value
     * @return string
     */
    public function getNoteDate()
    {
        return $this->NoteDate;
    }
    /**
     * Set NoteDate value
     * @param string $noteDate
     * @return \SGCIS\Struct\TicketNote
     */
    public function setNoteDate($noteDate = null)
    {
        // validation for constraint: string
        if (!is_null($noteDate) && !is_string($noteDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteDate)), __LINE__);
        }
        $this->NoteDate = $noteDate;
        return $this;
    }
    /**
     * Get IsDBRecord value
     * @return bool
     */
    public function getIsDBRecord()
    {
        return $this->IsDBRecord;
    }
    /**
     * Set IsDBRecord value
     * @param bool $isDBRecord
     * @return \SGCIS\Struct\TicketNote
     */
    public function setIsDBRecord($isDBRecord = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDBRecord) && !is_bool($isDBRecord)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isDBRecord)), __LINE__);
        }
        $this->IsDBRecord = $isDBRecord;
        return $this;
    }
    /**
     * Get NoteText value
     * @return string|null
     */
    public function getNoteText()
    {
        return $this->NoteText;
    }
    /**
     * Set NoteText value
     * @param string $noteText
     * @return \SGCIS\Struct\TicketNote
     */
    public function setNoteText($noteText = null)
    {
        // validation for constraint: string
        if (!is_null($noteText) && !is_string($noteText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteText)), __LINE__);
        }
        $this->NoteText = $noteText;
        return $this;
    }
    /**
     * Get NoteUserName value
     * @return string|null
     */
    public function getNoteUserName()
    {
        return $this->NoteUserName;
    }
    /**
     * Set NoteUserName value
     * @param string $noteUserName
     * @return \SGCIS\Struct\TicketNote
     */
    public function setNoteUserName($noteUserName = null)
    {
        // validation for constraint: string
        if (!is_null($noteUserName) && !is_string($noteUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($noteUserName)), __LINE__);
        }
        $this->NoteUserName = $noteUserName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\TicketNote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
