<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticket Struct
 * @subpackage Structs
 */
class Ticket extends BaseDTO
{
    /**
     * The TicketID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketID;
    /**
     * The CallID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CallID;
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The SourceTransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SourceTransactionID;
    /**
     * The CurrentTicketStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentTicketStatusID;
    /**
     * The TicketTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketTypeID;
    /**
     * The CloseDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $CloseDate;
    /**
     * The TicketPriorityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TicketPriorityID;
    /**
     * The OpenDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OpenDate;
    /**
     * The AssignedUserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AssignedUserID;
    /**
     * The CurrentEscalationLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CurrentEscalationLevel;
    /**
     * The SlaTimerAlert
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SlaTimerAlert;
    /**
     * The NextReview
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $NextReview;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The TicketNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * The TicketDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketDescription;
    /**
     * The TicketPriorityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketPriorityName;
    /**
     * The CallBackNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CallBackNumber;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The TicketQueue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TicketQueue
     */
    public $TicketQueue;
    /**
     * The TicketType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TicketType
     */
    public $TicketType;
    /**
     * The TicketQueueType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TicketQueueType
     */
    public $TicketQueueType;
    /**
     * The TicketTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketTypeName;
    /**
     * The StatusName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusName;
    /**
     * The QueueName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $QueueName;
    /**
     * The PriorityName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriorityName;
    /**
     * The ServiceLevelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ServiceLevelName;
    /**
     * The AssignedUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AssignedUserName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketNote
     */
    public $Notes;
    /**
     * The FieldValues
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketFieldValue
     */
    public $FieldValues;
    /**
     * The StatusHistory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketStatusHistory
     */
    public $StatusHistory;
    /**
     * The TicketFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTicketField
     */
    public $TicketFields;
    /**
     * The AccountStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountStatus;
    /**
     * Constructor method for Ticket
     * @uses Ticket::setTicketID()
     * @uses Ticket::setCallID()
     * @uses Ticket::setAccountID()
     * @uses Ticket::setSourceTransactionID()
     * @uses Ticket::setCurrentTicketStatusID()
     * @uses Ticket::setTicketTypeID()
     * @uses Ticket::setCloseDate()
     * @uses Ticket::setTicketPriorityID()
     * @uses Ticket::setOpenDate()
     * @uses Ticket::setAssignedUserID()
     * @uses Ticket::setCurrentEscalationLevel()
     * @uses Ticket::setSlaTimerAlert()
     * @uses Ticket::setNextReview()
     * @uses Ticket::setAccountNumber()
     * @uses Ticket::setTicketNumber()
     * @uses Ticket::setTicketDescription()
     * @uses Ticket::setTicketPriorityName()
     * @uses Ticket::setCallBackNumber()
     * @uses Ticket::setContactName()
     * @uses Ticket::setTicketQueue()
     * @uses Ticket::setTicketType()
     * @uses Ticket::setTicketQueueType()
     * @uses Ticket::setTicketTypeName()
     * @uses Ticket::setStatusName()
     * @uses Ticket::setQueueName()
     * @uses Ticket::setPriorityName()
     * @uses Ticket::setServiceLevelName()
     * @uses Ticket::setAssignedUserName()
     * @uses Ticket::setNotes()
     * @uses Ticket::setFieldValues()
     * @uses Ticket::setStatusHistory()
     * @uses Ticket::setTicketFields()
     * @uses Ticket::setAccountStatus()
     * @param int $ticketID
     * @param int $callID
     * @param int $accountID
     * @param int $sourceTransactionID
     * @param int $currentTicketStatusID
     * @param int $ticketTypeID
     * @param string $closeDate
     * @param int $ticketPriorityID
     * @param string $openDate
     * @param int $assignedUserID
     * @param int $currentEscalationLevel
     * @param bool $slaTimerAlert
     * @param string $nextReview
     * @param string $accountNumber
     * @param string $ticketNumber
     * @param string $ticketDescription
     * @param string $ticketPriorityName
     * @param string $callBackNumber
     * @param string $contactName
     * @param \SGCIS\Struct\TicketQueue $ticketQueue
     * @param \SGCIS\Struct\TicketType $ticketType
     * @param \SGCIS\Struct\TicketQueueType $ticketQueueType
     * @param string $ticketTypeName
     * @param string $statusName
     * @param string $queueName
     * @param string $priorityName
     * @param string $serviceLevelName
     * @param string $assignedUserName
     * @param \SGCIS\Array\ArrayOfTicketNote $notes
     * @param \SGCIS\Array\ArrayOfTicketFieldValue $fieldValues
     * @param \SGCIS\Array\ArrayOfTicketStatusHistory $statusHistory
     * @param \SGCIS\Array\ArrayOfTicketField $ticketFields
     * @param string $accountStatus
     */
    public function __construct($ticketID = null, $callID = null, $accountID = null, $sourceTransactionID = null, $currentTicketStatusID = null, $ticketTypeID = null, $closeDate = null, $ticketPriorityID = null, $openDate = null, $assignedUserID = null, $currentEscalationLevel = null, $slaTimerAlert = null, $nextReview = null, $accountNumber = null, $ticketNumber = null, $ticketDescription = null, $ticketPriorityName = null, $callBackNumber = null, $contactName = null, \SGCIS\Struct\TicketQueue $ticketQueue = null, \SGCIS\Struct\TicketType $ticketType = null, \SGCIS\Struct\TicketQueueType $ticketQueueType = null, $ticketTypeName = null, $statusName = null, $queueName = null, $priorityName = null, $serviceLevelName = null, $assignedUserName = null, \SGCIS\Array\ArrayOfTicketNote $notes = null, \SGCIS\Array\ArrayOfTicketFieldValue $fieldValues = null, \SGCIS\Array\ArrayOfTicketStatusHistory $statusHistory = null, \SGCIS\Array\ArrayOfTicketField $ticketFields = null, $accountStatus = null)
    {
        $this
            ->setTicketID($ticketID)
            ->setCallID($callID)
            ->setAccountID($accountID)
            ->setSourceTransactionID($sourceTransactionID)
            ->setCurrentTicketStatusID($currentTicketStatusID)
            ->setTicketTypeID($ticketTypeID)
            ->setCloseDate($closeDate)
            ->setTicketPriorityID($ticketPriorityID)
            ->setOpenDate($openDate)
            ->setAssignedUserID($assignedUserID)
            ->setCurrentEscalationLevel($currentEscalationLevel)
            ->setSlaTimerAlert($slaTimerAlert)
            ->setNextReview($nextReview)
            ->setAccountNumber($accountNumber)
            ->setTicketNumber($ticketNumber)
            ->setTicketDescription($ticketDescription)
            ->setTicketPriorityName($ticketPriorityName)
            ->setCallBackNumber($callBackNumber)
            ->setContactName($contactName)
            ->setTicketQueue($ticketQueue)
            ->setTicketType($ticketType)
            ->setTicketQueueType($ticketQueueType)
            ->setTicketTypeName($ticketTypeName)
            ->setStatusName($statusName)
            ->setQueueName($queueName)
            ->setPriorityName($priorityName)
            ->setServiceLevelName($serviceLevelName)
            ->setAssignedUserName($assignedUserName)
            ->setNotes($notes)
            ->setFieldValues($fieldValues)
            ->setStatusHistory($statusHistory)
            ->setTicketFields($ticketFields)
            ->setAccountStatus($accountStatus);
    }
    /**
     * Get TicketID value
     * @return int
     */
    public function getTicketID()
    {
        return $this->TicketID;
    }
    /**
     * Set TicketID value
     * @param int $ticketID
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketID($ticketID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketID) && !is_numeric($ticketID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketID)), __LINE__);
        }
        $this->TicketID = $ticketID;
        return $this;
    }
    /**
     * Get CallID value
     * @return int
     */
    public function getCallID()
    {
        return $this->CallID;
    }
    /**
     * Set CallID value
     * @param int $callID
     * @return \SGCIS\Struct\Ticket
     */
    public function setCallID($callID = null)
    {
        // validation for constraint: int
        if (!is_null($callID) && !is_numeric($callID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($callID)), __LINE__);
        }
        $this->CallID = $callID;
        return $this;
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\Ticket
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get SourceTransactionID value
     * @return int
     */
    public function getSourceTransactionID()
    {
        return $this->SourceTransactionID;
    }
    /**
     * Set SourceTransactionID value
     * @param int $sourceTransactionID
     * @return \SGCIS\Struct\Ticket
     */
    public function setSourceTransactionID($sourceTransactionID = null)
    {
        // validation for constraint: int
        if (!is_null($sourceTransactionID) && !is_numeric($sourceTransactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sourceTransactionID)), __LINE__);
        }
        $this->SourceTransactionID = $sourceTransactionID;
        return $this;
    }
    /**
     * Get CurrentTicketStatusID value
     * @return int
     */
    public function getCurrentTicketStatusID()
    {
        return $this->CurrentTicketStatusID;
    }
    /**
     * Set CurrentTicketStatusID value
     * @param int $currentTicketStatusID
     * @return \SGCIS\Struct\Ticket
     */
    public function setCurrentTicketStatusID($currentTicketStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($currentTicketStatusID) && !is_numeric($currentTicketStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentTicketStatusID)), __LINE__);
        }
        $this->CurrentTicketStatusID = $currentTicketStatusID;
        return $this;
    }
    /**
     * Get TicketTypeID value
     * @return int
     */
    public function getTicketTypeID()
    {
        return $this->TicketTypeID;
    }
    /**
     * Set TicketTypeID value
     * @param int $ticketTypeID
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketTypeID($ticketTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketTypeID) && !is_numeric($ticketTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketTypeID)), __LINE__);
        }
        $this->TicketTypeID = $ticketTypeID;
        return $this;
    }
    /**
     * Get CloseDate value
     * @return string
     */
    public function getCloseDate()
    {
        return $this->CloseDate;
    }
    /**
     * Set CloseDate value
     * @param string $closeDate
     * @return \SGCIS\Struct\Ticket
     */
    public function setCloseDate($closeDate = null)
    {
        // validation for constraint: string
        if (!is_null($closeDate) && !is_string($closeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($closeDate)), __LINE__);
        }
        $this->CloseDate = $closeDate;
        return $this;
    }
    /**
     * Get TicketPriorityID value
     * @return int
     */
    public function getTicketPriorityID()
    {
        return $this->TicketPriorityID;
    }
    /**
     * Set TicketPriorityID value
     * @param int $ticketPriorityID
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketPriorityID($ticketPriorityID = null)
    {
        // validation for constraint: int
        if (!is_null($ticketPriorityID) && !is_numeric($ticketPriorityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ticketPriorityID)), __LINE__);
        }
        $this->TicketPriorityID = $ticketPriorityID;
        return $this;
    }
    /**
     * Get OpenDate value
     * @return string
     */
    public function getOpenDate()
    {
        return $this->OpenDate;
    }
    /**
     * Set OpenDate value
     * @param string $openDate
     * @return \SGCIS\Struct\Ticket
     */
    public function setOpenDate($openDate = null)
    {
        // validation for constraint: string
        if (!is_null($openDate) && !is_string($openDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($openDate)), __LINE__);
        }
        $this->OpenDate = $openDate;
        return $this;
    }
    /**
     * Get AssignedUserID value
     * @return int
     */
    public function getAssignedUserID()
    {
        return $this->AssignedUserID;
    }
    /**
     * Set AssignedUserID value
     * @param int $assignedUserID
     * @return \SGCIS\Struct\Ticket
     */
    public function setAssignedUserID($assignedUserID = null)
    {
        // validation for constraint: int
        if (!is_null($assignedUserID) && !is_numeric($assignedUserID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($assignedUserID)), __LINE__);
        }
        $this->AssignedUserID = $assignedUserID;
        return $this;
    }
    /**
     * Get CurrentEscalationLevel value
     * @return int
     */
    public function getCurrentEscalationLevel()
    {
        return $this->CurrentEscalationLevel;
    }
    /**
     * Set CurrentEscalationLevel value
     * @param int $currentEscalationLevel
     * @return \SGCIS\Struct\Ticket
     */
    public function setCurrentEscalationLevel($currentEscalationLevel = null)
    {
        // validation for constraint: int
        if (!is_null($currentEscalationLevel) && !is_numeric($currentEscalationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($currentEscalationLevel)), __LINE__);
        }
        $this->CurrentEscalationLevel = $currentEscalationLevel;
        return $this;
    }
    /**
     * Get SlaTimerAlert value
     * @return bool
     */
    public function getSlaTimerAlert()
    {
        return $this->SlaTimerAlert;
    }
    /**
     * Set SlaTimerAlert value
     * @param bool $slaTimerAlert
     * @return \SGCIS\Struct\Ticket
     */
    public function setSlaTimerAlert($slaTimerAlert = null)
    {
        // validation for constraint: boolean
        if (!is_null($slaTimerAlert) && !is_bool($slaTimerAlert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($slaTimerAlert)), __LINE__);
        }
        $this->SlaTimerAlert = $slaTimerAlert;
        return $this;
    }
    /**
     * Get NextReview value
     * @return string
     */
    public function getNextReview()
    {
        return $this->NextReview;
    }
    /**
     * Set NextReview value
     * @param string $nextReview
     * @return \SGCIS\Struct\Ticket
     */
    public function setNextReview($nextReview = null)
    {
        // validation for constraint: string
        if (!is_null($nextReview) && !is_string($nextReview)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nextReview)), __LINE__);
        }
        $this->NextReview = $nextReview;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\Ticket
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get TicketDescription value
     * @return string|null
     */
    public function getTicketDescription()
    {
        return $this->TicketDescription;
    }
    /**
     * Set TicketDescription value
     * @param string $ticketDescription
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketDescription($ticketDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDescription) && !is_string($ticketDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketDescription)), __LINE__);
        }
        $this->TicketDescription = $ticketDescription;
        return $this;
    }
    /**
     * Get TicketPriorityName value
     * @return string|null
     */
    public function getTicketPriorityName()
    {
        return $this->TicketPriorityName;
    }
    /**
     * Set TicketPriorityName value
     * @param string $ticketPriorityName
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketPriorityName($ticketPriorityName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketPriorityName) && !is_string($ticketPriorityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketPriorityName)), __LINE__);
        }
        $this->TicketPriorityName = $ticketPriorityName;
        return $this;
    }
    /**
     * Get CallBackNumber value
     * @return string|null
     */
    public function getCallBackNumber()
    {
        return $this->CallBackNumber;
    }
    /**
     * Set CallBackNumber value
     * @param string $callBackNumber
     * @return \SGCIS\Struct\Ticket
     */
    public function setCallBackNumber($callBackNumber = null)
    {
        // validation for constraint: string
        if (!is_null($callBackNumber) && !is_string($callBackNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($callBackNumber)), __LINE__);
        }
        $this->CallBackNumber = $callBackNumber;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \SGCIS\Struct\Ticket
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get TicketQueue value
     * @return \SGCIS\Struct\TicketQueue|null
     */
    public function getTicketQueue()
    {
        return $this->TicketQueue;
    }
    /**
     * Set TicketQueue value
     * @param \SGCIS\Struct\TicketQueue $ticketQueue
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketQueue(\SGCIS\Struct\TicketQueue $ticketQueue = null)
    {
        $this->TicketQueue = $ticketQueue;
        return $this;
    }
    /**
     * Get TicketType value
     * @return \SGCIS\Struct\TicketType|null
     */
    public function getTicketType()
    {
        return $this->TicketType;
    }
    /**
     * Set TicketType value
     * @param \SGCIS\Struct\TicketType $ticketType
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketType(\SGCIS\Struct\TicketType $ticketType = null)
    {
        $this->TicketType = $ticketType;
        return $this;
    }
    /**
     * Get TicketQueueType value
     * @return \SGCIS\Struct\TicketQueueType|null
     */
    public function getTicketQueueType()
    {
        return $this->TicketQueueType;
    }
    /**
     * Set TicketQueueType value
     * @param \SGCIS\Struct\TicketQueueType $ticketQueueType
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketQueueType(\SGCIS\Struct\TicketQueueType $ticketQueueType = null)
    {
        $this->TicketQueueType = $ticketQueueType;
        return $this;
    }
    /**
     * Get TicketTypeName value
     * @return string|null
     */
    public function getTicketTypeName()
    {
        return $this->TicketTypeName;
    }
    /**
     * Set TicketTypeName value
     * @param string $ticketTypeName
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketTypeName($ticketTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($ticketTypeName) && !is_string($ticketTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ticketTypeName)), __LINE__);
        }
        $this->TicketTypeName = $ticketTypeName;
        return $this;
    }
    /**
     * Get StatusName value
     * @return string|null
     */
    public function getStatusName()
    {
        return $this->StatusName;
    }
    /**
     * Set StatusName value
     * @param string $statusName
     * @return \SGCIS\Struct\Ticket
     */
    public function setStatusName($statusName = null)
    {
        // validation for constraint: string
        if (!is_null($statusName) && !is_string($statusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusName)), __LINE__);
        }
        $this->StatusName = $statusName;
        return $this;
    }
    /**
     * Get QueueName value
     * @return string|null
     */
    public function getQueueName()
    {
        return $this->QueueName;
    }
    /**
     * Set QueueName value
     * @param string $queueName
     * @return \SGCIS\Struct\Ticket
     */
    public function setQueueName($queueName = null)
    {
        // validation for constraint: string
        if (!is_null($queueName) && !is_string($queueName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueName)), __LINE__);
        }
        $this->QueueName = $queueName;
        return $this;
    }
    /**
     * Get PriorityName value
     * @return string|null
     */
    public function getPriorityName()
    {
        return $this->PriorityName;
    }
    /**
     * Set PriorityName value
     * @param string $priorityName
     * @return \SGCIS\Struct\Ticket
     */
    public function setPriorityName($priorityName = null)
    {
        // validation for constraint: string
        if (!is_null($priorityName) && !is_string($priorityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($priorityName)), __LINE__);
        }
        $this->PriorityName = $priorityName;
        return $this;
    }
    /**
     * Get ServiceLevelName value
     * @return string|null
     */
    public function getServiceLevelName()
    {
        return $this->ServiceLevelName;
    }
    /**
     * Set ServiceLevelName value
     * @param string $serviceLevelName
     * @return \SGCIS\Struct\Ticket
     */
    public function setServiceLevelName($serviceLevelName = null)
    {
        // validation for constraint: string
        if (!is_null($serviceLevelName) && !is_string($serviceLevelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceLevelName)), __LINE__);
        }
        $this->ServiceLevelName = $serviceLevelName;
        return $this;
    }
    /**
     * Get AssignedUserName value
     * @return string|null
     */
    public function getAssignedUserName()
    {
        return $this->AssignedUserName;
    }
    /**
     * Set AssignedUserName value
     * @param string $assignedUserName
     * @return \SGCIS\Struct\Ticket
     */
    public function setAssignedUserName($assignedUserName = null)
    {
        // validation for constraint: string
        if (!is_null($assignedUserName) && !is_string($assignedUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($assignedUserName)), __LINE__);
        }
        $this->AssignedUserName = $assignedUserName;
        return $this;
    }
    /**
     * Get Notes value
     * @return \SGCIS\Array\ArrayOfTicketNote|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param \SGCIS\Array\ArrayOfTicketNote $notes
     * @return \SGCIS\Struct\Ticket
     */
    public function setNotes(\SGCIS\Array\ArrayOfTicketNote $notes = null)
    {
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get FieldValues value
     * @return \SGCIS\Array\ArrayOfTicketFieldValue|null
     */
    public function getFieldValues()
    {
        return $this->FieldValues;
    }
    /**
     * Set FieldValues value
     * @param \SGCIS\Array\ArrayOfTicketFieldValue $fieldValues
     * @return \SGCIS\Struct\Ticket
     */
    public function setFieldValues(\SGCIS\Array\ArrayOfTicketFieldValue $fieldValues = null)
    {
        $this->FieldValues = $fieldValues;
        return $this;
    }
    /**
     * Get StatusHistory value
     * @return \SGCIS\Array\ArrayOfTicketStatusHistory|null
     */
    public function getStatusHistory()
    {
        return $this->StatusHistory;
    }
    /**
     * Set StatusHistory value
     * @param \SGCIS\Array\ArrayOfTicketStatusHistory $statusHistory
     * @return \SGCIS\Struct\Ticket
     */
    public function setStatusHistory(\SGCIS\Array\ArrayOfTicketStatusHistory $statusHistory = null)
    {
        $this->StatusHistory = $statusHistory;
        return $this;
    }
    /**
     * Get TicketFields value
     * @return \SGCIS\Array\ArrayOfTicketField|null
     */
    public function getTicketFields()
    {
        return $this->TicketFields;
    }
    /**
     * Set TicketFields value
     * @param \SGCIS\Array\ArrayOfTicketField $ticketFields
     * @return \SGCIS\Struct\Ticket
     */
    public function setTicketFields(\SGCIS\Array\ArrayOfTicketField $ticketFields = null)
    {
        $this->TicketFields = $ticketFields;
        return $this;
    }
    /**
     * Get AccountStatus value
     * @return string|null
     */
    public function getAccountStatus()
    {
        return $this->AccountStatus;
    }
    /**
     * Set AccountStatus value
     * @param string $accountStatus
     * @return \SGCIS\Struct\Ticket
     */
    public function setAccountStatus($accountStatus = null)
    {
        // validation for constraint: string
        if (!is_null($accountStatus) && !is_string($accountStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountStatus)), __LINE__);
        }
        $this->AccountStatus = $accountStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Ticket
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
