<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SystemProperty Struct
 * @subpackage Structs
 */
class SystemProperty extends BaseDTO
{
    /**
     * The SystemPropertyCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemPropertyCategoryID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The PropertyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PropertyName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The PropertyValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PropertyValue;
    /**
     * The DisplayName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The SystemPropertyCategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SystemPropertyCategoryName;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * Constructor method for SystemProperty
     * @uses SystemProperty::setSystemPropertyCategoryID()
     * @uses SystemProperty::setCompanyID()
     * @uses SystemProperty::setPropertyName()
     * @uses SystemProperty::setDescription()
     * @uses SystemProperty::setPropertyValue()
     * @uses SystemProperty::setDisplayName()
     * @uses SystemProperty::setSystemPropertyCategoryName()
     * @uses SystemProperty::setCompanyName()
     * @param int $systemPropertyCategoryID
     * @param int $companyID
     * @param string $propertyName
     * @param string $description
     * @param string $propertyValue
     * @param string $displayName
     * @param string $systemPropertyCategoryName
     * @param string $companyName
     */
    public function __construct($systemPropertyCategoryID = null, $companyID = null, $propertyName = null, $description = null, $propertyValue = null, $displayName = null, $systemPropertyCategoryName = null, $companyName = null)
    {
        $this
            ->setSystemPropertyCategoryID($systemPropertyCategoryID)
            ->setCompanyID($companyID)
            ->setPropertyName($propertyName)
            ->setDescription($description)
            ->setPropertyValue($propertyValue)
            ->setDisplayName($displayName)
            ->setSystemPropertyCategoryName($systemPropertyCategoryName)
            ->setCompanyName($companyName);
    }
    /**
     * Get SystemPropertyCategoryID value
     * @return int
     */
    public function getSystemPropertyCategoryID()
    {
        return $this->SystemPropertyCategoryID;
    }
    /**
     * Set SystemPropertyCategoryID value
     * @param int $systemPropertyCategoryID
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setSystemPropertyCategoryID($systemPropertyCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($systemPropertyCategoryID) && !is_numeric($systemPropertyCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemPropertyCategoryID)), __LINE__);
        }
        $this->SystemPropertyCategoryID = $systemPropertyCategoryID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get PropertyName value
     * @return string|null
     */
    public function getPropertyName()
    {
        return $this->PropertyName;
    }
    /**
     * Set PropertyName value
     * @param string $propertyName
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyName)), __LINE__);
        }
        $this->PropertyName = $propertyName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get PropertyValue value
     * @return string|null
     */
    public function getPropertyValue()
    {
        return $this->PropertyValue;
    }
    /**
     * Set PropertyValue value
     * @param string $propertyValue
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setPropertyValue($propertyValue = null)
    {
        // validation for constraint: string
        if (!is_null($propertyValue) && !is_string($propertyValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($propertyValue)), __LINE__);
        }
        $this->PropertyValue = $propertyValue;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get SystemPropertyCategoryName value
     * @return string|null
     */
    public function getSystemPropertyCategoryName()
    {
        return $this->SystemPropertyCategoryName;
    }
    /**
     * Set SystemPropertyCategoryName value
     * @param string $systemPropertyCategoryName
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setSystemPropertyCategoryName($systemPropertyCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($systemPropertyCategoryName) && !is_string($systemPropertyCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemPropertyCategoryName)), __LINE__);
        }
        $this->SystemPropertyCategoryName = $systemPropertyCategoryName;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\SystemProperty
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\SystemProperty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
