<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterRequest Struct
 * @subpackage Structs
 */
class RegisterRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The SendAuthCodeNotificationChannelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SendAuthCodeNotificationChannelID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The TwoFactorAuthCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TwoFactorAuthCode;
    /**
     * The PhoneNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PhoneNumber;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * Constructor method for RegisterRequest
     * @uses RegisterRequest::setAccountID()
     * @uses RegisterRequest::setSendAuthCodeNotificationChannelID()
     * @uses RegisterRequest::setAccountNumber()
     * @uses RegisterRequest::setEmail()
     * @uses RegisterRequest::setTwoFactorAuthCode()
     * @uses RegisterRequest::setPhoneNumber()
     * @uses RegisterRequest::setUserName()
     * @uses RegisterRequest::setPassword()
     * @uses RegisterRequest::setZipCode()
     * @param int $accountID
     * @param int $sendAuthCodeNotificationChannelID
     * @param string $accountNumber
     * @param string $email
     * @param string $twoFactorAuthCode
     * @param string $phoneNumber
     * @param string $userName
     * @param string $password
     * @param string $zipCode
     */
    public function __construct($accountID = null, $sendAuthCodeNotificationChannelID = null, $accountNumber = null, $email = null, $twoFactorAuthCode = null, $phoneNumber = null, $userName = null, $password = null, $zipCode = null)
    {
        $this
            ->setAccountID($accountID)
            ->setSendAuthCodeNotificationChannelID($sendAuthCodeNotificationChannelID)
            ->setAccountNumber($accountNumber)
            ->setEmail($email)
            ->setTwoFactorAuthCode($twoFactorAuthCode)
            ->setPhoneNumber($phoneNumber)
            ->setUserName($userName)
            ->setPassword($password)
            ->setZipCode($zipCode);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get SendAuthCodeNotificationChannelID value
     * @return int
     */
    public function getSendAuthCodeNotificationChannelID()
    {
        return $this->SendAuthCodeNotificationChannelID;
    }
    /**
     * Set SendAuthCodeNotificationChannelID value
     * @param int $sendAuthCodeNotificationChannelID
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setSendAuthCodeNotificationChannelID($sendAuthCodeNotificationChannelID = null)
    {
        // validation for constraint: int
        if (!is_null($sendAuthCodeNotificationChannelID) && !is_numeric($sendAuthCodeNotificationChannelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sendAuthCodeNotificationChannelID)), __LINE__);
        }
        $this->SendAuthCodeNotificationChannelID = $sendAuthCodeNotificationChannelID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get TwoFactorAuthCode value
     * @return string|null
     */
    public function getTwoFactorAuthCode()
    {
        return $this->TwoFactorAuthCode;
    }
    /**
     * Set TwoFactorAuthCode value
     * @param string $twoFactorAuthCode
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setTwoFactorAuthCode($twoFactorAuthCode = null)
    {
        // validation for constraint: string
        if (!is_null($twoFactorAuthCode) && !is_string($twoFactorAuthCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($twoFactorAuthCode)), __LINE__);
        }
        $this->TwoFactorAuthCode = $twoFactorAuthCode;
        return $this;
    }
    /**
     * Get PhoneNumber value
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->PhoneNumber;
    }
    /**
     * Set PhoneNumber value
     * @param string $phoneNumber
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setPhoneNumber($phoneNumber = null)
    {
        // validation for constraint: string
        if (!is_null($phoneNumber) && !is_string($phoneNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phoneNumber)), __LINE__);
        }
        $this->PhoneNumber = $phoneNumber;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\RegisterRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\RegisterRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
