<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromotionTier Struct
 * @subpackage Structs
 */
class PromotionTier extends AbstractStructBase
{
    /**
     * The PromotionTierID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionTierID;
    /**
     * The PromotionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PromotionID;
    /**
     * The FromAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $FromAmount;
    /**
     * The ToAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ToAmount;
    /**
     * The PromotionAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PromotionAmount;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The TierLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TierLevel;
    /**
     * Constructor method for PromotionTier
     * @uses PromotionTier::setPromotionTierID()
     * @uses PromotionTier::setPromotionID()
     * @uses PromotionTier::setFromAmount()
     * @uses PromotionTier::setToAmount()
     * @uses PromotionTier::setPromotionAmount()
     * @uses PromotionTier::setCreateDate()
     * @uses PromotionTier::setTierLevel()
     * @param int $promotionTierID
     * @param int $promotionID
     * @param float $fromAmount
     * @param float $toAmount
     * @param float $promotionAmount
     * @param string $createDate
     * @param string $tierLevel
     */
    public function __construct($promotionTierID = null, $promotionID = null, $fromAmount = null, $toAmount = null, $promotionAmount = null, $createDate = null, $tierLevel = null)
    {
        $this
            ->setPromotionTierID($promotionTierID)
            ->setPromotionID($promotionID)
            ->setFromAmount($fromAmount)
            ->setToAmount($toAmount)
            ->setPromotionAmount($promotionAmount)
            ->setCreateDate($createDate)
            ->setTierLevel($tierLevel);
    }
    /**
     * Get PromotionTierID value
     * @return int
     */
    public function getPromotionTierID()
    {
        return $this->PromotionTierID;
    }
    /**
     * Set PromotionTierID value
     * @param int $promotionTierID
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setPromotionTierID($promotionTierID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionTierID) && !is_numeric($promotionTierID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionTierID)), __LINE__);
        }
        $this->PromotionTierID = $promotionTierID;
        return $this;
    }
    /**
     * Get PromotionID value
     * @return int
     */
    public function getPromotionID()
    {
        return $this->PromotionID;
    }
    /**
     * Set PromotionID value
     * @param int $promotionID
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setPromotionID($promotionID = null)
    {
        // validation for constraint: int
        if (!is_null($promotionID) && !is_numeric($promotionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($promotionID)), __LINE__);
        }
        $this->PromotionID = $promotionID;
        return $this;
    }
    /**
     * Get FromAmount value
     * @return float
     */
    public function getFromAmount()
    {
        return $this->FromAmount;
    }
    /**
     * Set FromAmount value
     * @param float $fromAmount
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setFromAmount($fromAmount = null)
    {
        $this->FromAmount = $fromAmount;
        return $this;
    }
    /**
     * Get ToAmount value
     * @return float
     */
    public function getToAmount()
    {
        return $this->ToAmount;
    }
    /**
     * Set ToAmount value
     * @param float $toAmount
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setToAmount($toAmount = null)
    {
        $this->ToAmount = $toAmount;
        return $this;
    }
    /**
     * Get PromotionAmount value
     * @return float
     */
    public function getPromotionAmount()
    {
        return $this->PromotionAmount;
    }
    /**
     * Set PromotionAmount value
     * @param float $promotionAmount
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setPromotionAmount($promotionAmount = null)
    {
        $this->PromotionAmount = $promotionAmount;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get TierLevel value
     * @return string|null
     */
    public function getTierLevel()
    {
        return $this->TierLevel;
    }
    /**
     * Set TierLevel value
     * @param string $tierLevel
     * @return \SGCIS\Struct\PromotionTier
     */
    public function setTierLevel($tierLevel = null)
    {
        // validation for constraint: string
        if (!is_null($tierLevel) && !is_string($tierLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tierLevel)), __LINE__);
        }
        $this->TierLevel = $tierLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PromotionTier
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
