<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductLookupResponse Struct
 * @subpackage Structs
 */
class ProductLookupResponse extends ServiceResponseBase
{
    /**
     * The Products
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfProduct
     */
    public $Products;
    /**
     * The WebProducts
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfWebProduct
     */
    public $WebProducts;
    /**
     * The DistributionServiceProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\DistributionServiceProvider
     */
    public $DistributionServiceProvider;
    /**
     * The DistributionServiceProviders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionServiceProvider
     */
    public $DistributionServiceProviders;
    /**
     * Constructor method for ProductLookupResponse
     * @uses ProductLookupResponse::setProducts()
     * @uses ProductLookupResponse::setWebProducts()
     * @uses ProductLookupResponse::setDistributionServiceProvider()
     * @uses ProductLookupResponse::setDistributionServiceProviders()
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @param \SGCIS\Array\ArrayOfWebProduct $webProducts
     * @param \SGCIS\Struct\DistributionServiceProvider $distributionServiceProvider
     * @param \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders
     */
    public function __construct(\SGCIS\Array\ArrayOfProduct $products = null, \SGCIS\Array\ArrayOfWebProduct $webProducts = null, \SGCIS\Struct\DistributionServiceProvider $distributionServiceProvider = null, \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders = null)
    {
        $this
            ->setProducts($products)
            ->setWebProducts($webProducts)
            ->setDistributionServiceProvider($distributionServiceProvider)
            ->setDistributionServiceProviders($distributionServiceProviders);
    }
    /**
     * Get Products value
     * @return \SGCIS\Array\ArrayOfProduct|null
     */
    public function getProducts()
    {
        return $this->Products;
    }
    /**
     * Set Products value
     * @param \SGCIS\Array\ArrayOfProduct $products
     * @return \SGCIS\Struct\ProductLookupResponse
     */
    public function setProducts(\SGCIS\Array\ArrayOfProduct $products = null)
    {
        $this->Products = $products;
        return $this;
    }
    /**
     * Get WebProducts value
     * @return \SGCIS\Array\ArrayOfWebProduct|null
     */
    public function getWebProducts()
    {
        return $this->WebProducts;
    }
    /**
     * Set WebProducts value
     * @param \SGCIS\Array\ArrayOfWebProduct $webProducts
     * @return \SGCIS\Struct\ProductLookupResponse
     */
    public function setWebProducts(\SGCIS\Array\ArrayOfWebProduct $webProducts = null)
    {
        $this->WebProducts = $webProducts;
        return $this;
    }
    /**
     * Get DistributionServiceProvider value
     * @return \SGCIS\Struct\DistributionServiceProvider|null
     */
    public function getDistributionServiceProvider()
    {
        return $this->DistributionServiceProvider;
    }
    /**
     * Set DistributionServiceProvider value
     * @param \SGCIS\Struct\DistributionServiceProvider $distributionServiceProvider
     * @return \SGCIS\Struct\ProductLookupResponse
     */
    public function setDistributionServiceProvider(\SGCIS\Struct\DistributionServiceProvider $distributionServiceProvider = null)
    {
        $this->DistributionServiceProvider = $distributionServiceProvider;
        return $this;
    }
    /**
     * Get DistributionServiceProviders value
     * @return \SGCIS\Array\ArrayOfDistributionServiceProvider|null
     */
    public function getDistributionServiceProviders()
    {
        return $this->DistributionServiceProviders;
    }
    /**
     * Set DistributionServiceProviders value
     * @param \SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders
     * @return \SGCIS\Struct\ProductLookupResponse
     */
    public function setDistributionServiceProviders(\SGCIS\Array\ArrayOfDistributionServiceProvider $distributionServiceProviders = null)
    {
        $this->DistributionServiceProviders = $distributionServiceProviders;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductLookupResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
