<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductLookupRequest Struct
 * @subpackage Structs
 */
class ProductLookupRequest extends ServiceRequestBase
{
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The EffectiveStartEndDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EffectiveStartEndDate;
    /**
     * The ProductTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductTypeID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The ZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZipCode;
    /**
     * The MarketingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarketingCode;
    /**
     * The ProductTag
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductTag;
    /**
     * The AgentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AgentID;
    /**
     * Constructor method for ProductLookupRequest
     * @uses ProductLookupRequest::setDistributionServiceProviderID()
     * @uses ProductLookupRequest::setActive()
     * @uses ProductLookupRequest::setEffectiveStartEndDate()
     * @uses ProductLookupRequest::setProductTypeID()
     * @uses ProductLookupRequest::setAccountTypeID()
     * @uses ProductLookupRequest::setCompanyID()
     * @uses ProductLookupRequest::setZipCode()
     * @uses ProductLookupRequest::setMarketingCode()
     * @uses ProductLookupRequest::setProductTag()
     * @uses ProductLookupRequest::setAgentID()
     * @param int $distributionServiceProviderID
     * @param bool $active
     * @param bool $effectiveStartEndDate
     * @param int $productTypeID
     * @param int $accountTypeID
     * @param int $companyID
     * @param string $zipCode
     * @param string $marketingCode
     * @param string $productTag
     * @param string $agentID
     */
    public function __construct($distributionServiceProviderID = null, $active = null, $effectiveStartEndDate = null, $productTypeID = null, $accountTypeID = null, $companyID = null, $zipCode = null, $marketingCode = null, $productTag = null, $agentID = null)
    {
        $this
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setActive($active)
            ->setEffectiveStartEndDate($effectiveStartEndDate)
            ->setProductTypeID($productTypeID)
            ->setAccountTypeID($accountTypeID)
            ->setCompanyID($companyID)
            ->setZipCode($zipCode)
            ->setMarketingCode($marketingCode)
            ->setProductTag($productTag)
            ->setAgentID($agentID);
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get EffectiveStartEndDate value
     * @return bool
     */
    public function getEffectiveStartEndDate()
    {
        return $this->EffectiveStartEndDate;
    }
    /**
     * Set EffectiveStartEndDate value
     * @param bool $effectiveStartEndDate
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setEffectiveStartEndDate($effectiveStartEndDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($effectiveStartEndDate) && !is_bool($effectiveStartEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($effectiveStartEndDate)), __LINE__);
        }
        $this->EffectiveStartEndDate = $effectiveStartEndDate;
        return $this;
    }
    /**
     * Get ProductTypeID value
     * @return int
     */
    public function getProductTypeID()
    {
        return $this->ProductTypeID;
    }
    /**
     * Set ProductTypeID value
     * @param int $productTypeID
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setProductTypeID($productTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productTypeID) && !is_numeric($productTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productTypeID)), __LINE__);
        }
        $this->ProductTypeID = $productTypeID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get ZipCode value
     * @return string|null
     */
    public function getZipCode()
    {
        return $this->ZipCode;
    }
    /**
     * Set ZipCode value
     * @param string $zipCode
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setZipCode($zipCode = null)
    {
        // validation for constraint: string
        if (!is_null($zipCode) && !is_string($zipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zipCode)), __LINE__);
        }
        $this->ZipCode = $zipCode;
        return $this;
    }
    /**
     * Get MarketingCode value
     * @return string|null
     */
    public function getMarketingCode()
    {
        return $this->MarketingCode;
    }
    /**
     * Set MarketingCode value
     * @param string $marketingCode
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setMarketingCode($marketingCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCode) && !is_string($marketingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketingCode)), __LINE__);
        }
        $this->MarketingCode = $marketingCode;
        return $this;
    }
    /**
     * Get ProductTag value
     * @return string|null
     */
    public function getProductTag()
    {
        return $this->ProductTag;
    }
    /**
     * Set ProductTag value
     * @param string $productTag
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setProductTag($productTag = null)
    {
        // validation for constraint: string
        if (!is_null($productTag) && !is_string($productTag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productTag)), __LINE__);
        }
        $this->ProductTag = $productTag;
        return $this;
    }
    /**
     * Get AgentID value
     * @return string|null
     */
    public function getAgentID()
    {
        return $this->AgentID;
    }
    /**
     * Set AgentID value
     * @param string $agentID
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public function setAgentID($agentID = null)
    {
        // validation for constraint: string
        if (!is_null($agentID) && !is_string($agentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agentID)), __LINE__);
        }
        $this->AgentID = $agentID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductLookupRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
