<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductAccountType Struct
 * @subpackage Structs
 */
class ProductAccountType extends BaseDTO
{
    /**
     * The ProductAccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductAccountTypeID;
    /**
     * The AccountTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountTypeID;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The AccountTypeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountTypeName;
    /**
     * Constructor method for ProductAccountType
     * @uses ProductAccountType::setProductAccountTypeID()
     * @uses ProductAccountType::setAccountTypeID()
     * @uses ProductAccountType::setProductID()
     * @uses ProductAccountType::setAccountTypeName()
     * @param int $productAccountTypeID
     * @param int $accountTypeID
     * @param int $productID
     * @param string $accountTypeName
     */
    public function __construct($productAccountTypeID = null, $accountTypeID = null, $productID = null, $accountTypeName = null)
    {
        $this
            ->setProductAccountTypeID($productAccountTypeID)
            ->setAccountTypeID($accountTypeID)
            ->setProductID($productID)
            ->setAccountTypeName($accountTypeName);
    }
    /**
     * Get ProductAccountTypeID value
     * @return int
     */
    public function getProductAccountTypeID()
    {
        return $this->ProductAccountTypeID;
    }
    /**
     * Set ProductAccountTypeID value
     * @param int $productAccountTypeID
     * @return \SGCIS\Struct\ProductAccountType
     */
    public function setProductAccountTypeID($productAccountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($productAccountTypeID) && !is_numeric($productAccountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productAccountTypeID)), __LINE__);
        }
        $this->ProductAccountTypeID = $productAccountTypeID;
        return $this;
    }
    /**
     * Get AccountTypeID value
     * @return int
     */
    public function getAccountTypeID()
    {
        return $this->AccountTypeID;
    }
    /**
     * Set AccountTypeID value
     * @param int $accountTypeID
     * @return \SGCIS\Struct\ProductAccountType
     */
    public function setAccountTypeID($accountTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($accountTypeID) && !is_numeric($accountTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountTypeID)), __LINE__);
        }
        $this->AccountTypeID = $accountTypeID;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \SGCIS\Struct\ProductAccountType
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get AccountTypeName value
     * @return string|null
     */
    public function getAccountTypeName()
    {
        return $this->AccountTypeName;
    }
    /**
     * Set AccountTypeName value
     * @param string $accountTypeName
     * @return \SGCIS\Struct\ProductAccountType
     */
    public function setAccountTypeName($accountTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($accountTypeName) && !is_string($accountTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountTypeName)), __LINE__);
        }
        $this->AccountTypeName = $accountTypeName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\ProductAccountType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
