<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostPaymentResponse Struct
 * @subpackage Structs
 */
class PostPaymentResponse extends ServiceResponseBase
{
    /**
     * The TotalFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalFees;
    /**
     * The AccountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AccountBalance;
    /**
     * The DaysRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysRemaining;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsApproved;
    /**
     * The GatewayAccessLogId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GatewayAccessLogId;
    /**
     * The PaymentConfirmationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentConfirmationNumber;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The PaymentVendorMessage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentVendorMessage;
    /**
     * The PaymentEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentEvent
     */
    public $PaymentEvent;
    /**
     * The PaymentReceipt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentReceipt;
    /**
     * The ReceiptName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptName;
    /**
     * The ReceiptInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReceiptInformation;
    /**
     * The GateWayTransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GateWayTransactionId;
    /**
     * Constructor method for PostPaymentResponse
     * @uses PostPaymentResponse::setTotalFees()
     * @uses PostPaymentResponse::setAccountBalance()
     * @uses PostPaymentResponse::setDaysRemaining()
     * @uses PostPaymentResponse::setIsApproved()
     * @uses PostPaymentResponse::setGatewayAccessLogId()
     * @uses PostPaymentResponse::setPaymentConfirmationNumber()
     * @uses PostPaymentResponse::setTransactionID()
     * @uses PostPaymentResponse::setPaymentVendorMessage()
     * @uses PostPaymentResponse::setPaymentEvent()
     * @uses PostPaymentResponse::setPaymentReceipt()
     * @uses PostPaymentResponse::setReceiptName()
     * @uses PostPaymentResponse::setReceiptInformation()
     * @uses PostPaymentResponse::setGateWayTransactionId()
     * @param float $totalFees
     * @param float $accountBalance
     * @param int $daysRemaining
     * @param bool $isApproved
     * @param int $gatewayAccessLogId
     * @param string $paymentConfirmationNumber
     * @param string $transactionID
     * @param string $paymentVendorMessage
     * @param \SGCIS\Struct\PaymentEvent $paymentEvent
     * @param string $paymentReceipt
     * @param string $receiptName
     * @param string $receiptInformation
     * @param string $gateWayTransactionId
     */
    public function __construct($totalFees = null, $accountBalance = null, $daysRemaining = null, $isApproved = null, $gatewayAccessLogId = null, $paymentConfirmationNumber = null, $transactionID = null, $paymentVendorMessage = null, \SGCIS\Struct\PaymentEvent $paymentEvent = null, $paymentReceipt = null, $receiptName = null, $receiptInformation = null, $gateWayTransactionId = null)
    {
        $this
            ->setTotalFees($totalFees)
            ->setAccountBalance($accountBalance)
            ->setDaysRemaining($daysRemaining)
            ->setIsApproved($isApproved)
            ->setGatewayAccessLogId($gatewayAccessLogId)
            ->setPaymentConfirmationNumber($paymentConfirmationNumber)
            ->setTransactionID($transactionID)
            ->setPaymentVendorMessage($paymentVendorMessage)
            ->setPaymentEvent($paymentEvent)
            ->setPaymentReceipt($paymentReceipt)
            ->setReceiptName($receiptName)
            ->setReceiptInformation($receiptInformation)
            ->setGateWayTransactionId($gateWayTransactionId);
    }
    /**
     * Get TotalFees value
     * @return float
     */
    public function getTotalFees()
    {
        return $this->TotalFees;
    }
    /**
     * Set TotalFees value
     * @param float $totalFees
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setTotalFees($totalFees = null)
    {
        $this->TotalFees = $totalFees;
        return $this;
    }
    /**
     * Get AccountBalance value
     * @return float
     */
    public function getAccountBalance()
    {
        return $this->AccountBalance;
    }
    /**
     * Set AccountBalance value
     * @param float $accountBalance
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setAccountBalance($accountBalance = null)
    {
        $this->AccountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get DaysRemaining value
     * @return int
     */
    public function getDaysRemaining()
    {
        return $this->DaysRemaining;
    }
    /**
     * Set DaysRemaining value
     * @param int $daysRemaining
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setDaysRemaining($daysRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($daysRemaining) && !is_numeric($daysRemaining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysRemaining)), __LINE__);
        }
        $this->DaysRemaining = $daysRemaining;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get GatewayAccessLogId value
     * @return int
     */
    public function getGatewayAccessLogId()
    {
        return $this->GatewayAccessLogId;
    }
    /**
     * Set GatewayAccessLogId value
     * @param int $gatewayAccessLogId
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setGatewayAccessLogId($gatewayAccessLogId = null)
    {
        // validation for constraint: int
        if (!is_null($gatewayAccessLogId) && !is_numeric($gatewayAccessLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($gatewayAccessLogId)), __LINE__);
        }
        $this->GatewayAccessLogId = $gatewayAccessLogId;
        return $this;
    }
    /**
     * Get PaymentConfirmationNumber value
     * @return string|null
     */
    public function getPaymentConfirmationNumber()
    {
        return $this->PaymentConfirmationNumber;
    }
    /**
     * Set PaymentConfirmationNumber value
     * @param string $paymentConfirmationNumber
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setPaymentConfirmationNumber($paymentConfirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($paymentConfirmationNumber) && !is_string($paymentConfirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentConfirmationNumber)), __LINE__);
        }
        $this->PaymentConfirmationNumber = $paymentConfirmationNumber;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get PaymentVendorMessage value
     * @return string|null
     */
    public function getPaymentVendorMessage()
    {
        return $this->PaymentVendorMessage;
    }
    /**
     * Set PaymentVendorMessage value
     * @param string $paymentVendorMessage
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setPaymentVendorMessage($paymentVendorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($paymentVendorMessage) && !is_string($paymentVendorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentVendorMessage)), __LINE__);
        }
        $this->PaymentVendorMessage = $paymentVendorMessage;
        return $this;
    }
    /**
     * Get PaymentEvent value
     * @return \SGCIS\Struct\PaymentEvent|null
     */
    public function getPaymentEvent()
    {
        return $this->PaymentEvent;
    }
    /**
     * Set PaymentEvent value
     * @param \SGCIS\Struct\PaymentEvent $paymentEvent
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setPaymentEvent(\SGCIS\Struct\PaymentEvent $paymentEvent = null)
    {
        $this->PaymentEvent = $paymentEvent;
        return $this;
    }
    /**
     * Get PaymentReceipt value
     * @return string|null
     */
    public function getPaymentReceipt()
    {
        return $this->PaymentReceipt;
    }
    /**
     * Set PaymentReceipt value
     * @param string $paymentReceipt
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setPaymentReceipt($paymentReceipt = null)
    {
        // validation for constraint: string
        if (!is_null($paymentReceipt) && !is_string($paymentReceipt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentReceipt)), __LINE__);
        }
        $this->PaymentReceipt = $paymentReceipt;
        return $this;
    }
    /**
     * Get ReceiptName value
     * @return string|null
     */
    public function getReceiptName()
    {
        return $this->ReceiptName;
    }
    /**
     * Set ReceiptName value
     * @param string $receiptName
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setReceiptName($receiptName = null)
    {
        // validation for constraint: string
        if (!is_null($receiptName) && !is_string($receiptName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptName)), __LINE__);
        }
        $this->ReceiptName = $receiptName;
        return $this;
    }
    /**
     * Get ReceiptInformation value
     * @return string|null
     */
    public function getReceiptInformation()
    {
        return $this->ReceiptInformation;
    }
    /**
     * Set ReceiptInformation value
     * @param string $receiptInformation
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setReceiptInformation($receiptInformation = null)
    {
        // validation for constraint: string
        if (!is_null($receiptInformation) && !is_string($receiptInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptInformation)), __LINE__);
        }
        $this->ReceiptInformation = $receiptInformation;
        return $this;
    }
    /**
     * Get GateWayTransactionId value
     * @return string|null
     */
    public function getGateWayTransactionId()
    {
        return $this->GateWayTransactionId;
    }
    /**
     * Set GateWayTransactionId value
     * @param string $gateWayTransactionId
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public function setGateWayTransactionId($gateWayTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($gateWayTransactionId) && !is_string($gateWayTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gateWayTransactionId)), __LINE__);
        }
        $this->GateWayTransactionId = $gateWayTransactionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PostPaymentResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
