<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PostPaymentRequest Struct
 * @subpackage Structs
 */
class PostPaymentRequest extends ServiceRequestBase
{
    /**
     * The AccountID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountID;
    /**
     * The IsBrandedCardAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBrandedCardAccount;
    /**
     * The PaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PaymentAmount;
    /**
     * The DebtPaymentAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DebtPaymentAmount;
    /**
     * The TenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TenderTypeID;
    /**
     * The SystemEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemEventID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The PaymentSourceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentSourceID;
    /**
     * The AutoPaymentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AutoPaymentID;
    /**
     * The DaysRemaining
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DaysRemaining;
    /**
     * The SendNotification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $SendNotification;
    /**
     * The UsePaymentProfile
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UsePaymentProfile;
    /**
     * The PaymentEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventID;
    /**
     * The IsGridlinkPaymentSource
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsGridlinkPaymentSource;
    /**
     * The DuringEnrollment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DuringEnrollment;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The CardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardNumber;
    /**
     * The ExpireMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpireMonth;
    /**
     * The ExpireYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpireYear;
    /**
     * The CardZipCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CardZipCode;
    /**
     * The CCV
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CCV;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The Fees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountFee
     */
    public $Fees;
    /**
     * The WaivedFees
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfAccountFee
     */
    public $WaivedFees;
    /**
     * The IPAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IPAddress;
    /**
     * The CheckNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CheckNumber;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The RoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumber;
    /**
     * The BankAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankAccountType;
    /**
     * The BillingAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\AccountAddress
     */
    public $BillingAddress;
    /**
     * The ProfileIdentifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProfileIdentifier;
    /**
     * The PaymentToken
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentToken;
    /**
     * The I4GoCardType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $I4GoCardType;
    /**
     * The PaymentAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentAccount
     */
    public $PaymentAccount;
    /**
     * The PaymentVendorProcess
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\PaymentVendorProcess
     */
    public $PaymentVendorProcess;
    /**
     * Constructor method for PostPaymentRequest
     * @uses PostPaymentRequest::setAccountID()
     * @uses PostPaymentRequest::setIsBrandedCardAccount()
     * @uses PostPaymentRequest::setPaymentAmount()
     * @uses PostPaymentRequest::setDebtPaymentAmount()
     * @uses PostPaymentRequest::setTenderTypeID()
     * @uses PostPaymentRequest::setSystemEventID()
     * @uses PostPaymentRequest::setUserID()
     * @uses PostPaymentRequest::setPaymentSourceID()
     * @uses PostPaymentRequest::setAutoPaymentID()
     * @uses PostPaymentRequest::setDaysRemaining()
     * @uses PostPaymentRequest::setSendNotification()
     * @uses PostPaymentRequest::setUsePaymentProfile()
     * @uses PostPaymentRequest::setPaymentEventID()
     * @uses PostPaymentRequest::setIsGridlinkPaymentSource()
     * @uses PostPaymentRequest::setDuringEnrollment()
     * @uses PostPaymentRequest::setAccountNumber()
     * @uses PostPaymentRequest::setCardNumber()
     * @uses PostPaymentRequest::setExpireMonth()
     * @uses PostPaymentRequest::setExpireYear()
     * @uses PostPaymentRequest::setCardZipCode()
     * @uses PostPaymentRequest::setCCV()
     * @uses PostPaymentRequest::setUserName()
     * @uses PostPaymentRequest::setNotes()
     * @uses PostPaymentRequest::setReferenceNumber()
     * @uses PostPaymentRequest::setFees()
     * @uses PostPaymentRequest::setWaivedFees()
     * @uses PostPaymentRequest::setIPAddress()
     * @uses PostPaymentRequest::setCheckNumber()
     * @uses PostPaymentRequest::setNameOnAccount()
     * @uses PostPaymentRequest::setRoutingNumber()
     * @uses PostPaymentRequest::setBankAccountType()
     * @uses PostPaymentRequest::setBillingAddress()
     * @uses PostPaymentRequest::setProfileIdentifier()
     * @uses PostPaymentRequest::setPaymentToken()
     * @uses PostPaymentRequest::setI4GoCardType()
     * @uses PostPaymentRequest::setPaymentAccount()
     * @uses PostPaymentRequest::setPaymentVendorProcess()
     * @param int $accountID
     * @param bool $isBrandedCardAccount
     * @param float $paymentAmount
     * @param float $debtPaymentAmount
     * @param int $tenderTypeID
     * @param int $systemEventID
     * @param int $userID
     * @param int $paymentSourceID
     * @param int $autoPaymentID
     * @param int $daysRemaining
     * @param bool $sendNotification
     * @param bool $usePaymentProfile
     * @param int $paymentEventID
     * @param bool $isGridlinkPaymentSource
     * @param bool $duringEnrollment
     * @param string $accountNumber
     * @param string $cardNumber
     * @param string $expireMonth
     * @param string $expireYear
     * @param string $cardZipCode
     * @param string $cCV
     * @param string $userName
     * @param string $notes
     * @param string $referenceNumber
     * @param \SGCIS\Array\ArrayOfAccountFee $fees
     * @param \SGCIS\Array\ArrayOfAccountFee $waivedFees
     * @param string $iPAddress
     * @param string $checkNumber
     * @param string $nameOnAccount
     * @param string $routingNumber
     * @param string $bankAccountType
     * @param \SGCIS\Struct\AccountAddress $billingAddress
     * @param string $profileIdentifier
     * @param string $paymentToken
     * @param string $i4GoCardType
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @param \SGCIS\Struct\PaymentVendorProcess $paymentVendorProcess
     */
    public function __construct($accountID = null, $isBrandedCardAccount = null, $paymentAmount = null, $debtPaymentAmount = null, $tenderTypeID = null, $systemEventID = null, $userID = null, $paymentSourceID = null, $autoPaymentID = null, $daysRemaining = null, $sendNotification = null, $usePaymentProfile = null, $paymentEventID = null, $isGridlinkPaymentSource = null, $duringEnrollment = null, $accountNumber = null, $cardNumber = null, $expireMonth = null, $expireYear = null, $cardZipCode = null, $cCV = null, $userName = null, $notes = null, $referenceNumber = null, \SGCIS\Array\ArrayOfAccountFee $fees = null, \SGCIS\Array\ArrayOfAccountFee $waivedFees = null, $iPAddress = null, $checkNumber = null, $nameOnAccount = null, $routingNumber = null, $bankAccountType = null, \SGCIS\Struct\AccountAddress $billingAddress = null, $profileIdentifier = null, $paymentToken = null, $i4GoCardType = null, \SGCIS\Struct\PaymentAccount $paymentAccount = null, \SGCIS\Struct\PaymentVendorProcess $paymentVendorProcess = null)
    {
        $this
            ->setAccountID($accountID)
            ->setIsBrandedCardAccount($isBrandedCardAccount)
            ->setPaymentAmount($paymentAmount)
            ->setDebtPaymentAmount($debtPaymentAmount)
            ->setTenderTypeID($tenderTypeID)
            ->setSystemEventID($systemEventID)
            ->setUserID($userID)
            ->setPaymentSourceID($paymentSourceID)
            ->setAutoPaymentID($autoPaymentID)
            ->setDaysRemaining($daysRemaining)
            ->setSendNotification($sendNotification)
            ->setUsePaymentProfile($usePaymentProfile)
            ->setPaymentEventID($paymentEventID)
            ->setIsGridlinkPaymentSource($isGridlinkPaymentSource)
            ->setDuringEnrollment($duringEnrollment)
            ->setAccountNumber($accountNumber)
            ->setCardNumber($cardNumber)
            ->setExpireMonth($expireMonth)
            ->setExpireYear($expireYear)
            ->setCardZipCode($cardZipCode)
            ->setCCV($cCV)
            ->setUserName($userName)
            ->setNotes($notes)
            ->setReferenceNumber($referenceNumber)
            ->setFees($fees)
            ->setWaivedFees($waivedFees)
            ->setIPAddress($iPAddress)
            ->setCheckNumber($checkNumber)
            ->setNameOnAccount($nameOnAccount)
            ->setRoutingNumber($routingNumber)
            ->setBankAccountType($bankAccountType)
            ->setBillingAddress($billingAddress)
            ->setProfileIdentifier($profileIdentifier)
            ->setPaymentToken($paymentToken)
            ->setI4GoCardType($i4GoCardType)
            ->setPaymentAccount($paymentAccount)
            ->setPaymentVendorProcess($paymentVendorProcess);
    }
    /**
     * Get AccountID value
     * @return int
     */
    public function getAccountID()
    {
        return $this->AccountID;
    }
    /**
     * Set AccountID value
     * @param int $accountID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setAccountID($accountID = null)
    {
        // validation for constraint: int
        if (!is_null($accountID) && !is_numeric($accountID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountID)), __LINE__);
        }
        $this->AccountID = $accountID;
        return $this;
    }
    /**
     * Get IsBrandedCardAccount value
     * @return bool
     */
    public function getIsBrandedCardAccount()
    {
        return $this->IsBrandedCardAccount;
    }
    /**
     * Set IsBrandedCardAccount value
     * @param bool $isBrandedCardAccount
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setIsBrandedCardAccount($isBrandedCardAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBrandedCardAccount) && !is_bool($isBrandedCardAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBrandedCardAccount)), __LINE__);
        }
        $this->IsBrandedCardAccount = $isBrandedCardAccount;
        return $this;
    }
    /**
     * Get PaymentAmount value
     * @return float
     */
    public function getPaymentAmount()
    {
        return $this->PaymentAmount;
    }
    /**
     * Set PaymentAmount value
     * @param float $paymentAmount
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setPaymentAmount($paymentAmount = null)
    {
        $this->PaymentAmount = $paymentAmount;
        return $this;
    }
    /**
     * Get DebtPaymentAmount value
     * @return float
     */
    public function getDebtPaymentAmount()
    {
        return $this->DebtPaymentAmount;
    }
    /**
     * Set DebtPaymentAmount value
     * @param float $debtPaymentAmount
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setDebtPaymentAmount($debtPaymentAmount = null)
    {
        $this->DebtPaymentAmount = $debtPaymentAmount;
        return $this;
    }
    /**
     * Get TenderTypeID value
     * @return int
     */
    public function getTenderTypeID()
    {
        return $this->TenderTypeID;
    }
    /**
     * Set TenderTypeID value
     * @param int $tenderTypeID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setTenderTypeID($tenderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($tenderTypeID) && !is_numeric($tenderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tenderTypeID)), __LINE__);
        }
        $this->TenderTypeID = $tenderTypeID;
        return $this;
    }
    /**
     * Get SystemEventID value
     * @return int
     */
    public function getSystemEventID()
    {
        return $this->SystemEventID;
    }
    /**
     * Set SystemEventID value
     * @param int $systemEventID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setSystemEventID($systemEventID = null)
    {
        // validation for constraint: int
        if (!is_null($systemEventID) && !is_numeric($systemEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemEventID)), __LINE__);
        }
        $this->SystemEventID = $systemEventID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get PaymentSourceID value
     * @return int
     */
    public function getPaymentSourceID()
    {
        return $this->PaymentSourceID;
    }
    /**
     * Set PaymentSourceID value
     * @param int $paymentSourceID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setPaymentSourceID($paymentSourceID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentSourceID) && !is_numeric($paymentSourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentSourceID)), __LINE__);
        }
        $this->PaymentSourceID = $paymentSourceID;
        return $this;
    }
    /**
     * Get AutoPaymentID value
     * @return int
     */
    public function getAutoPaymentID()
    {
        return $this->AutoPaymentID;
    }
    /**
     * Set AutoPaymentID value
     * @param int $autoPaymentID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setAutoPaymentID($autoPaymentID = null)
    {
        // validation for constraint: int
        if (!is_null($autoPaymentID) && !is_numeric($autoPaymentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($autoPaymentID)), __LINE__);
        }
        $this->AutoPaymentID = $autoPaymentID;
        return $this;
    }
    /**
     * Get DaysRemaining value
     * @return int
     */
    public function getDaysRemaining()
    {
        return $this->DaysRemaining;
    }
    /**
     * Set DaysRemaining value
     * @param int $daysRemaining
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setDaysRemaining($daysRemaining = null)
    {
        // validation for constraint: int
        if (!is_null($daysRemaining) && !is_numeric($daysRemaining)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($daysRemaining)), __LINE__);
        }
        $this->DaysRemaining = $daysRemaining;
        return $this;
    }
    /**
     * Get SendNotification value
     * @return bool
     */
    public function getSendNotification()
    {
        return $this->SendNotification;
    }
    /**
     * Set SendNotification value
     * @param bool $sendNotification
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setSendNotification($sendNotification = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendNotification) && !is_bool($sendNotification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sendNotification)), __LINE__);
        }
        $this->SendNotification = $sendNotification;
        return $this;
    }
    /**
     * Get UsePaymentProfile value
     * @return bool
     */
    public function getUsePaymentProfile()
    {
        return $this->UsePaymentProfile;
    }
    /**
     * Set UsePaymentProfile value
     * @param bool $usePaymentProfile
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setUsePaymentProfile($usePaymentProfile = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePaymentProfile) && !is_bool($usePaymentProfile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($usePaymentProfile)), __LINE__);
        }
        $this->UsePaymentProfile = $usePaymentProfile;
        return $this;
    }
    /**
     * Get PaymentEventID value
     * @return int
     */
    public function getPaymentEventID()
    {
        return $this->PaymentEventID;
    }
    /**
     * Set PaymentEventID value
     * @param int $paymentEventID
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setPaymentEventID($paymentEventID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventID) && !is_numeric($paymentEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventID)), __LINE__);
        }
        $this->PaymentEventID = $paymentEventID;
        return $this;
    }
    /**
     * Get IsGridlinkPaymentSource value
     * @return bool
     */
    public function getIsGridlinkPaymentSource()
    {
        return $this->IsGridlinkPaymentSource;
    }
    /**
     * Set IsGridlinkPaymentSource value
     * @param bool $isGridlinkPaymentSource
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setIsGridlinkPaymentSource($isGridlinkPaymentSource = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGridlinkPaymentSource) && !is_bool($isGridlinkPaymentSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isGridlinkPaymentSource)), __LINE__);
        }
        $this->IsGridlinkPaymentSource = $isGridlinkPaymentSource;
        return $this;
    }
    /**
     * Get DuringEnrollment value
     * @return bool
     */
    public function getDuringEnrollment()
    {
        return $this->DuringEnrollment;
    }
    /**
     * Set DuringEnrollment value
     * @param bool $duringEnrollment
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setDuringEnrollment($duringEnrollment = null)
    {
        // validation for constraint: boolean
        if (!is_null($duringEnrollment) && !is_bool($duringEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($duringEnrollment)), __LINE__);
        }
        $this->DuringEnrollment = $duringEnrollment;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get CardNumber value
     * @return string|null
     */
    public function getCardNumber()
    {
        return $this->CardNumber;
    }
    /**
     * Set CardNumber value
     * @param string $cardNumber
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardNumber)), __LINE__);
        }
        $this->CardNumber = $cardNumber;
        return $this;
    }
    /**
     * Get ExpireMonth value
     * @return string|null
     */
    public function getExpireMonth()
    {
        return $this->ExpireMonth;
    }
    /**
     * Set ExpireMonth value
     * @param string $expireMonth
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setExpireMonth($expireMonth = null)
    {
        // validation for constraint: string
        if (!is_null($expireMonth) && !is_string($expireMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireMonth)), __LINE__);
        }
        $this->ExpireMonth = $expireMonth;
        return $this;
    }
    /**
     * Get ExpireYear value
     * @return string|null
     */
    public function getExpireYear()
    {
        return $this->ExpireYear;
    }
    /**
     * Set ExpireYear value
     * @param string $expireYear
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setExpireYear($expireYear = null)
    {
        // validation for constraint: string
        if (!is_null($expireYear) && !is_string($expireYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireYear)), __LINE__);
        }
        $this->ExpireYear = $expireYear;
        return $this;
    }
    /**
     * Get CardZipCode value
     * @return string|null
     */
    public function getCardZipCode()
    {
        return $this->CardZipCode;
    }
    /**
     * Set CardZipCode value
     * @param string $cardZipCode
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setCardZipCode($cardZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($cardZipCode) && !is_string($cardZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardZipCode)), __LINE__);
        }
        $this->CardZipCode = $cardZipCode;
        return $this;
    }
    /**
     * Get CCV value
     * @return string|null
     */
    public function getCCV()
    {
        return $this->CCV;
    }
    /**
     * Set CCV value
     * @param string $cCV
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setCCV($cCV = null)
    {
        // validation for constraint: string
        if (!is_null($cCV) && !is_string($cCV)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCV)), __LINE__);
        }
        $this->CCV = $cCV;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param string $referenceNumber
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get Fees value
     * @return \SGCIS\Array\ArrayOfAccountFee|null
     */
    public function getFees()
    {
        return $this->Fees;
    }
    /**
     * Set Fees value
     * @param \SGCIS\Array\ArrayOfAccountFee $fees
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setFees(\SGCIS\Array\ArrayOfAccountFee $fees = null)
    {
        $this->Fees = $fees;
        return $this;
    }
    /**
     * Get WaivedFees value
     * @return \SGCIS\Array\ArrayOfAccountFee|null
     */
    public function getWaivedFees()
    {
        return $this->WaivedFees;
    }
    /**
     * Set WaivedFees value
     * @param \SGCIS\Array\ArrayOfAccountFee $waivedFees
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setWaivedFees(\SGCIS\Array\ArrayOfAccountFee $waivedFees = null)
    {
        $this->WaivedFees = $waivedFees;
        return $this;
    }
    /**
     * Get IPAddress value
     * @return string|null
     */
    public function getIPAddress()
    {
        return $this->IPAddress;
    }
    /**
     * Set IPAddress value
     * @param string $iPAddress
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setIPAddress($iPAddress = null)
    {
        // validation for constraint: string
        if (!is_null($iPAddress) && !is_string($iPAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iPAddress)), __LINE__);
        }
        $this->IPAddress = $iPAddress;
        return $this;
    }
    /**
     * Get CheckNumber value
     * @return string|null
     */
    public function getCheckNumber()
    {
        return $this->CheckNumber;
    }
    /**
     * Set CheckNumber value
     * @param string $checkNumber
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setCheckNumber($checkNumber = null)
    {
        // validation for constraint: string
        if (!is_null($checkNumber) && !is_string($checkNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($checkNumber)), __LINE__);
        }
        $this->CheckNumber = $checkNumber;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return string|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param string $routingNumber
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumber) && !is_string($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Get BankAccountType value
     * @return string|null
     */
    public function getBankAccountType()
    {
        return $this->BankAccountType;
    }
    /**
     * Set BankAccountType value
     * @param string $bankAccountType
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setBankAccountType($bankAccountType = null)
    {
        // validation for constraint: string
        if (!is_null($bankAccountType) && !is_string($bankAccountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankAccountType)), __LINE__);
        }
        $this->BankAccountType = $bankAccountType;
        return $this;
    }
    /**
     * Get BillingAddress value
     * @return \SGCIS\Struct\AccountAddress|null
     */
    public function getBillingAddress()
    {
        return $this->BillingAddress;
    }
    /**
     * Set BillingAddress value
     * @param \SGCIS\Struct\AccountAddress $billingAddress
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setBillingAddress(\SGCIS\Struct\AccountAddress $billingAddress = null)
    {
        $this->BillingAddress = $billingAddress;
        return $this;
    }
    /**
     * Get ProfileIdentifier value
     * @return string|null
     */
    public function getProfileIdentifier()
    {
        return $this->ProfileIdentifier;
    }
    /**
     * Set ProfileIdentifier value
     * @param string $profileIdentifier
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setProfileIdentifier($profileIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($profileIdentifier) && !is_string($profileIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileIdentifier)), __LINE__);
        }
        $this->ProfileIdentifier = $profileIdentifier;
        return $this;
    }
    /**
     * Get PaymentToken value
     * @return string|null
     */
    public function getPaymentToken()
    {
        return $this->PaymentToken;
    }
    /**
     * Set PaymentToken value
     * @param string $paymentToken
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentToken)), __LINE__);
        }
        $this->PaymentToken = $paymentToken;
        return $this;
    }
    /**
     * Get I4GoCardType value
     * @return string|null
     */
    public function getI4GoCardType()
    {
        return $this->I4GoCardType;
    }
    /**
     * Set I4GoCardType value
     * @param string $i4GoCardType
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setI4GoCardType($i4GoCardType = null)
    {
        // validation for constraint: string
        if (!is_null($i4GoCardType) && !is_string($i4GoCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($i4GoCardType)), __LINE__);
        }
        $this->I4GoCardType = $i4GoCardType;
        return $this;
    }
    /**
     * Get PaymentAccount value
     * @return \SGCIS\Struct\PaymentAccount|null
     */
    public function getPaymentAccount()
    {
        return $this->PaymentAccount;
    }
    /**
     * Set PaymentAccount value
     * @param \SGCIS\Struct\PaymentAccount $paymentAccount
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setPaymentAccount(\SGCIS\Struct\PaymentAccount $paymentAccount = null)
    {
        $this->PaymentAccount = $paymentAccount;
        return $this;
    }
    /**
     * Get PaymentVendorProcess value
     * @return \SGCIS\Struct\PaymentVendorProcess|null
     */
    public function getPaymentVendorProcess()
    {
        return $this->PaymentVendorProcess;
    }
    /**
     * Set PaymentVendorProcess value
     * @param \SGCIS\Struct\PaymentVendorProcess $paymentVendorProcess
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public function setPaymentVendorProcess(\SGCIS\Struct\PaymentVendorProcess $paymentVendorProcess = null)
    {
        $this->PaymentVendorProcess = $paymentVendorProcess;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PostPaymentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
