<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentTender Struct
 * @subpackage Structs
 */
class PaymentTender extends AbstractStructBase
{
    /**
     * The PaymentTenderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTenderID;
    /**
     * The PaymentEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentEventID;
    /**
     * The PaymentTenderTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTenderTypeID;
    /**
     * The PaymentTenderStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentTenderStatusID;
    /**
     * The TenderAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TenderAmount;
    /**
     * The CardTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CardTypeID;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The AuthorizationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AuthorizationNumber;
    /**
     * The TransactionID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionID;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The CCVCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CCVCode;
    /**
     * The ExpireMonth
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpireMonth;
    /**
     * The ExpireYear
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpireYear;
    /**
     * The AccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountType;
    /**
     * The NameOnAccount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NameOnAccount;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The RoutingNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoutingNumber;
    /**
     * Constructor method for PaymentTender
     * @uses PaymentTender::setPaymentTenderID()
     * @uses PaymentTender::setPaymentEventID()
     * @uses PaymentTender::setPaymentTenderTypeID()
     * @uses PaymentTender::setPaymentTenderStatusID()
     * @uses PaymentTender::setTenderAmount()
     * @uses PaymentTender::setCardTypeID()
     * @uses PaymentTender::setAccountNumber()
     * @uses PaymentTender::setAuthorizationNumber()
     * @uses PaymentTender::setTransactionID()
     * @uses PaymentTender::setNotes()
     * @uses PaymentTender::setCCVCode()
     * @uses PaymentTender::setExpireMonth()
     * @uses PaymentTender::setExpireYear()
     * @uses PaymentTender::setAccountType()
     * @uses PaymentTender::setNameOnAccount()
     * @uses PaymentTender::setBankName()
     * @uses PaymentTender::setRoutingNumber()
     * @param int $paymentTenderID
     * @param int $paymentEventID
     * @param int $paymentTenderTypeID
     * @param int $paymentTenderStatusID
     * @param float $tenderAmount
     * @param int $cardTypeID
     * @param string $accountNumber
     * @param string $authorizationNumber
     * @param string $transactionID
     * @param string $notes
     * @param string $cCVCode
     * @param string $expireMonth
     * @param string $expireYear
     * @param string $accountType
     * @param string $nameOnAccount
     * @param string $bankName
     * @param string $routingNumber
     */
    public function __construct($paymentTenderID = null, $paymentEventID = null, $paymentTenderTypeID = null, $paymentTenderStatusID = null, $tenderAmount = null, $cardTypeID = null, $accountNumber = null, $authorizationNumber = null, $transactionID = null, $notes = null, $cCVCode = null, $expireMonth = null, $expireYear = null, $accountType = null, $nameOnAccount = null, $bankName = null, $routingNumber = null)
    {
        $this
            ->setPaymentTenderID($paymentTenderID)
            ->setPaymentEventID($paymentEventID)
            ->setPaymentTenderTypeID($paymentTenderTypeID)
            ->setPaymentTenderStatusID($paymentTenderStatusID)
            ->setTenderAmount($tenderAmount)
            ->setCardTypeID($cardTypeID)
            ->setAccountNumber($accountNumber)
            ->setAuthorizationNumber($authorizationNumber)
            ->setTransactionID($transactionID)
            ->setNotes($notes)
            ->setCCVCode($cCVCode)
            ->setExpireMonth($expireMonth)
            ->setExpireYear($expireYear)
            ->setAccountType($accountType)
            ->setNameOnAccount($nameOnAccount)
            ->setBankName($bankName)
            ->setRoutingNumber($routingNumber);
    }
    /**
     * Get PaymentTenderID value
     * @return int
     */
    public function getPaymentTenderID()
    {
        return $this->PaymentTenderID;
    }
    /**
     * Set PaymentTenderID value
     * @param int $paymentTenderID
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setPaymentTenderID($paymentTenderID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTenderID) && !is_numeric($paymentTenderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTenderID)), __LINE__);
        }
        $this->PaymentTenderID = $paymentTenderID;
        return $this;
    }
    /**
     * Get PaymentEventID value
     * @return int
     */
    public function getPaymentEventID()
    {
        return $this->PaymentEventID;
    }
    /**
     * Set PaymentEventID value
     * @param int $paymentEventID
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setPaymentEventID($paymentEventID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentEventID) && !is_numeric($paymentEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentEventID)), __LINE__);
        }
        $this->PaymentEventID = $paymentEventID;
        return $this;
    }
    /**
     * Get PaymentTenderTypeID value
     * @return int
     */
    public function getPaymentTenderTypeID()
    {
        return $this->PaymentTenderTypeID;
    }
    /**
     * Set PaymentTenderTypeID value
     * @param int $paymentTenderTypeID
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setPaymentTenderTypeID($paymentTenderTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTenderTypeID) && !is_numeric($paymentTenderTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTenderTypeID)), __LINE__);
        }
        $this->PaymentTenderTypeID = $paymentTenderTypeID;
        return $this;
    }
    /**
     * Get PaymentTenderStatusID value
     * @return int
     */
    public function getPaymentTenderStatusID()
    {
        return $this->PaymentTenderStatusID;
    }
    /**
     * Set PaymentTenderStatusID value
     * @param int $paymentTenderStatusID
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setPaymentTenderStatusID($paymentTenderStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentTenderStatusID) && !is_numeric($paymentTenderStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentTenderStatusID)), __LINE__);
        }
        $this->PaymentTenderStatusID = $paymentTenderStatusID;
        return $this;
    }
    /**
     * Get TenderAmount value
     * @return float
     */
    public function getTenderAmount()
    {
        return $this->TenderAmount;
    }
    /**
     * Set TenderAmount value
     * @param float $tenderAmount
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setTenderAmount($tenderAmount = null)
    {
        $this->TenderAmount = $tenderAmount;
        return $this;
    }
    /**
     * Get CardTypeID value
     * @return int
     */
    public function getCardTypeID()
    {
        return $this->CardTypeID;
    }
    /**
     * Set CardTypeID value
     * @param int $cardTypeID
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setCardTypeID($cardTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($cardTypeID) && !is_numeric($cardTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($cardTypeID)), __LINE__);
        }
        $this->CardTypeID = $cardTypeID;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get AuthorizationNumber value
     * @return string|null
     */
    public function getAuthorizationNumber()
    {
        return $this->AuthorizationNumber;
    }
    /**
     * Set AuthorizationNumber value
     * @param string $authorizationNumber
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setAuthorizationNumber($authorizationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationNumber) && !is_string($authorizationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authorizationNumber)), __LINE__);
        }
        $this->AuthorizationNumber = $authorizationNumber;
        return $this;
    }
    /**
     * Get TransactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->TransactionID;
    }
    /**
     * Set TransactionID value
     * @param string $transactionID
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionID)), __LINE__);
        }
        $this->TransactionID = $transactionID;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get CCVCode value
     * @return string|null
     */
    public function getCCVCode()
    {
        return $this->CCVCode;
    }
    /**
     * Set CCVCode value
     * @param string $cCVCode
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setCCVCode($cCVCode = null)
    {
        // validation for constraint: string
        if (!is_null($cCVCode) && !is_string($cCVCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCVCode)), __LINE__);
        }
        $this->CCVCode = $cCVCode;
        return $this;
    }
    /**
     * Get ExpireMonth value
     * @return string|null
     */
    public function getExpireMonth()
    {
        return $this->ExpireMonth;
    }
    /**
     * Set ExpireMonth value
     * @param string $expireMonth
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setExpireMonth($expireMonth = null)
    {
        // validation for constraint: string
        if (!is_null($expireMonth) && !is_string($expireMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireMonth)), __LINE__);
        }
        $this->ExpireMonth = $expireMonth;
        return $this;
    }
    /**
     * Get ExpireYear value
     * @return string|null
     */
    public function getExpireYear()
    {
        return $this->ExpireYear;
    }
    /**
     * Set ExpireYear value
     * @param string $expireYear
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setExpireYear($expireYear = null)
    {
        // validation for constraint: string
        if (!is_null($expireYear) && !is_string($expireYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expireYear)), __LINE__);
        }
        $this->ExpireYear = $expireYear;
        return $this;
    }
    /**
     * Get AccountType value
     * @return string|null
     */
    public function getAccountType()
    {
        return $this->AccountType;
    }
    /**
     * Set AccountType value
     * @param string $accountType
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setAccountType($accountType = null)
    {
        // validation for constraint: string
        if (!is_null($accountType) && !is_string($accountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountType)), __LINE__);
        }
        $this->AccountType = $accountType;
        return $this;
    }
    /**
     * Get NameOnAccount value
     * @return string|null
     */
    public function getNameOnAccount()
    {
        return $this->NameOnAccount;
    }
    /**
     * Set NameOnAccount value
     * @param string $nameOnAccount
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setNameOnAccount($nameOnAccount = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnAccount) && !is_string($nameOnAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nameOnAccount)), __LINE__);
        }
        $this->NameOnAccount = $nameOnAccount;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get RoutingNumber value
     * @return string|null
     */
    public function getRoutingNumber()
    {
        return $this->RoutingNumber;
    }
    /**
     * Set RoutingNumber value
     * @param string $routingNumber
     * @return \SGCIS\Struct\PaymentTender
     */
    public function setRoutingNumber($routingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($routingNumber) && !is_string($routingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($routingNumber)), __LINE__);
        }
        $this->RoutingNumber = $routingNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentTender
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
