<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentLocationQuery Struct
 * @subpackage Structs
 */
class PaymentLocationQuery extends AbstractStructBase
{
    /**
     * The PaymentLocationTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaymentLocationTypeID;
    /**
     * The Radius
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Radius;
    /**
     * The StoreName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StoreName;
    /**
     * The StreetAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StreetAddress;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $City;
    /**
     * The State
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $State;
    /**
     * The Zip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Zip;
    /**
     * The Phone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Phone;
    /**
     * The CenterPoint
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Point
     */
    public $CenterPoint;
    /**
     * The searchParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfString
     */
    public $searchParameters;
    /**
     * Constructor method for PaymentLocationQuery
     * @uses PaymentLocationQuery::setPaymentLocationTypeID()
     * @uses PaymentLocationQuery::setRadius()
     * @uses PaymentLocationQuery::setStoreName()
     * @uses PaymentLocationQuery::setStreetAddress()
     * @uses PaymentLocationQuery::setCity()
     * @uses PaymentLocationQuery::setState()
     * @uses PaymentLocationQuery::setZip()
     * @uses PaymentLocationQuery::setPhone()
     * @uses PaymentLocationQuery::setCenterPoint()
     * @uses PaymentLocationQuery::setSearchParameters()
     * @param int $paymentLocationTypeID
     * @param int $radius
     * @param string $storeName
     * @param string $streetAddress
     * @param string $city
     * @param string $state
     * @param string $zip
     * @param string $phone
     * @param \SGCIS\Struct\Point $centerPoint
     * @param \SGCIS\Array\ArrayOfString $searchParameters
     */
    public function __construct($paymentLocationTypeID = null, $radius = null, $storeName = null, $streetAddress = null, $city = null, $state = null, $zip = null, $phone = null, \SGCIS\Struct\Point $centerPoint = null, \SGCIS\Array\ArrayOfString $searchParameters = null)
    {
        $this
            ->setPaymentLocationTypeID($paymentLocationTypeID)
            ->setRadius($radius)
            ->setStoreName($storeName)
            ->setStreetAddress($streetAddress)
            ->setCity($city)
            ->setState($state)
            ->setZip($zip)
            ->setPhone($phone)
            ->setCenterPoint($centerPoint)
            ->setSearchParameters($searchParameters);
    }
    /**
     * Get PaymentLocationTypeID value
     * @return int
     */
    public function getPaymentLocationTypeID()
    {
        return $this->PaymentLocationTypeID;
    }
    /**
     * Set PaymentLocationTypeID value
     * @param int $paymentLocationTypeID
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setPaymentLocationTypeID($paymentLocationTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($paymentLocationTypeID) && !is_numeric($paymentLocationTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentLocationTypeID)), __LINE__);
        }
        $this->PaymentLocationTypeID = $paymentLocationTypeID;
        return $this;
    }
    /**
     * Get Radius value
     * @return int
     */
    public function getRadius()
    {
        return $this->Radius;
    }
    /**
     * Set Radius value
     * @param int $radius
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setRadius($radius = null)
    {
        // validation for constraint: int
        if (!is_null($radius) && !is_numeric($radius)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($radius)), __LINE__);
        }
        $this->Radius = $radius;
        return $this;
    }
    /**
     * Get StoreName value
     * @return string|null
     */
    public function getStoreName()
    {
        return $this->StoreName;
    }
    /**
     * Set StoreName value
     * @param string $storeName
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setStoreName($storeName = null)
    {
        // validation for constraint: string
        if (!is_null($storeName) && !is_string($storeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($storeName)), __LINE__);
        }
        $this->StoreName = $storeName;
        return $this;
    }
    /**
     * Get StreetAddress value
     * @return string|null
     */
    public function getStreetAddress()
    {
        return $this->StreetAddress;
    }
    /**
     * Set StreetAddress value
     * @param string $streetAddress
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setStreetAddress($streetAddress = null)
    {
        // validation for constraint: string
        if (!is_null($streetAddress) && !is_string($streetAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($streetAddress)), __LINE__);
        }
        $this->StreetAddress = $streetAddress;
        return $this;
    }
    /**
     * Get City value
     * @return string|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param string $city
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setCity($city = null)
    {
        // validation for constraint: string
        if (!is_null($city) && !is_string($city)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($city)), __LINE__);
        }
        $this->City = $city;
        return $this;
    }
    /**
     * Get State value
     * @return string|null
     */
    public function getState()
    {
        return $this->State;
    }
    /**
     * Set State value
     * @param string $state
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setState($state = null)
    {
        // validation for constraint: string
        if (!is_null($state) && !is_string($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($state)), __LINE__);
        }
        $this->State = $state;
        return $this;
    }
    /**
     * Get Zip value
     * @return string|null
     */
    public function getZip()
    {
        return $this->Zip;
    }
    /**
     * Set Zip value
     * @param string $zip
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setZip($zip = null)
    {
        // validation for constraint: string
        if (!is_null($zip) && !is_string($zip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($zip)), __LINE__);
        }
        $this->Zip = $zip;
        return $this;
    }
    /**
     * Get Phone value
     * @return string|null
     */
    public function getPhone()
    {
        return $this->Phone;
    }
    /**
     * Set Phone value
     * @param string $phone
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setPhone($phone = null)
    {
        // validation for constraint: string
        if (!is_null($phone) && !is_string($phone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($phone)), __LINE__);
        }
        $this->Phone = $phone;
        return $this;
    }
    /**
     * Get CenterPoint value
     * @return \SGCIS\Struct\Point|null
     */
    public function getCenterPoint()
    {
        return $this->CenterPoint;
    }
    /**
     * Set CenterPoint value
     * @param \SGCIS\Struct\Point $centerPoint
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setCenterPoint(\SGCIS\Struct\Point $centerPoint = null)
    {
        $this->CenterPoint = $centerPoint;
        return $this;
    }
    /**
     * Get searchParameters value
     * @return \SGCIS\Array\ArrayOfString|null
     */
    public function getSearchParameters()
    {
        return $this->searchParameters;
    }
    /**
     * Set searchParameters value
     * @param \SGCIS\Array\ArrayOfString $searchParameters
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public function setSearchParameters(\SGCIS\Array\ArrayOfString $searchParameters = null)
    {
        $this->searchParameters = $searchParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\PaymentLocationQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
