<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterRequest Struct
 * @subpackage Structs
 */
class MeterRequest extends ServiceRequestBase
{
    /**
     * The MeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterID;
    /**
     * The ServicePointMeterID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServicePointMeterID;
    /**
     * The AccountServiceID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AccountServiceID;
    /**
     * The UserID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UserID;
    /**
     * The Query
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\MeterQuery
     */
    public $Query;
    /**
     * The Meter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\Meter
     */
    public $Meter;
    /**
     * The ServicePointMeter
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServicePointMeter
     */
    public $ServicePointMeter;
    /**
     * The MeterGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\MeterGroup
     */
    public $MeterGroup;
    /**
     * The MeterIDs
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $MeterIDs;
    /**
     * Constructor method for MeterRequest
     * @uses MeterRequest::setMeterID()
     * @uses MeterRequest::setServicePointMeterID()
     * @uses MeterRequest::setAccountServiceID()
     * @uses MeterRequest::setUserID()
     * @uses MeterRequest::setQuery()
     * @uses MeterRequest::setMeter()
     * @uses MeterRequest::setServicePointMeter()
     * @uses MeterRequest::setMeterGroup()
     * @uses MeterRequest::setMeterIDs()
     * @param int $meterID
     * @param int $servicePointMeterID
     * @param int $accountServiceID
     * @param int $userID
     * @param \SGCIS\Struct\MeterQuery $query
     * @param \SGCIS\Struct\Meter $meter
     * @param \SGCIS\Struct\ServicePointMeter $servicePointMeter
     * @param \SGCIS\Struct\MeterGroup $meterGroup
     * @param \SGCIS\Array\ArrayOfInt $meterIDs
     */
    public function __construct($meterID = null, $servicePointMeterID = null, $accountServiceID = null, $userID = null, \SGCIS\Struct\MeterQuery $query = null, \SGCIS\Struct\Meter $meter = null, \SGCIS\Struct\ServicePointMeter $servicePointMeter = null, \SGCIS\Struct\MeterGroup $meterGroup = null, \SGCIS\Array\ArrayOfInt $meterIDs = null)
    {
        $this
            ->setMeterID($meterID)
            ->setServicePointMeterID($servicePointMeterID)
            ->setAccountServiceID($accountServiceID)
            ->setUserID($userID)
            ->setQuery($query)
            ->setMeter($meter)
            ->setServicePointMeter($servicePointMeter)
            ->setMeterGroup($meterGroup)
            ->setMeterIDs($meterIDs);
    }
    /**
     * Get MeterID value
     * @return int
     */
    public function getMeterID()
    {
        return $this->MeterID;
    }
    /**
     * Set MeterID value
     * @param int $meterID
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setMeterID($meterID = null)
    {
        // validation for constraint: int
        if (!is_null($meterID) && !is_numeric($meterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterID)), __LINE__);
        }
        $this->MeterID = $meterID;
        return $this;
    }
    /**
     * Get ServicePointMeterID value
     * @return int
     */
    public function getServicePointMeterID()
    {
        return $this->ServicePointMeterID;
    }
    /**
     * Set ServicePointMeterID value
     * @param int $servicePointMeterID
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setServicePointMeterID($servicePointMeterID = null)
    {
        // validation for constraint: int
        if (!is_null($servicePointMeterID) && !is_numeric($servicePointMeterID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($servicePointMeterID)), __LINE__);
        }
        $this->ServicePointMeterID = $servicePointMeterID;
        return $this;
    }
    /**
     * Get AccountServiceID value
     * @return int
     */
    public function getAccountServiceID()
    {
        return $this->AccountServiceID;
    }
    /**
     * Set AccountServiceID value
     * @param int $accountServiceID
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setAccountServiceID($accountServiceID = null)
    {
        // validation for constraint: int
        if (!is_null($accountServiceID) && !is_numeric($accountServiceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($accountServiceID)), __LINE__);
        }
        $this->AccountServiceID = $accountServiceID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !is_numeric($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Query value
     * @return \SGCIS\Struct\MeterQuery|null
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @param \SGCIS\Struct\MeterQuery $query
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setQuery(\SGCIS\Struct\MeterQuery $query = null)
    {
        $this->Query = $query;
        return $this;
    }
    /**
     * Get Meter value
     * @return \SGCIS\Struct\Meter|null
     */
    public function getMeter()
    {
        return $this->Meter;
    }
    /**
     * Set Meter value
     * @param \SGCIS\Struct\Meter $meter
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setMeter(\SGCIS\Struct\Meter $meter = null)
    {
        $this->Meter = $meter;
        return $this;
    }
    /**
     * Get ServicePointMeter value
     * @return \SGCIS\Struct\ServicePointMeter|null
     */
    public function getServicePointMeter()
    {
        return $this->ServicePointMeter;
    }
    /**
     * Set ServicePointMeter value
     * @param \SGCIS\Struct\ServicePointMeter $servicePointMeter
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setServicePointMeter(\SGCIS\Struct\ServicePointMeter $servicePointMeter = null)
    {
        $this->ServicePointMeter = $servicePointMeter;
        return $this;
    }
    /**
     * Get MeterGroup value
     * @return \SGCIS\Struct\MeterGroup|null
     */
    public function getMeterGroup()
    {
        return $this->MeterGroup;
    }
    /**
     * Set MeterGroup value
     * @param \SGCIS\Struct\MeterGroup $meterGroup
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setMeterGroup(\SGCIS\Struct\MeterGroup $meterGroup = null)
    {
        $this->MeterGroup = $meterGroup;
        return $this;
    }
    /**
     * Get MeterIDs value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getMeterIDs()
    {
        return $this->MeterIDs;
    }
    /**
     * Set MeterIDs value
     * @param \SGCIS\Array\ArrayOfInt $meterIDs
     * @return \SGCIS\Struct\MeterRequest
     */
    public function setMeterIDs(\SGCIS\Array\ArrayOfInt $meterIDs = null)
    {
        $this->MeterIDs = $meterIDs;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
