<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterReadRatingComponent Struct
 * @subpackage Structs
 */
class MeterReadRatingComponent extends AbstractStructBase
{
    /**
     * The MeterReadRatingComponentID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadRatingComponentID;
    /**
     * The MeterReadID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterReadID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The ChargeGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeGroupID;
    /**
     * The RateValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $RateValue;
    /**
     * The ChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeAmount;
    /**
     * The ConsumptionValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ConsumptionValue;
    /**
     * The BillValue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BillValue;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The IsNetMeteringComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsNetMeteringComponent;
    /**
     * The ServiceAgreementID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ServiceAgreementID;
    /**
     * The RateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RateName;
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The ChargeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeName;
    /**
     * The ChargeGroupName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeGroupName;
    /**
     * The RatingComponentDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMeterReadRatingComponentDetail
     */
    public $RatingComponentDetails;
    /**
     * Constructor method for MeterReadRatingComponent
     * @uses MeterReadRatingComponent::setMeterReadRatingComponentID()
     * @uses MeterReadRatingComponent::setMeterReadID()
     * @uses MeterReadRatingComponent::setRateID()
     * @uses MeterReadRatingComponent::setChargeID()
     * @uses MeterReadRatingComponent::setChargeGroupID()
     * @uses MeterReadRatingComponent::setRateValue()
     * @uses MeterReadRatingComponent::setChargeAmount()
     * @uses MeterReadRatingComponent::setConsumptionValue()
     * @uses MeterReadRatingComponent::setBillValue()
     * @uses MeterReadRatingComponent::setCreateDate()
     * @uses MeterReadRatingComponent::setIsNetMeteringComponent()
     * @uses MeterReadRatingComponent::setServiceAgreementID()
     * @uses MeterReadRatingComponent::setRateName()
     * @uses MeterReadRatingComponent::setChargeCode()
     * @uses MeterReadRatingComponent::setChargeName()
     * @uses MeterReadRatingComponent::setChargeGroupName()
     * @uses MeterReadRatingComponent::setRatingComponentDetails()
     * @param int $meterReadRatingComponentID
     * @param int $meterReadID
     * @param int $rateID
     * @param int $chargeID
     * @param int $chargeGroupID
     * @param float $rateValue
     * @param float $chargeAmount
     * @param float $consumptionValue
     * @param float $billValue
     * @param string $createDate
     * @param bool $isNetMeteringComponent
     * @param int $serviceAgreementID
     * @param string $rateName
     * @param string $chargeCode
     * @param string $chargeName
     * @param string $chargeGroupName
     * @param \SGCIS\Array\ArrayOfMeterReadRatingComponentDetail $ratingComponentDetails
     */
    public function __construct($meterReadRatingComponentID = null, $meterReadID = null, $rateID = null, $chargeID = null, $chargeGroupID = null, $rateValue = null, $chargeAmount = null, $consumptionValue = null, $billValue = null, $createDate = null, $isNetMeteringComponent = null, $serviceAgreementID = null, $rateName = null, $chargeCode = null, $chargeName = null, $chargeGroupName = null, \SGCIS\Array\ArrayOfMeterReadRatingComponentDetail $ratingComponentDetails = null)
    {
        $this
            ->setMeterReadRatingComponentID($meterReadRatingComponentID)
            ->setMeterReadID($meterReadID)
            ->setRateID($rateID)
            ->setChargeID($chargeID)
            ->setChargeGroupID($chargeGroupID)
            ->setRateValue($rateValue)
            ->setChargeAmount($chargeAmount)
            ->setConsumptionValue($consumptionValue)
            ->setBillValue($billValue)
            ->setCreateDate($createDate)
            ->setIsNetMeteringComponent($isNetMeteringComponent)
            ->setServiceAgreementID($serviceAgreementID)
            ->setRateName($rateName)
            ->setChargeCode($chargeCode)
            ->setChargeName($chargeName)
            ->setChargeGroupName($chargeGroupName)
            ->setRatingComponentDetails($ratingComponentDetails);
    }
    /**
     * Get MeterReadRatingComponentID value
     * @return int
     */
    public function getMeterReadRatingComponentID()
    {
        return $this->MeterReadRatingComponentID;
    }
    /**
     * Set MeterReadRatingComponentID value
     * @param int $meterReadRatingComponentID
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setMeterReadRatingComponentID($meterReadRatingComponentID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadRatingComponentID) && !is_numeric($meterReadRatingComponentID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadRatingComponentID)), __LINE__);
        }
        $this->MeterReadRatingComponentID = $meterReadRatingComponentID;
        return $this;
    }
    /**
     * Get MeterReadID value
     * @return int
     */
    public function getMeterReadID()
    {
        return $this->MeterReadID;
    }
    /**
     * Set MeterReadID value
     * @param int $meterReadID
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setMeterReadID($meterReadID = null)
    {
        // validation for constraint: int
        if (!is_null($meterReadID) && !is_numeric($meterReadID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterReadID)), __LINE__);
        }
        $this->MeterReadID = $meterReadID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get ChargeGroupID value
     * @return int
     */
    public function getChargeGroupID()
    {
        return $this->ChargeGroupID;
    }
    /**
     * Set ChargeGroupID value
     * @param int $chargeGroupID
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setChargeGroupID($chargeGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeGroupID) && !is_numeric($chargeGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeGroupID)), __LINE__);
        }
        $this->ChargeGroupID = $chargeGroupID;
        return $this;
    }
    /**
     * Get RateValue value
     * @return float
     */
    public function getRateValue()
    {
        return $this->RateValue;
    }
    /**
     * Set RateValue value
     * @param float $rateValue
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setRateValue($rateValue = null)
    {
        $this->RateValue = $rateValue;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get ConsumptionValue value
     * @return float
     */
    public function getConsumptionValue()
    {
        return $this->ConsumptionValue;
    }
    /**
     * Set ConsumptionValue value
     * @param float $consumptionValue
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setConsumptionValue($consumptionValue = null)
    {
        $this->ConsumptionValue = $consumptionValue;
        return $this;
    }
    /**
     * Get BillValue value
     * @return float
     */
    public function getBillValue()
    {
        return $this->BillValue;
    }
    /**
     * Set BillValue value
     * @param float $billValue
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setBillValue($billValue = null)
    {
        $this->BillValue = $billValue;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get IsNetMeteringComponent value
     * @return bool
     */
    public function getIsNetMeteringComponent()
    {
        return $this->IsNetMeteringComponent;
    }
    /**
     * Set IsNetMeteringComponent value
     * @param bool $isNetMeteringComponent
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setIsNetMeteringComponent($isNetMeteringComponent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNetMeteringComponent) && !is_bool($isNetMeteringComponent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isNetMeteringComponent)), __LINE__);
        }
        $this->IsNetMeteringComponent = $isNetMeteringComponent;
        return $this;
    }
    /**
     * Get ServiceAgreementID value
     * @return int
     */
    public function getServiceAgreementID()
    {
        return $this->ServiceAgreementID;
    }
    /**
     * Set ServiceAgreementID value
     * @param int $serviceAgreementID
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setServiceAgreementID($serviceAgreementID = null)
    {
        // validation for constraint: int
        if (!is_null($serviceAgreementID) && !is_numeric($serviceAgreementID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($serviceAgreementID)), __LINE__);
        }
        $this->ServiceAgreementID = $serviceAgreementID;
        return $this;
    }
    /**
     * Get RateName value
     * @return string|null
     */
    public function getRateName()
    {
        return $this->RateName;
    }
    /**
     * Set RateName value
     * @param string $rateName
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setRateName($rateName = null)
    {
        // validation for constraint: string
        if (!is_null($rateName) && !is_string($rateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rateName)), __LINE__);
        }
        $this->RateName = $rateName;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get ChargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->ChargeName;
    }
    /**
     * Set ChargeName value
     * @param string $chargeName
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeName)), __LINE__);
        }
        $this->ChargeName = $chargeName;
        return $this;
    }
    /**
     * Get ChargeGroupName value
     * @return string|null
     */
    public function getChargeGroupName()
    {
        return $this->ChargeGroupName;
    }
    /**
     * Set ChargeGroupName value
     * @param string $chargeGroupName
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setChargeGroupName($chargeGroupName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeGroupName) && !is_string($chargeGroupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeGroupName)), __LINE__);
        }
        $this->ChargeGroupName = $chargeGroupName;
        return $this;
    }
    /**
     * Get RatingComponentDetails value
     * @return \SGCIS\Array\ArrayOfMeterReadRatingComponentDetail|null
     */
    public function getRatingComponentDetails()
    {
        return $this->RatingComponentDetails;
    }
    /**
     * Set RatingComponentDetails value
     * @param \SGCIS\Array\ArrayOfMeterReadRatingComponentDetail $ratingComponentDetails
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public function setRatingComponentDetails(\SGCIS\Array\ArrayOfMeterReadRatingComponentDetail $ratingComponentDetails = null)
    {
        $this->RatingComponentDetails = $ratingComponentDetails;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterReadRatingComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
