<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterQuery Struct
 * @subpackage Structs
 */
class MeterQuery extends AbstractStructBase
{
    /**
     * The MeterTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterTypeID;
    /**
     * The MeterInventoryStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterInventoryStatusID;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The InstallDate1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallDate1;
    /**
     * The InstallDate2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InstallDate2;
    /**
     * The MeterStatusID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterStatusID;
    /**
     * The MeterGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MeterGroupID;
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SerialNumber;
    /**
     * The searchParameters
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfString
     */
    public $searchParameters;
    /**
     * Constructor method for MeterQuery
     * @uses MeterQuery::setMeterTypeID()
     * @uses MeterQuery::setMeterInventoryStatusID()
     * @uses MeterQuery::setDistributionServiceProviderID()
     * @uses MeterQuery::setInstallDate1()
     * @uses MeterQuery::setInstallDate2()
     * @uses MeterQuery::setMeterStatusID()
     * @uses MeterQuery::setMeterGroupID()
     * @uses MeterQuery::setSerialNumber()
     * @uses MeterQuery::setSearchParameters()
     * @param int $meterTypeID
     * @param int $meterInventoryStatusID
     * @param int $distributionServiceProviderID
     * @param string $installDate1
     * @param string $installDate2
     * @param int $meterStatusID
     * @param int $meterGroupID
     * @param string $serialNumber
     * @param \SGCIS\Array\ArrayOfString $searchParameters
     */
    public function __construct($meterTypeID = null, $meterInventoryStatusID = null, $distributionServiceProviderID = null, $installDate1 = null, $installDate2 = null, $meterStatusID = null, $meterGroupID = null, $serialNumber = null, \SGCIS\Array\ArrayOfString $searchParameters = null)
    {
        $this
            ->setMeterTypeID($meterTypeID)
            ->setMeterInventoryStatusID($meterInventoryStatusID)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setInstallDate1($installDate1)
            ->setInstallDate2($installDate2)
            ->setMeterStatusID($meterStatusID)
            ->setMeterGroupID($meterGroupID)
            ->setSerialNumber($serialNumber)
            ->setSearchParameters($searchParameters);
    }
    /**
     * Get MeterTypeID value
     * @return int
     */
    public function getMeterTypeID()
    {
        return $this->MeterTypeID;
    }
    /**
     * Set MeterTypeID value
     * @param int $meterTypeID
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setMeterTypeID($meterTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($meterTypeID) && !is_numeric($meterTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterTypeID)), __LINE__);
        }
        $this->MeterTypeID = $meterTypeID;
        return $this;
    }
    /**
     * Get MeterInventoryStatusID value
     * @return int
     */
    public function getMeterInventoryStatusID()
    {
        return $this->MeterInventoryStatusID;
    }
    /**
     * Set MeterInventoryStatusID value
     * @param int $meterInventoryStatusID
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setMeterInventoryStatusID($meterInventoryStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterInventoryStatusID) && !is_numeric($meterInventoryStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterInventoryStatusID)), __LINE__);
        }
        $this->MeterInventoryStatusID = $meterInventoryStatusID;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get InstallDate1 value
     * @return string
     */
    public function getInstallDate1()
    {
        return $this->InstallDate1;
    }
    /**
     * Set InstallDate1 value
     * @param string $installDate1
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setInstallDate1($installDate1 = null)
    {
        // validation for constraint: string
        if (!is_null($installDate1) && !is_string($installDate1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installDate1)), __LINE__);
        }
        $this->InstallDate1 = $installDate1;
        return $this;
    }
    /**
     * Get InstallDate2 value
     * @return string
     */
    public function getInstallDate2()
    {
        return $this->InstallDate2;
    }
    /**
     * Set InstallDate2 value
     * @param string $installDate2
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setInstallDate2($installDate2 = null)
    {
        // validation for constraint: string
        if (!is_null($installDate2) && !is_string($installDate2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($installDate2)), __LINE__);
        }
        $this->InstallDate2 = $installDate2;
        return $this;
    }
    /**
     * Get MeterStatusID value
     * @return int
     */
    public function getMeterStatusID()
    {
        return $this->MeterStatusID;
    }
    /**
     * Set MeterStatusID value
     * @param int $meterStatusID
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setMeterStatusID($meterStatusID = null)
    {
        // validation for constraint: int
        if (!is_null($meterStatusID) && !is_numeric($meterStatusID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterStatusID)), __LINE__);
        }
        $this->MeterStatusID = $meterStatusID;
        return $this;
    }
    /**
     * Get MeterGroupID value
     * @return int
     */
    public function getMeterGroupID()
    {
        return $this->MeterGroupID;
    }
    /**
     * Set MeterGroupID value
     * @param int $meterGroupID
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setMeterGroupID($meterGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($meterGroupID) && !is_numeric($meterGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($meterGroupID)), __LINE__);
        }
        $this->MeterGroupID = $meterGroupID;
        return $this;
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get searchParameters value
     * @return \SGCIS\Array\ArrayOfString|null
     */
    public function getSearchParameters()
    {
        return $this->searchParameters;
    }
    /**
     * Set searchParameters value
     * @param \SGCIS\Array\ArrayOfString $searchParameters
     * @return \SGCIS\Struct\MeterQuery
     */
    public function setSearchParameters(\SGCIS\Array\ArrayOfString $searchParameters = null)
    {
        $this->searchParameters = $searchParameters;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\MeterQuery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
