<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionServiceProvider Struct
 * @subpackage Structs
 */
class DistributionServiceProvider extends BaseDTO
{
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The BaseCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BaseCharges;
    /**
     * The ShadowSettlementCharges
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ShadowSettlementCharges;
    /**
     * The PriorityMoveInFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PriorityMoveInFee;
    /**
     * The OutOfCycleSwitchFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OutOfCycleSwitchFee;
    /**
     * The LineLossFactor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $LineLossFactor;
    /**
     * The StandardMoveInFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $StandardMoveInFee;
    /**
     * The MoveOutFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MoveOutFee;
    /**
     * The DisconnectNoPayFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $DisconnectNoPayFee;
    /**
     * The ReconnectAfterDNPFee
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReconnectAfterDNPFee;
    /**
     * The LookAheadDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LookAheadDays;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The DUNSNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUNSNumber;
    /**
     * The ISO
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ISO;
    /**
     * The StateCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateCode;
    /**
     * The StateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StateName;
    /**
     * The Audits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDistributionServiceProviderAudit
     */
    public $Audits;
    /**
     * The Cycles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfMonthlyBillingCycle
     */
    public $Cycles;
    /**
     * The Holidays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDateTime
     */
    public $Holidays;
    /**
     * The WorkingDay
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ServiceProviderWorkingDays
     */
    public $WorkingDay;
    /**
     * Constructor method for DistributionServiceProvider
     * @uses DistributionServiceProvider::setDistributionServiceProviderID()
     * @uses DistributionServiceProvider::setActive()
     * @uses DistributionServiceProvider::setBaseCharges()
     * @uses DistributionServiceProvider::setShadowSettlementCharges()
     * @uses DistributionServiceProvider::setPriorityMoveInFee()
     * @uses DistributionServiceProvider::setOutOfCycleSwitchFee()
     * @uses DistributionServiceProvider::setLineLossFactor()
     * @uses DistributionServiceProvider::setStandardMoveInFee()
     * @uses DistributionServiceProvider::setMoveOutFee()
     * @uses DistributionServiceProvider::setDisconnectNoPayFee()
     * @uses DistributionServiceProvider::setReconnectAfterDNPFee()
     * @uses DistributionServiceProvider::setLookAheadDays()
     * @uses DistributionServiceProvider::setName()
     * @uses DistributionServiceProvider::setDescription()
     * @uses DistributionServiceProvider::setDUNSNumber()
     * @uses DistributionServiceProvider::setISO()
     * @uses DistributionServiceProvider::setStateCode()
     * @uses DistributionServiceProvider::setStateName()
     * @uses DistributionServiceProvider::setAudits()
     * @uses DistributionServiceProvider::setCycles()
     * @uses DistributionServiceProvider::setHolidays()
     * @uses DistributionServiceProvider::setWorkingDay()
     * @param int $distributionServiceProviderID
     * @param bool $active
     * @param float $baseCharges
     * @param float $shadowSettlementCharges
     * @param float $priorityMoveInFee
     * @param float $outOfCycleSwitchFee
     * @param float $lineLossFactor
     * @param float $standardMoveInFee
     * @param float $moveOutFee
     * @param float $disconnectNoPayFee
     * @param float $reconnectAfterDNPFee
     * @param int $lookAheadDays
     * @param string $name
     * @param string $description
     * @param string $dUNSNumber
     * @param string $iSO
     * @param string $stateCode
     * @param string $stateName
     * @param \SGCIS\Array\ArrayOfDistributionServiceProviderAudit $audits
     * @param \SGCIS\Array\ArrayOfMonthlyBillingCycle $cycles
     * @param \SGCIS\Array\ArrayOfDateTime $holidays
     * @param \SGCIS\Struct\ServiceProviderWorkingDays $workingDay
     */
    public function __construct($distributionServiceProviderID = null, $active = null, $baseCharges = null, $shadowSettlementCharges = null, $priorityMoveInFee = null, $outOfCycleSwitchFee = null, $lineLossFactor = null, $standardMoveInFee = null, $moveOutFee = null, $disconnectNoPayFee = null, $reconnectAfterDNPFee = null, $lookAheadDays = null, $name = null, $description = null, $dUNSNumber = null, $iSO = null, $stateCode = null, $stateName = null, \SGCIS\Array\ArrayOfDistributionServiceProviderAudit $audits = null, \SGCIS\Array\ArrayOfMonthlyBillingCycle $cycles = null, \SGCIS\Array\ArrayOfDateTime $holidays = null, \SGCIS\Struct\ServiceProviderWorkingDays $workingDay = null)
    {
        $this
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setActive($active)
            ->setBaseCharges($baseCharges)
            ->setShadowSettlementCharges($shadowSettlementCharges)
            ->setPriorityMoveInFee($priorityMoveInFee)
            ->setOutOfCycleSwitchFee($outOfCycleSwitchFee)
            ->setLineLossFactor($lineLossFactor)
            ->setStandardMoveInFee($standardMoveInFee)
            ->setMoveOutFee($moveOutFee)
            ->setDisconnectNoPayFee($disconnectNoPayFee)
            ->setReconnectAfterDNPFee($reconnectAfterDNPFee)
            ->setLookAheadDays($lookAheadDays)
            ->setName($name)
            ->setDescription($description)
            ->setDUNSNumber($dUNSNumber)
            ->setISO($iSO)
            ->setStateCode($stateCode)
            ->setStateName($stateName)
            ->setAudits($audits)
            ->setCycles($cycles)
            ->setHolidays($holidays)
            ->setWorkingDay($workingDay);
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get BaseCharges value
     * @return float
     */
    public function getBaseCharges()
    {
        return $this->BaseCharges;
    }
    /**
     * Set BaseCharges value
     * @param float $baseCharges
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setBaseCharges($baseCharges = null)
    {
        $this->BaseCharges = $baseCharges;
        return $this;
    }
    /**
     * Get ShadowSettlementCharges value
     * @return float
     */
    public function getShadowSettlementCharges()
    {
        return $this->ShadowSettlementCharges;
    }
    /**
     * Set ShadowSettlementCharges value
     * @param float $shadowSettlementCharges
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setShadowSettlementCharges($shadowSettlementCharges = null)
    {
        $this->ShadowSettlementCharges = $shadowSettlementCharges;
        return $this;
    }
    /**
     * Get PriorityMoveInFee value
     * @return float
     */
    public function getPriorityMoveInFee()
    {
        return $this->PriorityMoveInFee;
    }
    /**
     * Set PriorityMoveInFee value
     * @param float $priorityMoveInFee
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setPriorityMoveInFee($priorityMoveInFee = null)
    {
        $this->PriorityMoveInFee = $priorityMoveInFee;
        return $this;
    }
    /**
     * Get OutOfCycleSwitchFee value
     * @return float
     */
    public function getOutOfCycleSwitchFee()
    {
        return $this->OutOfCycleSwitchFee;
    }
    /**
     * Set OutOfCycleSwitchFee value
     * @param float $outOfCycleSwitchFee
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setOutOfCycleSwitchFee($outOfCycleSwitchFee = null)
    {
        $this->OutOfCycleSwitchFee = $outOfCycleSwitchFee;
        return $this;
    }
    /**
     * Get LineLossFactor value
     * @return float
     */
    public function getLineLossFactor()
    {
        return $this->LineLossFactor;
    }
    /**
     * Set LineLossFactor value
     * @param float $lineLossFactor
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setLineLossFactor($lineLossFactor = null)
    {
        $this->LineLossFactor = $lineLossFactor;
        return $this;
    }
    /**
     * Get StandardMoveInFee value
     * @return float
     */
    public function getStandardMoveInFee()
    {
        return $this->StandardMoveInFee;
    }
    /**
     * Set StandardMoveInFee value
     * @param float $standardMoveInFee
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setStandardMoveInFee($standardMoveInFee = null)
    {
        $this->StandardMoveInFee = $standardMoveInFee;
        return $this;
    }
    /**
     * Get MoveOutFee value
     * @return float
     */
    public function getMoveOutFee()
    {
        return $this->MoveOutFee;
    }
    /**
     * Set MoveOutFee value
     * @param float $moveOutFee
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setMoveOutFee($moveOutFee = null)
    {
        $this->MoveOutFee = $moveOutFee;
        return $this;
    }
    /**
     * Get DisconnectNoPayFee value
     * @return float
     */
    public function getDisconnectNoPayFee()
    {
        return $this->DisconnectNoPayFee;
    }
    /**
     * Set DisconnectNoPayFee value
     * @param float $disconnectNoPayFee
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setDisconnectNoPayFee($disconnectNoPayFee = null)
    {
        $this->DisconnectNoPayFee = $disconnectNoPayFee;
        return $this;
    }
    /**
     * Get ReconnectAfterDNPFee value
     * @return float
     */
    public function getReconnectAfterDNPFee()
    {
        return $this->ReconnectAfterDNPFee;
    }
    /**
     * Set ReconnectAfterDNPFee value
     * @param float $reconnectAfterDNPFee
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setReconnectAfterDNPFee($reconnectAfterDNPFee = null)
    {
        $this->ReconnectAfterDNPFee = $reconnectAfterDNPFee;
        return $this;
    }
    /**
     * Get LookAheadDays value
     * @return int
     */
    public function getLookAheadDays()
    {
        return $this->LookAheadDays;
    }
    /**
     * Set LookAheadDays value
     * @param int $lookAheadDays
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setLookAheadDays($lookAheadDays = null)
    {
        // validation for constraint: int
        if (!is_null($lookAheadDays) && !is_numeric($lookAheadDays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lookAheadDays)), __LINE__);
        }
        $this->LookAheadDays = $lookAheadDays;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get DUNSNumber value
     * @return string|null
     */
    public function getDUNSNumber()
    {
        return $this->DUNSNumber;
    }
    /**
     * Set DUNSNumber value
     * @param string $dUNSNumber
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setDUNSNumber($dUNSNumber = null)
    {
        // validation for constraint: string
        if (!is_null($dUNSNumber) && !is_string($dUNSNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dUNSNumber)), __LINE__);
        }
        $this->DUNSNumber = $dUNSNumber;
        return $this;
    }
    /**
     * Get ISO value
     * @return string|null
     */
    public function getISO()
    {
        return $this->ISO;
    }
    /**
     * Set ISO value
     * @param string $iSO
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setISO($iSO = null)
    {
        // validation for constraint: string
        if (!is_null($iSO) && !is_string($iSO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSO)), __LINE__);
        }
        $this->ISO = $iSO;
        return $this;
    }
    /**
     * Get StateCode value
     * @return string|null
     */
    public function getStateCode()
    {
        return $this->StateCode;
    }
    /**
     * Set StateCode value
     * @param string $stateCode
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setStateCode($stateCode = null)
    {
        // validation for constraint: string
        if (!is_null($stateCode) && !is_string($stateCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateCode)), __LINE__);
        }
        $this->StateCode = $stateCode;
        return $this;
    }
    /**
     * Get StateName value
     * @return string|null
     */
    public function getStateName()
    {
        return $this->StateName;
    }
    /**
     * Set StateName value
     * @param string $stateName
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setStateName($stateName = null)
    {
        // validation for constraint: string
        if (!is_null($stateName) && !is_string($stateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($stateName)), __LINE__);
        }
        $this->StateName = $stateName;
        return $this;
    }
    /**
     * Get Audits value
     * @return \SGCIS\Array\ArrayOfDistributionServiceProviderAudit|null
     */
    public function getAudits()
    {
        return $this->Audits;
    }
    /**
     * Set Audits value
     * @param \SGCIS\Array\ArrayOfDistributionServiceProviderAudit $audits
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setAudits(\SGCIS\Array\ArrayOfDistributionServiceProviderAudit $audits = null)
    {
        $this->Audits = $audits;
        return $this;
    }
    /**
     * Get Cycles value
     * @return \SGCIS\Array\ArrayOfMonthlyBillingCycle|null
     */
    public function getCycles()
    {
        return $this->Cycles;
    }
    /**
     * Set Cycles value
     * @param \SGCIS\Array\ArrayOfMonthlyBillingCycle $cycles
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setCycles(\SGCIS\Array\ArrayOfMonthlyBillingCycle $cycles = null)
    {
        $this->Cycles = $cycles;
        return $this;
    }
    /**
     * Get Holidays value
     * @return \SGCIS\Array\ArrayOfDateTime|null
     */
    public function getHolidays()
    {
        return $this->Holidays;
    }
    /**
     * Set Holidays value
     * @param \SGCIS\Array\ArrayOfDateTime $holidays
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setHolidays(\SGCIS\Array\ArrayOfDateTime $holidays = null)
    {
        $this->Holidays = $holidays;
        return $this;
    }
    /**
     * Get WorkingDay value
     * @return \SGCIS\Struct\ServiceProviderWorkingDays|null
     */
    public function getWorkingDay()
    {
        return $this->WorkingDay;
    }
    /**
     * Set WorkingDay value
     * @param \SGCIS\Struct\ServiceProviderWorkingDays $workingDay
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public function setWorkingDay(\SGCIS\Struct\ServiceProviderWorkingDays $workingDay = null)
    {
        $this->WorkingDay = $workingDay;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DistributionServiceProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
