<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DataListCacheItem Struct
 * @subpackage Structs
 */
class DataListCacheItem extends AbstractStructBase
{
    /**
     * The ListType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ListType;
    /**
     * The ListData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfNameValuePair
     */
    public $ListData;
    /**
     * Constructor method for DataListCacheItem
     * @uses DataListCacheItem::setListType()
     * @uses DataListCacheItem::setListData()
     * @param string $listType
     * @param \SGCIS\Array\ArrayOfNameValuePair $listData
     */
    public function __construct($listType = null, \SGCIS\Array\ArrayOfNameValuePair $listData = null)
    {
        $this
            ->setListType($listType)
            ->setListData($listData);
    }
    /**
     * Get ListType value
     * @return string|null
     */
    public function getListType()
    {
        return $this->ListType;
    }
    /**
     * Set ListType value
     * @param string $listType
     * @return \SGCIS\Struct\DataListCacheItem
     */
    public function setListType($listType = null)
    {
        // validation for constraint: string
        if (!is_null($listType) && !is_string($listType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($listType)), __LINE__);
        }
        $this->ListType = $listType;
        return $this;
    }
    /**
     * Get ListData value
     * @return \SGCIS\Array\ArrayOfNameValuePair|null
     */
    public function getListData()
    {
        return $this->ListData;
    }
    /**
     * Set ListData value
     * @param \SGCIS\Array\ArrayOfNameValuePair $listData
     * @return \SGCIS\Struct\DataListCacheItem
     */
    public function setListData(\SGCIS\Array\ArrayOfNameValuePair $listData = null)
    {
        $this->ListData = $listData;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\DataListCacheItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
