<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomField Struct
 * @subpackage Structs
 */
class CustomField extends AbstractStructBase
{
    /**
     * The CustomFieldID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomFieldID;
    /**
     * The CustomFieldTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomFieldTypeID;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Active;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * Constructor method for CustomField
     * @uses CustomField::setCustomFieldID()
     * @uses CustomField::setCustomFieldTypeID()
     * @uses CustomField::setActive()
     * @uses CustomField::setName()
     * @uses CustomField::setDescription()
     * @uses CustomField::setValue()
     * @param int $customFieldID
     * @param int $customFieldTypeID
     * @param bool $active
     * @param string $name
     * @param string $description
     * @param string $value
     */
    public function __construct($customFieldID = null, $customFieldTypeID = null, $active = null, $name = null, $description = null, $value = null)
    {
        $this
            ->setCustomFieldID($customFieldID)
            ->setCustomFieldTypeID($customFieldTypeID)
            ->setActive($active)
            ->setName($name)
            ->setDescription($description)
            ->setValue($value);
    }
    /**
     * Get CustomFieldID value
     * @return int
     */
    public function getCustomFieldID()
    {
        return $this->CustomFieldID;
    }
    /**
     * Set CustomFieldID value
     * @param int $customFieldID
     * @return \SGCIS\Struct\CustomField
     */
    public function setCustomFieldID($customFieldID = null)
    {
        // validation for constraint: int
        if (!is_null($customFieldID) && !is_numeric($customFieldID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customFieldID)), __LINE__);
        }
        $this->CustomFieldID = $customFieldID;
        return $this;
    }
    /**
     * Get CustomFieldTypeID value
     * @return int
     */
    public function getCustomFieldTypeID()
    {
        return $this->CustomFieldTypeID;
    }
    /**
     * Set CustomFieldTypeID value
     * @param int $customFieldTypeID
     * @return \SGCIS\Struct\CustomField
     */
    public function setCustomFieldTypeID($customFieldTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($customFieldTypeID) && !is_numeric($customFieldTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customFieldTypeID)), __LINE__);
        }
        $this->CustomFieldTypeID = $customFieldTypeID;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \SGCIS\Struct\CustomField
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \SGCIS\Struct\CustomField
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\CustomField
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \SGCIS\Struct\CustomField
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\CustomField
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
