<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Company Struct
 * @subpackage Structs
 */
class Company extends AbstractStructBase
{
    /**
     * The CompanyID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CompanyID;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdateUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdateUserName;
    /**
     * The DUNS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DUNS;
    /**
     * The WorkingDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfInt
     */
    public $WorkingDays;
    /**
     * The Holidays
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfDateTime
     */
    public $Holidays;
    /**
     * Constructor method for Company
     * @uses Company::setCompanyID()
     * @uses Company::setCreateDate()
     * @uses Company::setLastUpdateDate()
     * @uses Company::setCompanyName()
     * @uses Company::setDescription()
     * @uses Company::setCreatedByUserName()
     * @uses Company::setLastUpdateUserName()
     * @uses Company::setDUNS()
     * @uses Company::setWorkingDays()
     * @uses Company::setHolidays()
     * @param int $companyID
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param string $companyName
     * @param string $description
     * @param string $createdByUserName
     * @param string $lastUpdateUserName
     * @param string $dUNS
     * @param \SGCIS\Array\ArrayOfInt $workingDays
     * @param \SGCIS\Array\ArrayOfDateTime $holidays
     */
    public function __construct($companyID = null, $createDate = null, $lastUpdateDate = null, $companyName = null, $description = null, $createdByUserName = null, $lastUpdateUserName = null, $dUNS = null, \SGCIS\Array\ArrayOfInt $workingDays = null, \SGCIS\Array\ArrayOfDateTime $holidays = null)
    {
        $this
            ->setCompanyID($companyID)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setCompanyName($companyName)
            ->setDescription($description)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdateUserName($lastUpdateUserName)
            ->setDUNS($dUNS)
            ->setWorkingDays($workingDays)
            ->setHolidays($holidays);
    }
    /**
     * Get CompanyID value
     * @return int
     */
    public function getCompanyID()
    {
        return $this->CompanyID;
    }
    /**
     * Set CompanyID value
     * @param int $companyID
     * @return \SGCIS\Struct\Company
     */
    public function setCompanyID($companyID = null)
    {
        // validation for constraint: int
        if (!is_null($companyID) && !is_numeric($companyID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($companyID)), __LINE__);
        }
        $this->CompanyID = $companyID;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\Company
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\Company
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \SGCIS\Struct\Company
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \SGCIS\Struct\Company
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\Company
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdateUserName value
     * @return string|null
     */
    public function getLastUpdateUserName()
    {
        return $this->LastUpdateUserName;
    }
    /**
     * Set LastUpdateUserName value
     * @param string $lastUpdateUserName
     * @return \SGCIS\Struct\Company
     */
    public function setLastUpdateUserName($lastUpdateUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateUserName) && !is_string($lastUpdateUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateUserName)), __LINE__);
        }
        $this->LastUpdateUserName = $lastUpdateUserName;
        return $this;
    }
    /**
     * Get DUNS value
     * @return string|null
     */
    public function getDUNS()
    {
        return $this->DUNS;
    }
    /**
     * Set DUNS value
     * @param string $dUNS
     * @return \SGCIS\Struct\Company
     */
    public function setDUNS($dUNS = null)
    {
        // validation for constraint: string
        if (!is_null($dUNS) && !is_string($dUNS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dUNS)), __LINE__);
        }
        $this->DUNS = $dUNS;
        return $this;
    }
    /**
     * Get WorkingDays value
     * @return \SGCIS\Array\ArrayOfInt|null
     */
    public function getWorkingDays()
    {
        return $this->WorkingDays;
    }
    /**
     * Set WorkingDays value
     * @param \SGCIS\Array\ArrayOfInt $workingDays
     * @return \SGCIS\Struct\Company
     */
    public function setWorkingDays(\SGCIS\Array\ArrayOfInt $workingDays = null)
    {
        $this->WorkingDays = $workingDays;
        return $this;
    }
    /**
     * Get Holidays value
     * @return \SGCIS\Array\ArrayOfDateTime|null
     */
    public function getHolidays()
    {
        return $this->Holidays;
    }
    /**
     * Set Holidays value
     * @param \SGCIS\Array\ArrayOfDateTime $holidays
     * @return \SGCIS\Struct\Company
     */
    public function setHolidays(\SGCIS\Array\ArrayOfDateTime $holidays = null)
    {
        $this->Holidays = $holidays;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Company
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
