<?php

namespace SGCIS\Struct;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Charge Struct
 * @subpackage Structs
 */
class Charge extends AbstractStructBase
{
    /**
     * The ChargeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeID;
    /**
     * The ChargeGroupID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeGroupID;
    /**
     * The RateID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RateID;
    /**
     * The CommodityID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommodityID;
    /**
     * The Frequency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Frequency;
    /**
     * The UnitFactor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $UnitFactor;
    /**
     * The ChargeCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeCategoryID;
    /**
     * The ChargeLevelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeLevelID;
    /**
     * The ChargeModelID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeModelID;
    /**
     * The ChargeTriggerTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeTriggerTypeID;
    /**
     * The SystemEventID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SystemEventID;
    /**
     * The TOUID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TOUID;
    /**
     * The EffectiveDateFrom
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveDateFrom;
    /**
     * The EffectiveDateTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EffectiveDateTo;
    /**
     * The ChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeAmount;
    /**
     * The ChargeAmountContracted
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeAmountContracted;
    /**
     * The IsActive
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The IsReconciliationCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsReconciliationCharge;
    /**
     * The IsAutoReconcileCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAutoReconcileCharge;
    /**
     * The IsContractUpdate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsContractUpdate;
    /**
     * The IsTaxable
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTaxable;
    /**
     * The ThresholdVolume
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ThresholdVolume;
    /**
     * The BelowThresholdCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BelowThresholdCharge;
    /**
     * The AboveThresholdCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AboveThresholdCharge;
    /**
     * The ChargeIndexTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeIndexTypeID;
    /**
     * The ChargeIndexMinChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeIndexMinChargeAmount;
    /**
     * The ChargeIndexMaxChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ChargeIndexMaxChargeAmount;
    /**
     * The DateApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DateApproved;
    /**
     * The CreateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CreateDate;
    /**
     * The LastUpdateDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LastUpdateDate;
    /**
     * The UnitOfMeasureID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UnitOfMeasureID;
    /**
     * The IncludedUnits
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $IncludedUnits;
    /**
     * The OverageUnitPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $OverageUnitPrice;
    /**
     * The CustomChargeModuleID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomChargeModuleID;
    /**
     * The IsApproved
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsApproved;
    /**
     * The IsPassThrough
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsPassThrough;
    /**
     * The TotalChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalChargeAmount;
    /**
     * The MinChargeAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinChargeAmount;
    /**
     * The MinChargeThreshold
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $MinChargeThreshold;
    /**
     * The TransactionTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionTypeID;
    /**
     * The TransactionTypeCategoryID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TransactionTypeCategoryID;
    /**
     * The IsBaseCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBaseCharge;
    /**
     * The DistributionServiceProviderID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DistributionServiceProviderID;
    /**
     * The IsServiceAgreementCharge
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsServiceAgreementCharge;
    /**
     * The PremiseTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PremiseTypeID;
    /**
     * The UOMQuantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $UOMQuantity;
    /**
     * The MarketPricingNodeHistoryTypeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $MarketPricingNodeHistoryTypeID;
    /**
     * The ChargeName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeName;
    /**
     * The ChargeCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCode;
    /**
     * The ChargeDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeDescription;
    /**
     * The BillDisplayDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BillDisplayDescription;
    /**
     * The ApprovedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovedByUserName;
    /**
     * The CreatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreatedByUserName;
    /**
     * The LastUpdatedByUserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LastUpdatedByUserName;
    /**
     * The TaxTransactionTypeCodeID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxTransactionTypeCodeID;
    /**
     * The TieredRates
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TieredRates;
    /**
     * The ChargeCategoryName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeCategoryName;
    /**
     * The ChargeModelName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ChargeModelName;
    /**
     * The ChargeAccountType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfChargeAccountType
     */
    public $ChargeAccountType;
    /**
     * The ChargeDistributionServiceProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfChargeDistributionServiceProvider
     */
    public $ChargeDistributionServiceProvider;
    /**
     * The ChargeTier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfChargeTier
     */
    public $ChargeTier;
    /**
     * The ChargeSchedule
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\ChargeSchedule
     */
    public $ChargeSchedule;
    /**
     * The TOU
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Struct\TOU
     */
    public $TOU;
    /**
     * The TOUChargeSchedules
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfTOU
     */
    public $TOUChargeSchedules;
    /**
     * The ChargeCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \SGCIS\Array\ArrayOfChargeCharacteristic
     */
    public $ChargeCharacteristic;
    /**
     * The DistributionServiceProviders
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DistributionServiceProviders;
    /**
     * The CustomRateName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomRateName;
    /**
     * Constructor method for Charge
     * @uses Charge::setChargeID()
     * @uses Charge::setChargeGroupID()
     * @uses Charge::setRateID()
     * @uses Charge::setCommodityID()
     * @uses Charge::setFrequency()
     * @uses Charge::setUnitFactor()
     * @uses Charge::setChargeCategoryID()
     * @uses Charge::setChargeLevelID()
     * @uses Charge::setChargeModelID()
     * @uses Charge::setChargeTriggerTypeID()
     * @uses Charge::setSystemEventID()
     * @uses Charge::setTOUID()
     * @uses Charge::setEffectiveDateFrom()
     * @uses Charge::setEffectiveDateTo()
     * @uses Charge::setChargeAmount()
     * @uses Charge::setChargeAmountContracted()
     * @uses Charge::setIsActive()
     * @uses Charge::setIsReconciliationCharge()
     * @uses Charge::setIsAutoReconcileCharge()
     * @uses Charge::setIsContractUpdate()
     * @uses Charge::setIsTaxable()
     * @uses Charge::setThresholdVolume()
     * @uses Charge::setBelowThresholdCharge()
     * @uses Charge::setAboveThresholdCharge()
     * @uses Charge::setChargeIndexTypeID()
     * @uses Charge::setChargeIndexMinChargeAmount()
     * @uses Charge::setChargeIndexMaxChargeAmount()
     * @uses Charge::setDateApproved()
     * @uses Charge::setCreateDate()
     * @uses Charge::setLastUpdateDate()
     * @uses Charge::setUnitOfMeasureID()
     * @uses Charge::setIncludedUnits()
     * @uses Charge::setOverageUnitPrice()
     * @uses Charge::setCustomChargeModuleID()
     * @uses Charge::setIsApproved()
     * @uses Charge::setIsPassThrough()
     * @uses Charge::setTotalChargeAmount()
     * @uses Charge::setMinChargeAmount()
     * @uses Charge::setMinChargeThreshold()
     * @uses Charge::setTransactionTypeID()
     * @uses Charge::setTransactionTypeCategoryID()
     * @uses Charge::setIsBaseCharge()
     * @uses Charge::setDistributionServiceProviderID()
     * @uses Charge::setIsServiceAgreementCharge()
     * @uses Charge::setPremiseTypeID()
     * @uses Charge::setUOMQuantity()
     * @uses Charge::setMarketPricingNodeHistoryTypeID()
     * @uses Charge::setChargeName()
     * @uses Charge::setChargeCode()
     * @uses Charge::setChargeDescription()
     * @uses Charge::setBillDisplayDescription()
     * @uses Charge::setApprovedByUserName()
     * @uses Charge::setCreatedByUserName()
     * @uses Charge::setLastUpdatedByUserName()
     * @uses Charge::setTaxTransactionTypeCodeID()
     * @uses Charge::setTieredRates()
     * @uses Charge::setChargeCategoryName()
     * @uses Charge::setChargeModelName()
     * @uses Charge::setChargeAccountType()
     * @uses Charge::setChargeDistributionServiceProvider()
     * @uses Charge::setChargeTier()
     * @uses Charge::setChargeSchedule()
     * @uses Charge::setTOU()
     * @uses Charge::setTOUChargeSchedules()
     * @uses Charge::setChargeCharacteristic()
     * @uses Charge::setDistributionServiceProviders()
     * @uses Charge::setCustomRateName()
     * @param int $chargeID
     * @param int $chargeGroupID
     * @param int $rateID
     * @param int $commodityID
     * @param int $frequency
     * @param float $unitFactor
     * @param int $chargeCategoryID
     * @param int $chargeLevelID
     * @param int $chargeModelID
     * @param int $chargeTriggerTypeID
     * @param int $systemEventID
     * @param int $tOUID
     * @param string $effectiveDateFrom
     * @param string $effectiveDateTo
     * @param float $chargeAmount
     * @param float $chargeAmountContracted
     * @param bool $isActive
     * @param bool $isReconciliationCharge
     * @param bool $isAutoReconcileCharge
     * @param bool $isContractUpdate
     * @param bool $isTaxable
     * @param float $thresholdVolume
     * @param float $belowThresholdCharge
     * @param float $aboveThresholdCharge
     * @param int $chargeIndexTypeID
     * @param float $chargeIndexMinChargeAmount
     * @param float $chargeIndexMaxChargeAmount
     * @param string $dateApproved
     * @param string $createDate
     * @param string $lastUpdateDate
     * @param int $unitOfMeasureID
     * @param float $includedUnits
     * @param float $overageUnitPrice
     * @param int $customChargeModuleID
     * @param bool $isApproved
     * @param bool $isPassThrough
     * @param float $totalChargeAmount
     * @param float $minChargeAmount
     * @param float $minChargeThreshold
     * @param int $transactionTypeID
     * @param int $transactionTypeCategoryID
     * @param bool $isBaseCharge
     * @param int $distributionServiceProviderID
     * @param bool $isServiceAgreementCharge
     * @param int $premiseTypeID
     * @param int $uOMQuantity
     * @param int $marketPricingNodeHistoryTypeID
     * @param string $chargeName
     * @param string $chargeCode
     * @param string $chargeDescription
     * @param string $billDisplayDescription
     * @param string $approvedByUserName
     * @param string $createdByUserName
     * @param string $lastUpdatedByUserName
     * @param string $taxTransactionTypeCodeID
     * @param string $tieredRates
     * @param string $chargeCategoryName
     * @param string $chargeModelName
     * @param \SGCIS\Array\ArrayOfChargeAccountType $chargeAccountType
     * @param \SGCIS\Array\ArrayOfChargeDistributionServiceProvider $chargeDistributionServiceProvider
     * @param \SGCIS\Array\ArrayOfChargeTier $chargeTier
     * @param \SGCIS\Struct\ChargeSchedule $chargeSchedule
     * @param \SGCIS\Struct\TOU $tOU
     * @param \SGCIS\Array\ArrayOfTOU $tOUChargeSchedules
     * @param \SGCIS\Array\ArrayOfChargeCharacteristic $chargeCharacteristic
     * @param string $distributionServiceProviders
     * @param string $customRateName
     */
    public function __construct($chargeID = null, $chargeGroupID = null, $rateID = null, $commodityID = null, $frequency = null, $unitFactor = null, $chargeCategoryID = null, $chargeLevelID = null, $chargeModelID = null, $chargeTriggerTypeID = null, $systemEventID = null, $tOUID = null, $effectiveDateFrom = null, $effectiveDateTo = null, $chargeAmount = null, $chargeAmountContracted = null, $isActive = null, $isReconciliationCharge = null, $isAutoReconcileCharge = null, $isContractUpdate = null, $isTaxable = null, $thresholdVolume = null, $belowThresholdCharge = null, $aboveThresholdCharge = null, $chargeIndexTypeID = null, $chargeIndexMinChargeAmount = null, $chargeIndexMaxChargeAmount = null, $dateApproved = null, $createDate = null, $lastUpdateDate = null, $unitOfMeasureID = null, $includedUnits = null, $overageUnitPrice = null, $customChargeModuleID = null, $isApproved = null, $isPassThrough = null, $totalChargeAmount = null, $minChargeAmount = null, $minChargeThreshold = null, $transactionTypeID = null, $transactionTypeCategoryID = null, $isBaseCharge = null, $distributionServiceProviderID = null, $isServiceAgreementCharge = null, $premiseTypeID = null, $uOMQuantity = null, $marketPricingNodeHistoryTypeID = null, $chargeName = null, $chargeCode = null, $chargeDescription = null, $billDisplayDescription = null, $approvedByUserName = null, $createdByUserName = null, $lastUpdatedByUserName = null, $taxTransactionTypeCodeID = null, $tieredRates = null, $chargeCategoryName = null, $chargeModelName = null, \SGCIS\Array\ArrayOfChargeAccountType $chargeAccountType = null, \SGCIS\Array\ArrayOfChargeDistributionServiceProvider $chargeDistributionServiceProvider = null, \SGCIS\Array\ArrayOfChargeTier $chargeTier = null, \SGCIS\Struct\ChargeSchedule $chargeSchedule = null, \SGCIS\Struct\TOU $tOU = null, \SGCIS\Array\ArrayOfTOU $tOUChargeSchedules = null, \SGCIS\Array\ArrayOfChargeCharacteristic $chargeCharacteristic = null, $distributionServiceProviders = null, $customRateName = null)
    {
        $this
            ->setChargeID($chargeID)
            ->setChargeGroupID($chargeGroupID)
            ->setRateID($rateID)
            ->setCommodityID($commodityID)
            ->setFrequency($frequency)
            ->setUnitFactor($unitFactor)
            ->setChargeCategoryID($chargeCategoryID)
            ->setChargeLevelID($chargeLevelID)
            ->setChargeModelID($chargeModelID)
            ->setChargeTriggerTypeID($chargeTriggerTypeID)
            ->setSystemEventID($systemEventID)
            ->setTOUID($tOUID)
            ->setEffectiveDateFrom($effectiveDateFrom)
            ->setEffectiveDateTo($effectiveDateTo)
            ->setChargeAmount($chargeAmount)
            ->setChargeAmountContracted($chargeAmountContracted)
            ->setIsActive($isActive)
            ->setIsReconciliationCharge($isReconciliationCharge)
            ->setIsAutoReconcileCharge($isAutoReconcileCharge)
            ->setIsContractUpdate($isContractUpdate)
            ->setIsTaxable($isTaxable)
            ->setThresholdVolume($thresholdVolume)
            ->setBelowThresholdCharge($belowThresholdCharge)
            ->setAboveThresholdCharge($aboveThresholdCharge)
            ->setChargeIndexTypeID($chargeIndexTypeID)
            ->setChargeIndexMinChargeAmount($chargeIndexMinChargeAmount)
            ->setChargeIndexMaxChargeAmount($chargeIndexMaxChargeAmount)
            ->setDateApproved($dateApproved)
            ->setCreateDate($createDate)
            ->setLastUpdateDate($lastUpdateDate)
            ->setUnitOfMeasureID($unitOfMeasureID)
            ->setIncludedUnits($includedUnits)
            ->setOverageUnitPrice($overageUnitPrice)
            ->setCustomChargeModuleID($customChargeModuleID)
            ->setIsApproved($isApproved)
            ->setIsPassThrough($isPassThrough)
            ->setTotalChargeAmount($totalChargeAmount)
            ->setMinChargeAmount($minChargeAmount)
            ->setMinChargeThreshold($minChargeThreshold)
            ->setTransactionTypeID($transactionTypeID)
            ->setTransactionTypeCategoryID($transactionTypeCategoryID)
            ->setIsBaseCharge($isBaseCharge)
            ->setDistributionServiceProviderID($distributionServiceProviderID)
            ->setIsServiceAgreementCharge($isServiceAgreementCharge)
            ->setPremiseTypeID($premiseTypeID)
            ->setUOMQuantity($uOMQuantity)
            ->setMarketPricingNodeHistoryTypeID($marketPricingNodeHistoryTypeID)
            ->setChargeName($chargeName)
            ->setChargeCode($chargeCode)
            ->setChargeDescription($chargeDescription)
            ->setBillDisplayDescription($billDisplayDescription)
            ->setApprovedByUserName($approvedByUserName)
            ->setCreatedByUserName($createdByUserName)
            ->setLastUpdatedByUserName($lastUpdatedByUserName)
            ->setTaxTransactionTypeCodeID($taxTransactionTypeCodeID)
            ->setTieredRates($tieredRates)
            ->setChargeCategoryName($chargeCategoryName)
            ->setChargeModelName($chargeModelName)
            ->setChargeAccountType($chargeAccountType)
            ->setChargeDistributionServiceProvider($chargeDistributionServiceProvider)
            ->setChargeTier($chargeTier)
            ->setChargeSchedule($chargeSchedule)
            ->setTOU($tOU)
            ->setTOUChargeSchedules($tOUChargeSchedules)
            ->setChargeCharacteristic($chargeCharacteristic)
            ->setDistributionServiceProviders($distributionServiceProviders)
            ->setCustomRateName($customRateName);
    }
    /**
     * Get ChargeID value
     * @return int
     */
    public function getChargeID()
    {
        return $this->ChargeID;
    }
    /**
     * Set ChargeID value
     * @param int $chargeID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeID($chargeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeID) && !is_numeric($chargeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeID)), __LINE__);
        }
        $this->ChargeID = $chargeID;
        return $this;
    }
    /**
     * Get ChargeGroupID value
     * @return int
     */
    public function getChargeGroupID()
    {
        return $this->ChargeGroupID;
    }
    /**
     * Set ChargeGroupID value
     * @param int $chargeGroupID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeGroupID($chargeGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeGroupID) && !is_numeric($chargeGroupID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeGroupID)), __LINE__);
        }
        $this->ChargeGroupID = $chargeGroupID;
        return $this;
    }
    /**
     * Get RateID value
     * @return int
     */
    public function getRateID()
    {
        return $this->RateID;
    }
    /**
     * Set RateID value
     * @param int $rateID
     * @return \SGCIS\Struct\Charge
     */
    public function setRateID($rateID = null)
    {
        // validation for constraint: int
        if (!is_null($rateID) && !is_numeric($rateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($rateID)), __LINE__);
        }
        $this->RateID = $rateID;
        return $this;
    }
    /**
     * Get CommodityID value
     * @return int
     */
    public function getCommodityID()
    {
        return $this->CommodityID;
    }
    /**
     * Set CommodityID value
     * @param int $commodityID
     * @return \SGCIS\Struct\Charge
     */
    public function setCommodityID($commodityID = null)
    {
        // validation for constraint: int
        if (!is_null($commodityID) && !is_numeric($commodityID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($commodityID)), __LINE__);
        }
        $this->CommodityID = $commodityID;
        return $this;
    }
    /**
     * Get Frequency value
     * @return int
     */
    public function getFrequency()
    {
        return $this->Frequency;
    }
    /**
     * Set Frequency value
     * @param int $frequency
     * @return \SGCIS\Struct\Charge
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: int
        if (!is_null($frequency) && !is_numeric($frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($frequency)), __LINE__);
        }
        $this->Frequency = $frequency;
        return $this;
    }
    /**
     * Get UnitFactor value
     * @return float
     */
    public function getUnitFactor()
    {
        return $this->UnitFactor;
    }
    /**
     * Set UnitFactor value
     * @param float $unitFactor
     * @return \SGCIS\Struct\Charge
     */
    public function setUnitFactor($unitFactor = null)
    {
        $this->UnitFactor = $unitFactor;
        return $this;
    }
    /**
     * Get ChargeCategoryID value
     * @return int
     */
    public function getChargeCategoryID()
    {
        return $this->ChargeCategoryID;
    }
    /**
     * Set ChargeCategoryID value
     * @param int $chargeCategoryID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeCategoryID($chargeCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeCategoryID) && !is_numeric($chargeCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeCategoryID)), __LINE__);
        }
        $this->ChargeCategoryID = $chargeCategoryID;
        return $this;
    }
    /**
     * Get ChargeLevelID value
     * @return int
     */
    public function getChargeLevelID()
    {
        return $this->ChargeLevelID;
    }
    /**
     * Set ChargeLevelID value
     * @param int $chargeLevelID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeLevelID($chargeLevelID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeLevelID) && !is_numeric($chargeLevelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeLevelID)), __LINE__);
        }
        $this->ChargeLevelID = $chargeLevelID;
        return $this;
    }
    /**
     * Get ChargeModelID value
     * @return int
     */
    public function getChargeModelID()
    {
        return $this->ChargeModelID;
    }
    /**
     * Set ChargeModelID value
     * @param int $chargeModelID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeModelID($chargeModelID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeModelID) && !is_numeric($chargeModelID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeModelID)), __LINE__);
        }
        $this->ChargeModelID = $chargeModelID;
        return $this;
    }
    /**
     * Get ChargeTriggerTypeID value
     * @return int
     */
    public function getChargeTriggerTypeID()
    {
        return $this->ChargeTriggerTypeID;
    }
    /**
     * Set ChargeTriggerTypeID value
     * @param int $chargeTriggerTypeID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeTriggerTypeID($chargeTriggerTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeTriggerTypeID) && !is_numeric($chargeTriggerTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeTriggerTypeID)), __LINE__);
        }
        $this->ChargeTriggerTypeID = $chargeTriggerTypeID;
        return $this;
    }
    /**
     * Get SystemEventID value
     * @return int
     */
    public function getSystemEventID()
    {
        return $this->SystemEventID;
    }
    /**
     * Set SystemEventID value
     * @param int $systemEventID
     * @return \SGCIS\Struct\Charge
     */
    public function setSystemEventID($systemEventID = null)
    {
        // validation for constraint: int
        if (!is_null($systemEventID) && !is_numeric($systemEventID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($systemEventID)), __LINE__);
        }
        $this->SystemEventID = $systemEventID;
        return $this;
    }
    /**
     * Get TOUID value
     * @return int
     */
    public function getTOUID()
    {
        return $this->TOUID;
    }
    /**
     * Set TOUID value
     * @param int $tOUID
     * @return \SGCIS\Struct\Charge
     */
    public function setTOUID($tOUID = null)
    {
        // validation for constraint: int
        if (!is_null($tOUID) && !is_numeric($tOUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tOUID)), __LINE__);
        }
        $this->TOUID = $tOUID;
        return $this;
    }
    /**
     * Get EffectiveDateFrom value
     * @return string
     */
    public function getEffectiveDateFrom()
    {
        return $this->EffectiveDateFrom;
    }
    /**
     * Set EffectiveDateFrom value
     * @param string $effectiveDateFrom
     * @return \SGCIS\Struct\Charge
     */
    public function setEffectiveDateFrom($effectiveDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateFrom) && !is_string($effectiveDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDateFrom)), __LINE__);
        }
        $this->EffectiveDateFrom = $effectiveDateFrom;
        return $this;
    }
    /**
     * Get EffectiveDateTo value
     * @return string
     */
    public function getEffectiveDateTo()
    {
        return $this->EffectiveDateTo;
    }
    /**
     * Set EffectiveDateTo value
     * @param string $effectiveDateTo
     * @return \SGCIS\Struct\Charge
     */
    public function setEffectiveDateTo($effectiveDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateTo) && !is_string($effectiveDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($effectiveDateTo)), __LINE__);
        }
        $this->EffectiveDateTo = $effectiveDateTo;
        return $this;
    }
    /**
     * Get ChargeAmount value
     * @return float
     */
    public function getChargeAmount()
    {
        return $this->ChargeAmount;
    }
    /**
     * Set ChargeAmount value
     * @param float $chargeAmount
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeAmount($chargeAmount = null)
    {
        $this->ChargeAmount = $chargeAmount;
        return $this;
    }
    /**
     * Get ChargeAmountContracted value
     * @return float
     */
    public function getChargeAmountContracted()
    {
        return $this->ChargeAmountContracted;
    }
    /**
     * Set ChargeAmountContracted value
     * @param float $chargeAmountContracted
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeAmountContracted($chargeAmountContracted = null)
    {
        $this->ChargeAmountContracted = $chargeAmountContracted;
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \SGCIS\Struct\Charge
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsReconciliationCharge value
     * @return bool
     */
    public function getIsReconciliationCharge()
    {
        return $this->IsReconciliationCharge;
    }
    /**
     * Set IsReconciliationCharge value
     * @param bool $isReconciliationCharge
     * @return \SGCIS\Struct\Charge
     */
    public function setIsReconciliationCharge($isReconciliationCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReconciliationCharge) && !is_bool($isReconciliationCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isReconciliationCharge)), __LINE__);
        }
        $this->IsReconciliationCharge = $isReconciliationCharge;
        return $this;
    }
    /**
     * Get IsAutoReconcileCharge value
     * @return bool
     */
    public function getIsAutoReconcileCharge()
    {
        return $this->IsAutoReconcileCharge;
    }
    /**
     * Set IsAutoReconcileCharge value
     * @param bool $isAutoReconcileCharge
     * @return \SGCIS\Struct\Charge
     */
    public function setIsAutoReconcileCharge($isAutoReconcileCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoReconcileCharge) && !is_bool($isAutoReconcileCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isAutoReconcileCharge)), __LINE__);
        }
        $this->IsAutoReconcileCharge = $isAutoReconcileCharge;
        return $this;
    }
    /**
     * Get IsContractUpdate value
     * @return bool
     */
    public function getIsContractUpdate()
    {
        return $this->IsContractUpdate;
    }
    /**
     * Set IsContractUpdate value
     * @param bool $isContractUpdate
     * @return \SGCIS\Struct\Charge
     */
    public function setIsContractUpdate($isContractUpdate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isContractUpdate) && !is_bool($isContractUpdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isContractUpdate)), __LINE__);
        }
        $this->IsContractUpdate = $isContractUpdate;
        return $this;
    }
    /**
     * Get IsTaxable value
     * @return bool
     */
    public function getIsTaxable()
    {
        return $this->IsTaxable;
    }
    /**
     * Set IsTaxable value
     * @param bool $isTaxable
     * @return \SGCIS\Struct\Charge
     */
    public function setIsTaxable($isTaxable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTaxable) && !is_bool($isTaxable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isTaxable)), __LINE__);
        }
        $this->IsTaxable = $isTaxable;
        return $this;
    }
    /**
     * Get ThresholdVolume value
     * @return float
     */
    public function getThresholdVolume()
    {
        return $this->ThresholdVolume;
    }
    /**
     * Set ThresholdVolume value
     * @param float $thresholdVolume
     * @return \SGCIS\Struct\Charge
     */
    public function setThresholdVolume($thresholdVolume = null)
    {
        $this->ThresholdVolume = $thresholdVolume;
        return $this;
    }
    /**
     * Get BelowThresholdCharge value
     * @return float
     */
    public function getBelowThresholdCharge()
    {
        return $this->BelowThresholdCharge;
    }
    /**
     * Set BelowThresholdCharge value
     * @param float $belowThresholdCharge
     * @return \SGCIS\Struct\Charge
     */
    public function setBelowThresholdCharge($belowThresholdCharge = null)
    {
        $this->BelowThresholdCharge = $belowThresholdCharge;
        return $this;
    }
    /**
     * Get AboveThresholdCharge value
     * @return float
     */
    public function getAboveThresholdCharge()
    {
        return $this->AboveThresholdCharge;
    }
    /**
     * Set AboveThresholdCharge value
     * @param float $aboveThresholdCharge
     * @return \SGCIS\Struct\Charge
     */
    public function setAboveThresholdCharge($aboveThresholdCharge = null)
    {
        $this->AboveThresholdCharge = $aboveThresholdCharge;
        return $this;
    }
    /**
     * Get ChargeIndexTypeID value
     * @return int
     */
    public function getChargeIndexTypeID()
    {
        return $this->ChargeIndexTypeID;
    }
    /**
     * Set ChargeIndexTypeID value
     * @param int $chargeIndexTypeID
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeIndexTypeID($chargeIndexTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($chargeIndexTypeID) && !is_numeric($chargeIndexTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeIndexTypeID)), __LINE__);
        }
        $this->ChargeIndexTypeID = $chargeIndexTypeID;
        return $this;
    }
    /**
     * Get ChargeIndexMinChargeAmount value
     * @return float
     */
    public function getChargeIndexMinChargeAmount()
    {
        return $this->ChargeIndexMinChargeAmount;
    }
    /**
     * Set ChargeIndexMinChargeAmount value
     * @param float $chargeIndexMinChargeAmount
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeIndexMinChargeAmount($chargeIndexMinChargeAmount = null)
    {
        $this->ChargeIndexMinChargeAmount = $chargeIndexMinChargeAmount;
        return $this;
    }
    /**
     * Get ChargeIndexMaxChargeAmount value
     * @return float
     */
    public function getChargeIndexMaxChargeAmount()
    {
        return $this->ChargeIndexMaxChargeAmount;
    }
    /**
     * Set ChargeIndexMaxChargeAmount value
     * @param float $chargeIndexMaxChargeAmount
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeIndexMaxChargeAmount($chargeIndexMaxChargeAmount = null)
    {
        $this->ChargeIndexMaxChargeAmount = $chargeIndexMaxChargeAmount;
        return $this;
    }
    /**
     * Get DateApproved value
     * @return string
     */
    public function getDateApproved()
    {
        return $this->DateApproved;
    }
    /**
     * Set DateApproved value
     * @param string $dateApproved
     * @return \SGCIS\Struct\Charge
     */
    public function setDateApproved($dateApproved = null)
    {
        // validation for constraint: string
        if (!is_null($dateApproved) && !is_string($dateApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateApproved)), __LINE__);
        }
        $this->DateApproved = $dateApproved;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \SGCIS\Struct\Charge
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get LastUpdateDate value
     * @return string
     */
    public function getLastUpdateDate()
    {
        return $this->LastUpdateDate;
    }
    /**
     * Set LastUpdateDate value
     * @param string $lastUpdateDate
     * @return \SGCIS\Struct\Charge
     */
    public function setLastUpdateDate($lastUpdateDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdateDate) && !is_string($lastUpdateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdateDate)), __LINE__);
        }
        $this->LastUpdateDate = $lastUpdateDate;
        return $this;
    }
    /**
     * Get UnitOfMeasureID value
     * @return int
     */
    public function getUnitOfMeasureID()
    {
        return $this->UnitOfMeasureID;
    }
    /**
     * Set UnitOfMeasureID value
     * @param int $unitOfMeasureID
     * @return \SGCIS\Struct\Charge
     */
    public function setUnitOfMeasureID($unitOfMeasureID = null)
    {
        // validation for constraint: int
        if (!is_null($unitOfMeasureID) && !is_numeric($unitOfMeasureID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($unitOfMeasureID)), __LINE__);
        }
        $this->UnitOfMeasureID = $unitOfMeasureID;
        return $this;
    }
    /**
     * Get IncludedUnits value
     * @return float
     */
    public function getIncludedUnits()
    {
        return $this->IncludedUnits;
    }
    /**
     * Set IncludedUnits value
     * @param float $includedUnits
     * @return \SGCIS\Struct\Charge
     */
    public function setIncludedUnits($includedUnits = null)
    {
        $this->IncludedUnits = $includedUnits;
        return $this;
    }
    /**
     * Get OverageUnitPrice value
     * @return float
     */
    public function getOverageUnitPrice()
    {
        return $this->OverageUnitPrice;
    }
    /**
     * Set OverageUnitPrice value
     * @param float $overageUnitPrice
     * @return \SGCIS\Struct\Charge
     */
    public function setOverageUnitPrice($overageUnitPrice = null)
    {
        $this->OverageUnitPrice = $overageUnitPrice;
        return $this;
    }
    /**
     * Get CustomChargeModuleID value
     * @return int
     */
    public function getCustomChargeModuleID()
    {
        return $this->CustomChargeModuleID;
    }
    /**
     * Set CustomChargeModuleID value
     * @param int $customChargeModuleID
     * @return \SGCIS\Struct\Charge
     */
    public function setCustomChargeModuleID($customChargeModuleID = null)
    {
        // validation for constraint: int
        if (!is_null($customChargeModuleID) && !is_numeric($customChargeModuleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customChargeModuleID)), __LINE__);
        }
        $this->CustomChargeModuleID = $customChargeModuleID;
        return $this;
    }
    /**
     * Get IsApproved value
     * @return bool
     */
    public function getIsApproved()
    {
        return $this->IsApproved;
    }
    /**
     * Set IsApproved value
     * @param bool $isApproved
     * @return \SGCIS\Struct\Charge
     */
    public function setIsApproved($isApproved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApproved) && !is_bool($isApproved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isApproved)), __LINE__);
        }
        $this->IsApproved = $isApproved;
        return $this;
    }
    /**
     * Get IsPassThrough value
     * @return bool
     */
    public function getIsPassThrough()
    {
        return $this->IsPassThrough;
    }
    /**
     * Set IsPassThrough value
     * @param bool $isPassThrough
     * @return \SGCIS\Struct\Charge
     */
    public function setIsPassThrough($isPassThrough = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPassThrough) && !is_bool($isPassThrough)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isPassThrough)), __LINE__);
        }
        $this->IsPassThrough = $isPassThrough;
        return $this;
    }
    /**
     * Get TotalChargeAmount value
     * @return float
     */
    public function getTotalChargeAmount()
    {
        return $this->TotalChargeAmount;
    }
    /**
     * Set TotalChargeAmount value
     * @param float $totalChargeAmount
     * @return \SGCIS\Struct\Charge
     */
    public function setTotalChargeAmount($totalChargeAmount = null)
    {
        $this->TotalChargeAmount = $totalChargeAmount;
        return $this;
    }
    /**
     * Get MinChargeAmount value
     * @return float
     */
    public function getMinChargeAmount()
    {
        return $this->MinChargeAmount;
    }
    /**
     * Set MinChargeAmount value
     * @param float $minChargeAmount
     * @return \SGCIS\Struct\Charge
     */
    public function setMinChargeAmount($minChargeAmount = null)
    {
        $this->MinChargeAmount = $minChargeAmount;
        return $this;
    }
    /**
     * Get MinChargeThreshold value
     * @return float
     */
    public function getMinChargeThreshold()
    {
        return $this->MinChargeThreshold;
    }
    /**
     * Set MinChargeThreshold value
     * @param float $minChargeThreshold
     * @return \SGCIS\Struct\Charge
     */
    public function setMinChargeThreshold($minChargeThreshold = null)
    {
        $this->MinChargeThreshold = $minChargeThreshold;
        return $this;
    }
    /**
     * Get TransactionTypeID value
     * @return int
     */
    public function getTransactionTypeID()
    {
        return $this->TransactionTypeID;
    }
    /**
     * Set TransactionTypeID value
     * @param int $transactionTypeID
     * @return \SGCIS\Struct\Charge
     */
    public function setTransactionTypeID($transactionTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTypeID) && !is_numeric($transactionTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionTypeID)), __LINE__);
        }
        $this->TransactionTypeID = $transactionTypeID;
        return $this;
    }
    /**
     * Get TransactionTypeCategoryID value
     * @return int
     */
    public function getTransactionTypeCategoryID()
    {
        return $this->TransactionTypeCategoryID;
    }
    /**
     * Set TransactionTypeCategoryID value
     * @param int $transactionTypeCategoryID
     * @return \SGCIS\Struct\Charge
     */
    public function setTransactionTypeCategoryID($transactionTypeCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($transactionTypeCategoryID) && !is_numeric($transactionTypeCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($transactionTypeCategoryID)), __LINE__);
        }
        $this->TransactionTypeCategoryID = $transactionTypeCategoryID;
        return $this;
    }
    /**
     * Get IsBaseCharge value
     * @return bool
     */
    public function getIsBaseCharge()
    {
        return $this->IsBaseCharge;
    }
    /**
     * Set IsBaseCharge value
     * @param bool $isBaseCharge
     * @return \SGCIS\Struct\Charge
     */
    public function setIsBaseCharge($isBaseCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBaseCharge) && !is_bool($isBaseCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isBaseCharge)), __LINE__);
        }
        $this->IsBaseCharge = $isBaseCharge;
        return $this;
    }
    /**
     * Get DistributionServiceProviderID value
     * @return int
     */
    public function getDistributionServiceProviderID()
    {
        return $this->DistributionServiceProviderID;
    }
    /**
     * Set DistributionServiceProviderID value
     * @param int $distributionServiceProviderID
     * @return \SGCIS\Struct\Charge
     */
    public function setDistributionServiceProviderID($distributionServiceProviderID = null)
    {
        // validation for constraint: int
        if (!is_null($distributionServiceProviderID) && !is_numeric($distributionServiceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($distributionServiceProviderID)), __LINE__);
        }
        $this->DistributionServiceProviderID = $distributionServiceProviderID;
        return $this;
    }
    /**
     * Get IsServiceAgreementCharge value
     * @return bool
     */
    public function getIsServiceAgreementCharge()
    {
        return $this->IsServiceAgreementCharge;
    }
    /**
     * Set IsServiceAgreementCharge value
     * @param bool $isServiceAgreementCharge
     * @return \SGCIS\Struct\Charge
     */
    public function setIsServiceAgreementCharge($isServiceAgreementCharge = null)
    {
        // validation for constraint: boolean
        if (!is_null($isServiceAgreementCharge) && !is_bool($isServiceAgreementCharge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isServiceAgreementCharge)), __LINE__);
        }
        $this->IsServiceAgreementCharge = $isServiceAgreementCharge;
        return $this;
    }
    /**
     * Get PremiseTypeID value
     * @return int
     */
    public function getPremiseTypeID()
    {
        return $this->PremiseTypeID;
    }
    /**
     * Set PremiseTypeID value
     * @param int $premiseTypeID
     * @return \SGCIS\Struct\Charge
     */
    public function setPremiseTypeID($premiseTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($premiseTypeID) && !is_numeric($premiseTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($premiseTypeID)), __LINE__);
        }
        $this->PremiseTypeID = $premiseTypeID;
        return $this;
    }
    /**
     * Get UOMQuantity value
     * @return int
     */
    public function getUOMQuantity()
    {
        return $this->UOMQuantity;
    }
    /**
     * Set UOMQuantity value
     * @param int $uOMQuantity
     * @return \SGCIS\Struct\Charge
     */
    public function setUOMQuantity($uOMQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($uOMQuantity) && !is_numeric($uOMQuantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uOMQuantity)), __LINE__);
        }
        $this->UOMQuantity = $uOMQuantity;
        return $this;
    }
    /**
     * Get MarketPricingNodeHistoryTypeID value
     * @return int
     */
    public function getMarketPricingNodeHistoryTypeID()
    {
        return $this->MarketPricingNodeHistoryTypeID;
    }
    /**
     * Set MarketPricingNodeHistoryTypeID value
     * @param int $marketPricingNodeHistoryTypeID
     * @return \SGCIS\Struct\Charge
     */
    public function setMarketPricingNodeHistoryTypeID($marketPricingNodeHistoryTypeID = null)
    {
        // validation for constraint: int
        if (!is_null($marketPricingNodeHistoryTypeID) && !is_numeric($marketPricingNodeHistoryTypeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($marketPricingNodeHistoryTypeID)), __LINE__);
        }
        $this->MarketPricingNodeHistoryTypeID = $marketPricingNodeHistoryTypeID;
        return $this;
    }
    /**
     * Get ChargeName value
     * @return string|null
     */
    public function getChargeName()
    {
        return $this->ChargeName;
    }
    /**
     * Set ChargeName value
     * @param string $chargeName
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeName($chargeName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeName) && !is_string($chargeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeName)), __LINE__);
        }
        $this->ChargeName = $chargeName;
        return $this;
    }
    /**
     * Get ChargeCode value
     * @return string|null
     */
    public function getChargeCode()
    {
        return $this->ChargeCode;
    }
    /**
     * Set ChargeCode value
     * @param string $chargeCode
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeCode($chargeCode = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCode) && !is_string($chargeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCode)), __LINE__);
        }
        $this->ChargeCode = $chargeCode;
        return $this;
    }
    /**
     * Get ChargeDescription value
     * @return string|null
     */
    public function getChargeDescription()
    {
        return $this->ChargeDescription;
    }
    /**
     * Set ChargeDescription value
     * @param string $chargeDescription
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeDescription($chargeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($chargeDescription) && !is_string($chargeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeDescription)), __LINE__);
        }
        $this->ChargeDescription = $chargeDescription;
        return $this;
    }
    /**
     * Get BillDisplayDescription value
     * @return string|null
     */
    public function getBillDisplayDescription()
    {
        return $this->BillDisplayDescription;
    }
    /**
     * Set BillDisplayDescription value
     * @param string $billDisplayDescription
     * @return \SGCIS\Struct\Charge
     */
    public function setBillDisplayDescription($billDisplayDescription = null)
    {
        // validation for constraint: string
        if (!is_null($billDisplayDescription) && !is_string($billDisplayDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($billDisplayDescription)), __LINE__);
        }
        $this->BillDisplayDescription = $billDisplayDescription;
        return $this;
    }
    /**
     * Get ApprovedByUserName value
     * @return string|null
     */
    public function getApprovedByUserName()
    {
        return $this->ApprovedByUserName;
    }
    /**
     * Set ApprovedByUserName value
     * @param string $approvedByUserName
     * @return \SGCIS\Struct\Charge
     */
    public function setApprovedByUserName($approvedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($approvedByUserName) && !is_string($approvedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($approvedByUserName)), __LINE__);
        }
        $this->ApprovedByUserName = $approvedByUserName;
        return $this;
    }
    /**
     * Get CreatedByUserName value
     * @return string|null
     */
    public function getCreatedByUserName()
    {
        return $this->CreatedByUserName;
    }
    /**
     * Set CreatedByUserName value
     * @param string $createdByUserName
     * @return \SGCIS\Struct\Charge
     */
    public function setCreatedByUserName($createdByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUserName) && !is_string($createdByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdByUserName)), __LINE__);
        }
        $this->CreatedByUserName = $createdByUserName;
        return $this;
    }
    /**
     * Get LastUpdatedByUserName value
     * @return string|null
     */
    public function getLastUpdatedByUserName()
    {
        return $this->LastUpdatedByUserName;
    }
    /**
     * Set LastUpdatedByUserName value
     * @param string $lastUpdatedByUserName
     * @return \SGCIS\Struct\Charge
     */
    public function setLastUpdatedByUserName($lastUpdatedByUserName = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdatedByUserName) && !is_string($lastUpdatedByUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastUpdatedByUserName)), __LINE__);
        }
        $this->LastUpdatedByUserName = $lastUpdatedByUserName;
        return $this;
    }
    /**
     * Get TaxTransactionTypeCodeID value
     * @return string|null
     */
    public function getTaxTransactionTypeCodeID()
    {
        return $this->TaxTransactionTypeCodeID;
    }
    /**
     * Set TaxTransactionTypeCodeID value
     * @param string $taxTransactionTypeCodeID
     * @return \SGCIS\Struct\Charge
     */
    public function setTaxTransactionTypeCodeID($taxTransactionTypeCodeID = null)
    {
        // validation for constraint: string
        if (!is_null($taxTransactionTypeCodeID) && !is_string($taxTransactionTypeCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxTransactionTypeCodeID)), __LINE__);
        }
        $this->TaxTransactionTypeCodeID = $taxTransactionTypeCodeID;
        return $this;
    }
    /**
     * Get TieredRates value
     * @return string|null
     */
    public function getTieredRates()
    {
        return $this->TieredRates;
    }
    /**
     * Set TieredRates value
     * @param string $tieredRates
     * @return \SGCIS\Struct\Charge
     */
    public function setTieredRates($tieredRates = null)
    {
        // validation for constraint: string
        if (!is_null($tieredRates) && !is_string($tieredRates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tieredRates)), __LINE__);
        }
        $this->TieredRates = $tieredRates;
        return $this;
    }
    /**
     * Get ChargeCategoryName value
     * @return string|null
     */
    public function getChargeCategoryName()
    {
        return $this->ChargeCategoryName;
    }
    /**
     * Set ChargeCategoryName value
     * @param string $chargeCategoryName
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeCategoryName($chargeCategoryName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeCategoryName) && !is_string($chargeCategoryName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeCategoryName)), __LINE__);
        }
        $this->ChargeCategoryName = $chargeCategoryName;
        return $this;
    }
    /**
     * Get ChargeModelName value
     * @return string|null
     */
    public function getChargeModelName()
    {
        return $this->ChargeModelName;
    }
    /**
     * Set ChargeModelName value
     * @param string $chargeModelName
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeModelName($chargeModelName = null)
    {
        // validation for constraint: string
        if (!is_null($chargeModelName) && !is_string($chargeModelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($chargeModelName)), __LINE__);
        }
        $this->ChargeModelName = $chargeModelName;
        return $this;
    }
    /**
     * Get ChargeAccountType value
     * @return \SGCIS\Array\ArrayOfChargeAccountType|null
     */
    public function getChargeAccountType()
    {
        return $this->ChargeAccountType;
    }
    /**
     * Set ChargeAccountType value
     * @param \SGCIS\Array\ArrayOfChargeAccountType $chargeAccountType
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeAccountType(\SGCIS\Array\ArrayOfChargeAccountType $chargeAccountType = null)
    {
        $this->ChargeAccountType = $chargeAccountType;
        return $this;
    }
    /**
     * Get ChargeDistributionServiceProvider value
     * @return \SGCIS\Array\ArrayOfChargeDistributionServiceProvider|null
     */
    public function getChargeDistributionServiceProvider()
    {
        return $this->ChargeDistributionServiceProvider;
    }
    /**
     * Set ChargeDistributionServiceProvider value
     * @param \SGCIS\Array\ArrayOfChargeDistributionServiceProvider $chargeDistributionServiceProvider
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeDistributionServiceProvider(\SGCIS\Array\ArrayOfChargeDistributionServiceProvider $chargeDistributionServiceProvider = null)
    {
        $this->ChargeDistributionServiceProvider = $chargeDistributionServiceProvider;
        return $this;
    }
    /**
     * Get ChargeTier value
     * @return \SGCIS\Array\ArrayOfChargeTier|null
     */
    public function getChargeTier()
    {
        return $this->ChargeTier;
    }
    /**
     * Set ChargeTier value
     * @param \SGCIS\Array\ArrayOfChargeTier $chargeTier
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeTier(\SGCIS\Array\ArrayOfChargeTier $chargeTier = null)
    {
        $this->ChargeTier = $chargeTier;
        return $this;
    }
    /**
     * Get ChargeSchedule value
     * @return \SGCIS\Struct\ChargeSchedule|null
     */
    public function getChargeSchedule()
    {
        return $this->ChargeSchedule;
    }
    /**
     * Set ChargeSchedule value
     * @param \SGCIS\Struct\ChargeSchedule $chargeSchedule
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeSchedule(\SGCIS\Struct\ChargeSchedule $chargeSchedule = null)
    {
        $this->ChargeSchedule = $chargeSchedule;
        return $this;
    }
    /**
     * Get TOU value
     * @return \SGCIS\Struct\TOU|null
     */
    public function getTOU()
    {
        return $this->TOU;
    }
    /**
     * Set TOU value
     * @param \SGCIS\Struct\TOU $tOU
     * @return \SGCIS\Struct\Charge
     */
    public function setTOU(\SGCIS\Struct\TOU $tOU = null)
    {
        $this->TOU = $tOU;
        return $this;
    }
    /**
     * Get TOUChargeSchedules value
     * @return \SGCIS\Array\ArrayOfTOU|null
     */
    public function getTOUChargeSchedules()
    {
        return $this->TOUChargeSchedules;
    }
    /**
     * Set TOUChargeSchedules value
     * @param \SGCIS\Array\ArrayOfTOU $tOUChargeSchedules
     * @return \SGCIS\Struct\Charge
     */
    public function setTOUChargeSchedules(\SGCIS\Array\ArrayOfTOU $tOUChargeSchedules = null)
    {
        $this->TOUChargeSchedules = $tOUChargeSchedules;
        return $this;
    }
    /**
     * Get ChargeCharacteristic value
     * @return \SGCIS\Array\ArrayOfChargeCharacteristic|null
     */
    public function getChargeCharacteristic()
    {
        return $this->ChargeCharacteristic;
    }
    /**
     * Set ChargeCharacteristic value
     * @param \SGCIS\Array\ArrayOfChargeCharacteristic $chargeCharacteristic
     * @return \SGCIS\Struct\Charge
     */
    public function setChargeCharacteristic(\SGCIS\Array\ArrayOfChargeCharacteristic $chargeCharacteristic = null)
    {
        $this->ChargeCharacteristic = $chargeCharacteristic;
        return $this;
    }
    /**
     * Get DistributionServiceProviders value
     * @return string|null
     */
    public function getDistributionServiceProviders()
    {
        return $this->DistributionServiceProviders;
    }
    /**
     * Set DistributionServiceProviders value
     * @param string $distributionServiceProviders
     * @return \SGCIS\Struct\Charge
     */
    public function setDistributionServiceProviders($distributionServiceProviders = null)
    {
        // validation for constraint: string
        if (!is_null($distributionServiceProviders) && !is_string($distributionServiceProviders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distributionServiceProviders)), __LINE__);
        }
        $this->DistributionServiceProviders = $distributionServiceProviders;
        return $this;
    }
    /**
     * Get CustomRateName value
     * @return string|null
     */
    public function getCustomRateName()
    {
        return $this->CustomRateName;
    }
    /**
     * Set CustomRateName value
     * @param string $customRateName
     * @return \SGCIS\Struct\Charge
     */
    public function setCustomRateName($customRateName = null)
    {
        // validation for constraint: string
        if (!is_null($customRateName) && !is_string($customRateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customRateName)), __LINE__);
        }
        $this->CustomRateName = $customRateName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \SGCIS\Struct\Charge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
